-- phpMyAdmin SQL Dump
-- version 5.1.0
-- https://www.phpmyadmin.net/
--
-- Hôte : localhost:8889
-- Généré le : mar. 13 juil. 2021 à 11:54
-- Version du serveur :  5.7.32
-- Version de PHP : 7.4.16

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `siteswp`
--

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_appointments`
--

CREATE TABLE `wp_amelia_appointments` (
  `id` int(11) NOT NULL,
  `status` enum('approved','pending','canceled','rejected') DEFAULT NULL,
  `bookingStart` datetime NOT NULL,
  `bookingEnd` datetime NOT NULL,
  `notifyParticipants` tinyint(1) NOT NULL,
  `serviceId` int(11) NOT NULL,
  `packageId` int(11) DEFAULT NULL,
  `providerId` int(11) NOT NULL,
  `locationId` int(11) DEFAULT NULL,
  `internalNotes` text,
  `googleCalendarEventId` varchar(255) DEFAULT NULL,
  `outlookCalendarEventId` varchar(255) DEFAULT NULL,
  `zoomMeeting` text,
  `parentId` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_cache`
--

CREATE TABLE `wp_amelia_cache` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `paymentId` int(11) DEFAULT NULL,
  `data` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_categories`
--

CREATE TABLE `wp_amelia_categories` (
  `id` int(11) NOT NULL,
  `status` enum('hidden','visible','disabled') NOT NULL DEFAULT 'visible',
  `name` varchar(255) NOT NULL DEFAULT '',
  `position` int(11) NOT NULL,
  `translations` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_categories`
--

INSERT INTO `wp_amelia_categories` (`id`, `status`, `name`, `position`, `translations`) VALUES
(1, 'visible', 'Atelier En Ligne', 1, NULL),
(6, 'visible', 'HAUTS DE FRANCE', 2, NULL),
(7, 'visible', 'NORMANDIE', 3, NULL),
(8, 'visible', 'GRAND EST', 4, NULL),
(9, 'visible', 'BRETAGNE', 5, NULL),
(10, 'visible', 'PAYS DE LA LOIRE', 6, NULL),
(11, 'visible', 'BOURGOGNE - FRANCHE-COMTÉ', 7, NULL),
(12, 'visible', 'EURE ET LOIRE', 8, NULL),
(13, 'visible', 'NOUVELLE AQUITAINE', 9, NULL),
(14, 'visible', 'AUVERGNE - RHÔNE-ALPES', 10, NULL),
(15, 'visible', 'PROVENCE - ALPES - CÔTE D\'AZUR', 11, NULL),
(16, 'visible', 'PARIS', 12, NULL),
(17, 'visible', 'IDF', 13, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_coupons`
--

CREATE TABLE `wp_amelia_coupons` (
  `id` int(11) NOT NULL,
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `discount` double NOT NULL,
  `deduction` double NOT NULL,
  `limit` double NOT NULL,
  `customerLimit` double NOT NULL DEFAULT '0',
  `status` enum('hidden','visible') NOT NULL,
  `notificationInterval` int(11) NOT NULL DEFAULT '0',
  `notificationRecurring` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_coupons_to_events`
--

CREATE TABLE `wp_amelia_coupons_to_events` (
  `id` int(11) NOT NULL,
  `couponId` int(11) NOT NULL,
  `eventId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_coupons_to_services`
--

CREATE TABLE `wp_amelia_coupons_to_services` (
  `id` int(11) NOT NULL,
  `couponId` int(11) NOT NULL,
  `serviceId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_customer_bookings`
--

CREATE TABLE `wp_amelia_customer_bookings` (
  `id` int(11) NOT NULL,
  `appointmentId` int(11) DEFAULT NULL,
  `customerId` int(11) NOT NULL,
  `status` enum('approved','pending','canceled','rejected') DEFAULT NULL,
  `price` double NOT NULL,
  `persons` int(11) NOT NULL,
  `couponId` int(11) DEFAULT NULL,
  `token` varchar(10) DEFAULT NULL,
  `customFields` text,
  `info` text,
  `utcOffset` int(3) DEFAULT NULL,
  `aggregatedPrice` tinyint(1) DEFAULT '1',
  `packageCustomerServiceId` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_customer_bookings`
--

INSERT INTO `wp_amelia_customer_bookings` (`id`, `appointmentId`, `customerId`, `status`, `price`, `persons`, `couponId`, `token`, `customFields`, `info`, `utcOffset`, `aggregatedPrice`, `packageCustomerServiceId`) VALUES
(1, NULL, 2, 'approved', 0, 1, NULL, 'f559d0bcc3', NULL, '{\"firstName\":\"tata\",\"lastName\":\"rach\",\"phone\":\"0102030405\",\"locale\":\"\",\"timeZone\":null}', NULL, 1, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_customer_bookings_to_events_periods`
--

CREATE TABLE `wp_amelia_customer_bookings_to_events_periods` (
  `id` int(11) NOT NULL,
  `customerBookingId` int(11) NOT NULL,
  `eventPeriodId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_customer_bookings_to_events_periods`
--

INSERT INTO `wp_amelia_customer_bookings_to_events_periods` (`id`, `customerBookingId`, `eventPeriodId`) VALUES
(1, 1, 2);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_customer_bookings_to_extras`
--

CREATE TABLE `wp_amelia_customer_bookings_to_extras` (
  `id` int(11) NOT NULL,
  `customerBookingId` int(11) NOT NULL,
  `extraId` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `price` double NOT NULL,
  `aggregatedPrice` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_custom_fields`
--

CREATE TABLE `wp_amelia_custom_fields` (
  `id` int(11) NOT NULL,
  `label` text NOT NULL,
  `type` enum('text','text-area','select','checkbox','radio','content','file','datepicker') NOT NULL DEFAULT 'text',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL,
  `translations` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_custom_fields_events`
--

CREATE TABLE `wp_amelia_custom_fields_events` (
  `id` int(11) NOT NULL,
  `customFieldId` int(11) NOT NULL,
  `eventId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_custom_fields_options`
--

CREATE TABLE `wp_amelia_custom_fields_options` (
  `id` int(11) NOT NULL,
  `customFieldId` int(11) NOT NULL,
  `label` varchar(255) NOT NULL DEFAULT '',
  `position` int(11) NOT NULL,
  `translations` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_custom_fields_services`
--

CREATE TABLE `wp_amelia_custom_fields_services` (
  `id` int(11) NOT NULL,
  `customFieldId` int(11) NOT NULL,
  `serviceId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_events`
--

CREATE TABLE `wp_amelia_events` (
  `id` int(11) NOT NULL,
  `parentId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` enum('approved','pending','canceled','rejected') NOT NULL,
  `bookingOpens` datetime DEFAULT NULL,
  `bookingCloses` datetime DEFAULT NULL,
  `bookingOpensRec` enum('same','calculate') DEFAULT 'same',
  `bookingClosesRec` enum('same','calculate') DEFAULT 'same',
  `recurringCycle` enum('daily','weekly','monthly','yearly') DEFAULT NULL,
  `recurringOrder` int(11) DEFAULT NULL,
  `recurringInterval` int(11) DEFAULT '1',
  `recurringMonthly` enum('each','on') DEFAULT 'each',
  `monthlyDate` datetime DEFAULT NULL,
  `monthlyOnRepeat` enum('first','second','third','fourth','last') DEFAULT NULL,
  `monthlyOnDay` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') DEFAULT NULL,
  `recurringUntil` datetime DEFAULT NULL,
  `maxCapacity` int(11) NOT NULL,
  `price` double NOT NULL,
  `locationId` int(11) DEFAULT NULL,
  `customLocation` varchar(255) DEFAULT NULL,
  `description` text,
  `color` varchar(255) DEFAULT NULL,
  `show` tinyint(1) NOT NULL DEFAULT '1',
  `notifyParticipants` tinyint(1) NOT NULL,
  `created` datetime NOT NULL,
  `settings` text,
  `zoomUserId` varchar(255) DEFAULT NULL,
  `bringingAnyone` tinyint(1) DEFAULT '1',
  `bookMultipleTimes` tinyint(1) DEFAULT '1',
  `translations` text,
  `depositPayment` enum('disabled','fixed','percentage') DEFAULT 'disabled',
  `depositPerPerson` tinyint(1) DEFAULT '1',
  `deposit` double DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_events`
--

INSERT INTO `wp_amelia_events` (`id`, `parentId`, `name`, `status`, `bookingOpens`, `bookingCloses`, `bookingOpensRec`, `bookingClosesRec`, `recurringCycle`, `recurringOrder`, `recurringInterval`, `recurringMonthly`, `monthlyDate`, `monthlyOnRepeat`, `monthlyOnDay`, `recurringUntil`, `maxCapacity`, `price`, `locationId`, `customLocation`, `description`, `color`, `show`, `notifyParticipants`, `created`, `settings`, `zoomUserId`, `bringingAnyone`, `bookMultipleTimes`, `translations`, `depositPayment`, `depositPerPerson`, `deposit`) VALUES
(1, NULL, 'atelier en ligne', 'approved', NULL, NULL, 'same', 'same', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 10, 0, 1, NULL, NULL, '#1788FB', 1, 1, '2021-07-10 09:10:34', '{\"payments\":{\"onSite\":true,\"payPal\":{\"enabled\":false},\"stripe\":{\"enabled\":false},\"mollie\":{\"enabled\":false}},\"general\":{\"minimumTimeRequirementPriorToCanceling\":null,\"redirectUrlAfterAppointment\":null},\"zoom\":{\"enabled\":false}}', NULL, 0, 0, NULL, 'disabled', 1, 0),
(2, NULL, 'Atelier en centre - Hôpital privé Le Bois', 'approved', NULL, NULL, 'same', 'same', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 10, 0, 4, NULL, NULL, '#1788FB', 1, 1, '2021-07-10 09:32:48', '{\"payments\":{\"onSite\":true,\"payPal\":{\"enabled\":false},\"stripe\":{\"enabled\":false},\"mollie\":{\"enabled\":false}},\"general\":{\"minimumTimeRequirementPriorToCanceling\":null,\"redirectUrlAfterAppointment\":null},\"zoom\":{\"enabled\":false}}', NULL, 0, 0, NULL, 'disabled', 1, 0),
(4, NULL, 'Atelier online', 'approved', NULL, NULL, 'same', 'same', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 6, 0, 1, NULL, NULL, '#1788FB', 1, 1, '2021-07-13 13:34:18', '{\"payments\":{\"onSite\":true,\"payPal\":{\"enabled\":false},\"stripe\":{\"enabled\":false},\"mollie\":{\"enabled\":false}},\"general\":{\"minimumTimeRequirementPriorToCanceling\":null,\"redirectUrlAfterAppointment\":null},\"zoom\":{\"enabled\":false}}', NULL, 1, 1, NULL, 'disabled', 1, 0);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_events_periods`
--

CREATE TABLE `wp_amelia_events_periods` (
  `id` int(11) NOT NULL,
  `eventId` int(11) NOT NULL,
  `periodStart` datetime NOT NULL,
  `periodEnd` datetime NOT NULL,
  `zoomMeeting` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_events_periods`
--

INSERT INTO `wp_amelia_events_periods` (`id`, `eventId`, `periodStart`, `periodEnd`, `zoomMeeting`) VALUES
(1, 1, '2021-07-12 12:00:00', '2021-07-12 15:30:00', NULL),
(2, 2, '2021-07-13 11:00:00', '2021-07-13 14:00:00', NULL),
(4, 4, '2021-07-16 00:00:00', '2021-07-16 01:00:00', NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_events_tags`
--

CREATE TABLE `wp_amelia_events_tags` (
  `id` int(11) NOT NULL,
  `eventId` int(11) NOT NULL,
  `name` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_events_tags`
--

INSERT INTO `wp_amelia_events_tags` (`id`, `eventId`, `name`) VALUES
(9, 2, 'idf');

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_events_to_providers`
--

CREATE TABLE `wp_amelia_events_to_providers` (
  `id` int(11) NOT NULL,
  `eventId` int(11) NOT NULL,
  `userId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_events_to_providers`
--

INSERT INTO `wp_amelia_events_to_providers` (`id`, `eventId`, `userId`) VALUES
(7, 4, 1);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_extras`
--

CREATE TABLE `wp_amelia_extras` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `price` double NOT NULL,
  `maxQuantity` int(11) NOT NULL,
  `duration` int(11) DEFAULT NULL,
  `serviceId` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  `aggregatedPrice` tinyint(1) DEFAULT NULL,
  `translations` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_galleries`
--

CREATE TABLE `wp_amelia_galleries` (
  `id` int(11) NOT NULL,
  `entityId` int(11) NOT NULL,
  `entityType` enum('service','event','package') NOT NULL,
  `pictureFullPath` varchar(767) DEFAULT NULL,
  `pictureThumbPath` varchar(767) DEFAULT NULL,
  `position` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_locations`
--

CREATE TABLE `wp_amelia_locations` (
  `id` int(11) NOT NULL,
  `status` enum('hidden','visible','disabled') NOT NULL DEFAULT 'visible',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `address` varchar(255) NOT NULL,
  `phone` varchar(63) NOT NULL,
  `latitude` decimal(8,6) NOT NULL,
  `longitude` decimal(9,6) NOT NULL,
  `pictureFullPath` varchar(767) DEFAULT NULL,
  `pictureThumbPath` varchar(767) DEFAULT NULL,
  `pin` mediumtext
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_locations`
--

INSERT INTO `wp_amelia_locations` (`id`, `status`, `name`, `description`, `address`, `phone`, `latitude`, `longitude`, `pictureFullPath`, `pictureThumbPath`, `pin`) VALUES
(1, 'visible', 'Hôpital privé Le Bois', 'test', '', '+1102030405', '40.748441', '-73.987853', NULL, NULL, ''),
(2, 'visible', 'Centre Oscar Lambret', '', '', '', '40.748441', '-73.987853', NULL, NULL, ''),
(3, 'visible', 'Hôpital Privé la Louvière', '', '', '', '40.748441', '-73.987853', NULL, NULL, ''),
(4, 'visible', 'Clinique de la Victoire', '', '', '', '40.748441', '-73.987853', NULL, NULL, '');

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_locations_views`
--

CREATE TABLE `wp_amelia_locations_views` (
  `id` int(11) NOT NULL,
  `locationId` int(11) NOT NULL,
  `date` date NOT NULL,
  `views` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_notifications`
--

CREATE TABLE `wp_amelia_notifications` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `type` enum('email','sms') NOT NULL,
  `entity` enum('appointment','event') NOT NULL DEFAULT 'appointment',
  `time` time DEFAULT NULL,
  `timeBefore` int(11) DEFAULT NULL,
  `timeAfter` int(11) DEFAULT NULL,
  `sendTo` enum('customer','provider') NOT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `content` text,
  `translations` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_notifications`
--

INSERT INTO `wp_amelia_notifications` (`id`, `name`, `status`, `type`, `entity`, `time`, `timeBefore`, `timeAfter`, `sendTo`, `subject`, `content`, `translations`) VALUES
(1, 'customer_appointment_approved', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'customer', '%service_name% Appointment Approved', 'Dear <strong>%customer_full_name%</strong>,<br><br>You have successfully scheduled\n                     <strong>%service_name%</strong> appointment with <strong>%employee_full_name%</strong>. We are \n                     waiting you at <strong>%location_address% </strong>on <strong>%appointment_date_time%</strong>.\n                     <br><br>Thank you for choosing our company,<br><strong>%company_name%</strong>', NULL),
(2, 'customer_appointment_pending', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'customer', '%service_name% Appointment Pending', 'Dear <strong>%customer_full_name%</strong>,<br><br>The <strong>%service_name%</strong> appointment \n                     with <strong>%employee_full_name%</strong> at <strong>%location_address%</strong>, scheduled for\n                     <strong>%appointment_date_time%</strong> is waiting for a confirmation.<br><br>Thank you for \n                     choosing our company,<br><strong>%company_name%</strong>', NULL),
(3, 'customer_appointment_rejected', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'customer', '%service_name% Appointment Rejected', 'Dear <strong>%customer_full_name%</strong>,<br><br>Your <strong>%service_name%</strong> \n                     appointment, scheduled on <strong>%appointment_date_time%</strong> at <strong>%location_address%\n                     </strong>has been rejected.<br><br>Thank you for choosing our company,\n                     <br><strong>%company_name%</strong>', NULL),
(4, 'customer_appointment_canceled', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'customer', '%service_name% Appointment Canceled', 'Dear <strong>%customer_full_name%</strong>,<br><br>Your <strong>%service_name%</strong> \n                     appointment, scheduled on <strong>%appointment_date_time%</strong> at <strong>%location_address%\n                     </strong>has been canceled.<br><br>Thank you for choosing our company,\n                     <br><strong>%company_name%</strong>', NULL),
(5, 'customer_appointment_rescheduled', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'customer', '%service_name% Appointment Rescheduled', 'Dear <strong>%customer_full_name%</strong>,<br><br>The details for your \n                     <strong>%service_name%</strong> appointment with <strong>%employee_full_name%</strong> at \n                     <strong>%location_name%</strong> has been changed. The appointment is now set for \n                     <strong>%appointment_date%</strong> at <strong>%appointment_start_time%</strong>.<br><br>\n                     Thank you for choosing our company,<br><strong>%company_name%</strong>', NULL),
(6, 'customer_appointment_next_day_reminder', 'enabled', 'email', 'appointment', '17:00:00', NULL, NULL, 'customer', '%service_name% Appointment Reminder', 'Dear <strong>%customer_full_name%</strong>,<br><br>We would like to remind you that you have \n                     <strong>%service_name%</strong> appointment tomorrow at <strong>%appointment_start_time%</strong>.\n                     We are waiting for you at <strong>%location_name%</strong>.<br><br>Thank you for \n                     choosing our company,<br><strong>%company_name%</strong>', NULL),
(7, 'customer_appointment_follow_up', 'enabled', 'email', 'appointment', NULL, NULL, 1800, 'customer', '%service_name% Appointment Follow Up', 'Dear <strong>%customer_full_name%</strong>,<br><br>Thank you once again for choosing our company. \n                     We hope you were satisfied with your <strong>%service_name%</strong>.<br><br>We look forward to \n                     seeing you again soon,<br><strong>%company_name%</strong>', NULL),
(8, 'customer_birthday_greeting', 'enabled', 'email', 'appointment', '17:00:00', NULL, NULL, 'customer', 'Happy Birthday', 'Dear <strong>%customer_full_name%</strong>,<br><br>Happy birthday!<br>We wish you all the best.\n                    <br><br>Thank you for choosing our company,<br><strong>%company_name%</strong>', NULL),
(9, 'provider_appointment_approved', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'provider', '%service_name% Appointment Approved', 'Hi <strong>%employee_full_name%</strong>,<br><br>You have one confirmed \n                     <strong>%service_name%</strong> appointment at <strong>%location_name%</strong> on \n                     <strong>%appointment_date%</strong> at <strong>%appointment_start_time%</strong>. The appointment \n                     is added to your schedule.<br><br>Thank you,<br><strong>%company_name%</strong>', NULL),
(10, 'provider_appointment_pending', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'provider', '%service_name% Appointment Pending', 'Hi <strong>%employee_full_name%</strong>,<br><br>You have new appointment \n                     in <strong>%service_name%</strong>. The appointment is waiting for a confirmation.<br><br>Thank \n                     you,<br><strong>%company_name%</strong>', NULL),
(11, 'provider_appointment_rejected', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'provider', '%service_name% Appointment Rejected', 'Hi <strong>%employee_full_name%</strong>,<br><br>Your <strong>%service_name%</strong> appointment \n                     at <strong>%location_name%</strong>, scheduled for <strong>%appointment_date%</strong> at  \n                     <strong>%appointment_start_time%</strong> has been rejected.\n                     <br><br>Thank you,<br><strong>%company_name%</strong>', NULL),
(12, 'provider_appointment_canceled', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'provider', '%service_name% Appointment Canceled', 'Hi <strong>%employee_full_name%</strong>,<br><br>Your <strong>%service_name%</strong> appointment,\n                     scheduled on <strong>%appointment_date%</strong>, at <strong>%location_name%</strong> has been \n                     canceled.<br><br>Thank you,<br><strong>%company_name%</strong>', NULL),
(13, 'provider_appointment_rescheduled', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'provider', '%service_name% Appointment Rescheduled', 'Hi <strong>%employee_full_name%</strong>,<br><br>The details for your \n                     <strong>%service_name%</strong> appointment at <strong>%location_name%</strong> has been changed. \n                     The appointment is now set for <strong>%appointment_date%</strong> at \n                     <strong>%appointment_start_time%</strong>.<br><br>Thank you,<br><strong>%company_name%</strong>', NULL),
(14, 'provider_appointment_next_day_reminder', 'enabled', 'email', 'appointment', '17:00:00', NULL, NULL, 'provider', '%service_name% Appointment Reminder', 'Dear <strong>%employee_full_name%</strong>,<br><br>We would like to remind you that you have \n                     <strong>%service_name%</strong> appointment tomorrow at <strong>%appointment_start_time%</strong>\n                     at <strong>%location_name%</strong>.<br><br>Thank you, \n                     <br><strong>%company_name%</strong>', NULL),
(15, 'customer_appointment_approved', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n\nYou have successfully scheduled %service_name% appointment with %employee_full_name%. We are waiting for you at %location_address% on %appointment_date_time%.\n\nThank you for choosing our company,\n%company_name%', NULL),
(16, 'customer_appointment_pending', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%, \n                    \nThe %service_name% appointment with %employee_full_name% at %location_address%, scheduled for %appointment_date_time% is waiting for a confirmation.\n                    \nThank you for choosing our company,\n%company_name%', NULL),
(17, 'customer_appointment_rejected', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n                    \nYour %service_name% appointment, scheduled on %appointment_date_time% at %location_address% has been rejected.\n                    \nThank you for choosing our company,\n%company_name%', NULL),
(18, 'customer_appointment_canceled', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n                    \nYour %service_name% appointment, scheduled on %appointment_date_time% at %location_address% has been canceled. \n                    \nThank you for choosing our company,\n%company_name%', NULL),
(19, 'customer_appointment_rescheduled', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n                    \nThe details for your %service_name% appointment with %employee_full_name% at %location_name% has been changed. The appointment is now set for %appointment_date% at %appointment_start_time%.\n                    \nThank you for choosing our company,\n%company_name%', NULL),
(20, 'customer_appointment_next_day_reminder', 'enabled', 'sms', 'appointment', '17:00:00', NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n                    \nWe would like to remind you that you have %service_name% appointment tomorrow at %appointment_start_time%. We are waiting for you at %location_name%.\n                    \nThank you for choosing our company,\n%company_name%', NULL),
(21, 'customer_appointment_follow_up', 'enabled', 'sms', 'appointment', NULL, NULL, 1800, 'customer', 'NULL', 'Dear %customer_full_name%,\n                    \nThank you once again for choosing our company. We hope you were satisfied with your %service_name%.\n                     \nWe look forward to seeing you again soon,\n%company_name%', NULL),
(22, 'customer_birthday_greeting', 'enabled', 'sms', 'appointment', '17:00:00', NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n                    \nHappy birthday! We wish you all the best. \n                    \nThank you for choosing our company,\n%company_name%', NULL),
(23, 'provider_appointment_approved', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n                    \nYou have one confirmed %service_name% appointment at %location_name% on %appointment_date% at %appointment_start_time%. The appointment is added to your schedule.\n                    \nThank you,\n%company_name%', NULL),
(24, 'provider_appointment_pending', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n                    \nYou have new appointment in %service_name%. The appointment is waiting for a confirmation.\n                    \nThank you,\n%company_name%', NULL),
(25, 'provider_appointment_rejected', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n                    \nYour %service_name% appointment at %location_name%, scheduled for %appointment_date% at %appointment_start_time% has been rejected. \n                    \nThank you,\n%company_name%', NULL),
(26, 'provider_appointment_canceled', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n                    \nYour %service_name% appointment, scheduled on %appointment_date%, at %location_name% has been canceled.\n                    \nThank you,\n%company_name%', NULL),
(27, 'provider_appointment_rescheduled', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n                    \nThe details for your %service_name% appointment at %location_name% has been changed. The appointment is now set for %appointment_date% at %appointment_start_time%.\n                    \nThank you,\n%company_name%', NULL),
(28, 'provider_appointment_next_day_reminder', 'enabled', 'sms', 'appointment', '17:00:00', NULL, NULL, 'provider', 'NULL', 'Dear %employee_full_name%, \n                    \nWe would like to remind you that you have %service_name% appointment tomorrow at %appointment_start_time% at %location_name%.\n                    \nThank you, \n%company_name%', NULL),
(29, 'customer_event_approved', 'enabled', 'email', 'event', NULL, NULL, NULL, 'customer', '%event_name% Event Booked', 'Dear <strong>%customer_full_name%</strong>,<br><br>You have successfully scheduled\n                     <strong>%event_name%</strong> event. We are\n                     waiting you at <strong>%event_location% </strong>on <strong>%event_start_date_time%</strong>.\n                     <br><br>Thank you for choosing our company,<br><strong>%company_name%</strong>', NULL),
(30, 'customer_event_rejected', 'enabled', 'email', 'event', NULL, NULL, NULL, 'customer', '%event_name% Event Canceled By Admin', 'Dear <strong>%customer_full_name%</strong>,<br><br>Your <strong>%event_name%</strong>\n                     event, scheduled on <strong>%event_start_date_time%</strong> at <strong>%event_location%\n                     </strong>has been canceled.<br><br>Thank you for choosing our company,\n                     <br><strong>%company_name%</strong>', NULL),
(31, 'customer_event_canceled', 'enabled', 'email', 'event', NULL, NULL, NULL, 'customer', '%event_name% Event Canceled By Attendee', 'Dear <strong>%customer_full_name%</strong>,<br><br>Your <strong>%event_name%</strong>\n                     event, scheduled on <strong>%event_start_date_time%</strong> at <strong>%event_location%\n                     </strong>has been canceled.<br><br>Thank you for choosing our company,\n                     <br><strong>%company_name%</strong>', NULL),
(32, 'customer_event_rescheduled', 'enabled', 'email', 'event', NULL, NULL, NULL, 'customer', '%event_name% Event Rescheduled', 'Dear <strong>%customer_full_name%</strong>,<br><br>The details for your\n                     <strong>%event_name%</strong> event at\n                     <strong>%event_location%</strong> has been changed. The event is now set for\n                     <strong>%event_start_date_time%</strong>.<br><br>\n                     Thank you for choosing our company,<br><strong>%company_name%</strong>', NULL),
(33, 'customer_event_next_day_reminder', 'enabled', 'email', 'event', '17:00:00', NULL, NULL, 'customer', '%event_name% Event Reminder', 'Dear <strong>%customer_full_name%</strong>,<br><br>We would like to remind you that you have\n                     <strong>%event_name%</strong> event tomorrow at <strong>%event_start_date_time%</strong>.\n                     We are waiting for you at <strong>%event_location%</strong>.<br><br>Thank you for\n                     choosing our company,<br><strong>%company_name%</strong>', NULL),
(34, 'customer_event_follow_up', 'enabled', 'email', 'event', NULL, NULL, 1800, 'customer', '%event_name% Event Follow Up', 'Dear <strong>%customer_full_name%</strong>,<br><br>Thank you once again for choosing our company.\n                     We hope you were satisfied with your <strong>%event_name%</strong>.<br><br>We look forward to\n                     seeing you again soon,<br><strong>%company_name%</strong>', NULL),
(35, 'provider_event_approved', 'enabled', 'email', 'event', NULL, NULL, NULL, 'provider', '%event_name% Event Booked', 'Hi <strong>%employee_full_name%</strong>,<br><br>You have one confirmed\n                     <strong>%event_name%</strong> Event at <strong>%event_location%</strong> on\n                     <strong>%event_start_date_time%</strong>. The event\n                     is added to your schedule.<br><br>Thank you,<br><strong>%company_name%</strong>', NULL),
(36, 'provider_event_rejected', 'enabled', 'email', 'event', NULL, NULL, NULL, 'provider', '%event_name% Event Canceled By Admin', 'Hi <strong>%employee_full_name%</strong>,<br><br>Your <strong>%event_name%</strong> event\n                     at <strong>%event_location%</strong>, scheduled for <strong>%event_start_date_time%</strong>\n                     has been canceled.<br><br>Thank you,<br><strong>%company_name%</strong>', NULL),
(37, 'provider_event_canceled', 'enabled', 'email', 'event', NULL, NULL, NULL, 'provider', '%event_name% Event Canceled By Customer', 'Hi <strong>%employee_full_name%</strong>,<br><br>Your <strong>%event_name%</strong> event,\n                     scheduled on <strong>%event_start_date_time%</strong>, at <strong>%event_location%</strong> has been\n                     canceled.<br><br>Thank you,<br><strong>%company_name%</strong>', NULL),
(38, 'provider_event_rescheduled', 'enabled', 'email', 'event', NULL, NULL, NULL, 'provider', '%event_name% Event Rescheduled', 'Hi <strong>%employee_full_name%</strong>,<br><br>The details for your\n                     <strong>%event_name%</strong> event at <strong>%event_location%</strong> has been changed.\n                     The event is now set for <strong>%event_start_date_time%</strong>.\n                     <br><br>Thank you,<br><strong>%company_name%</strong>', NULL),
(39, 'provider_event_next_day_reminder', 'enabled', 'email', 'event', '17:00:00', NULL, NULL, 'provider', '%event_name% Event Reminder', 'Dear <strong>%employee_full_name%</strong>,<br><br>We would like to remind you that you have \n                     <strong>%event_name%</strong> event at <strong>%event_start_date_time%</strong>\n                     at <strong>%event_location%</strong>.<br><br>Thank you, \n                     <br><strong>%company_name%</strong>', NULL),
(40, 'customer_event_approved', 'enabled', 'sms', 'event', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n\nYou have successfully scheduled %event_name% event. We are waiting for you at %event_location% on %event_start_date_time%.\n\nThank you for choosing our company,\n%company_name%', NULL),
(41, 'customer_event_rejected', 'enabled', 'sms', 'event', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n\nYour %event_name% event, scheduled on %event_start_date_time% at %event_location% has been cancelled.\n\nThank you for choosing our company,\n%company_name%', NULL),
(42, 'customer_event_canceled', 'enabled', 'sms', 'event', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n\nYour %event_name% event, scheduled on %event_start_date_time% at %event_location% has been cancelled.\n\nThank you for choosing our company,\n%company_name%', NULL),
(43, 'customer_event_rescheduled', 'enabled', 'sms', 'event', NULL, NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n\nThe details for your %event_name% event at %event_location% has been changed. The event is now set for %event_start_date_time%.\n\nThank you for choosing our company,\n%company_name%', NULL),
(44, 'customer_event_next_day_reminder', 'enabled', 'sms', 'event', '17:00:00', NULL, NULL, 'customer', 'NULL', 'Dear %customer_full_name%,\n                    \nWe would like to remind you that you have %event_name% event at %event_start_date_time%. We are waiting for you at %event_location%.\n                    \nThank you for choosing our company,\n%company_name%', NULL),
(45, 'customer_event_follow_up', 'enabled', 'sms', 'event', NULL, NULL, 1800, 'customer', 'NULL', 'Dear %customer_full_name%,\n                    \nThank you once again for choosing our company. We hope you were satisfied with your %event_name%.\n                     \nWe look forward to seeing you again soon,\n%company_name%', NULL),
(46, 'provider_event_approved', 'enabled', 'sms', 'event', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n\nYou have one confirmed %event_name% event at %event_location% on %event_start_date_time%. The event is added to your schedule.\n\nThank you,\n%company_name%', NULL),
(47, 'provider_event_rejected', 'enabled', 'sms', 'event', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n\nYour %event_name% event at %event_location%, scheduled for %event_start_date_time% has been canceled by admin.\n\nThank you,\n%company_name%', NULL),
(48, 'provider_event_canceled', 'enabled', 'sms', 'event', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n\nYour %event_name% event, scheduled on %event_start_date_time%, at %event_location% has been canceled.\n\nThank you,\n%company_name%', NULL),
(49, 'provider_event_rescheduled', 'enabled', 'sms', 'event', NULL, NULL, NULL, 'provider', 'NULL', 'Hi %employee_full_name%,\n\nThe details for your %event_name% event at %event_location% has been changed. The event is now set for %event_start_date_time%.\n\nThank you,\n%company_name%', NULL),
(50, 'provider_event_next_day_reminder', 'enabled', 'sms', 'event', '17:00:00', NULL, NULL, 'provider', 'NULL', 'Dear %employee_full_name%, \n                    \nWe would like to remind you that you have %event_name% event at %event_start_date_time% at %event_location%.\n                    \nThank you, \n%company_name%', NULL),
(51, 'customer_account_recovery', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'customer', 'Customer Panel Access', 'Dear <strong>%customer_full_name%</strong>,<br><br>You can access your profile on this <b><a href=\"%customer_panel_url%\">link</a></b>.\n                    <br><br>Thank you for choosing our company,<br><strong>%company_name%</strong>', NULL),
(52, 'provider_panel_access', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'provider', 'Employee Panel Access', 'Dear <strong>%employee_full_name%</strong>,<br><br>You can access your profile and track your bookings on this <b><a href=\"%employee_panel_url%\">link</a></b>.<br><br>Your login credentials:<br>Email: <b>%employee_email%</b><br>Password: <b>%employee_password%</b>\n                    <br><br>Best regards,<br><strong>%company_name%</strong>', NULL),
(53, 'customer_package_purchased', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'customer', 'Package %package_name% purchased', 'Dear <strong>%customer_full_name%</strong>,<br><br>You have successfully purchased\n                     <strong>%package_name%</strong>.\n                     <br><br>Thank you for choosing our company,<br><strong>%company_name%</strong>', NULL),
(54, 'customer_package_purchased', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'customer', 'Package %package_name% purchased', 'Dear %customer_full_name%,\n\nYou have successfully purchased %package_name%.\n\nThank you for choosing our company, %company_name%', NULL),
(55, 'provider_package_purchased', 'enabled', 'email', 'appointment', NULL, NULL, NULL, 'provider', 'Package %package_name% purchased', 'Hi <strong>%employee_full_name%</strong>,<br><br>\n                     Customer %customer_full_name% has purchased <strong>%package_name%</strong> package.<br><br>\n                     Thank you,<br><strong>%company_name%</strong>', NULL),
(56, 'provider_package_purchased', 'enabled', 'sms', 'appointment', NULL, NULL, NULL, 'provider', 'Package %package_name% purchased', 'Hi %employee_full_name%,\n\nCustomer %customer_full_name% has purchased %package_name% package.\n                     \nThank you, %company_name%', NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_notifications_log`
--

CREATE TABLE `wp_amelia_notifications_log` (
  `id` int(11) NOT NULL,
  `notificationId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `appointmentId` int(11) DEFAULT NULL,
  `eventId` int(11) DEFAULT NULL,
  `sentDateTime` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_notifications_sms_history`
--

CREATE TABLE `wp_amelia_notifications_sms_history` (
  `id` int(11) NOT NULL,
  `notificationId` int(11) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  `appointmentId` int(11) DEFAULT NULL,
  `eventId` int(11) DEFAULT NULL,
  `logId` int(11) DEFAULT NULL,
  `dateTime` datetime DEFAULT NULL,
  `text` varchar(1600) NOT NULL,
  `phone` varchar(63) NOT NULL,
  `alphaSenderId` varchar(11) NOT NULL,
  `status` enum('prepared','accepted','queued','sent','failed','delivered','undelivered') NOT NULL DEFAULT 'prepared',
  `price` double DEFAULT NULL,
  `segments` tinyint(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_packages`
--

CREATE TABLE `wp_amelia_packages` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `color` varchar(255) NOT NULL DEFAULT '',
  `price` double NOT NULL,
  `status` enum('hidden','visible','disabled') NOT NULL DEFAULT 'visible',
  `pictureFullPath` varchar(767) DEFAULT NULL,
  `pictureThumbPath` varchar(767) DEFAULT NULL,
  `position` int(11) DEFAULT '0',
  `calculatedPrice` tinyint(1) DEFAULT '1',
  `discount` double NOT NULL,
  `endDate` datetime DEFAULT NULL,
  `durationType` enum('day','week','month') DEFAULT NULL,
  `durationCount` int(4) DEFAULT NULL,
  `settings` text,
  `translations` text,
  `depositPayment` enum('disabled','fixed','percentage') DEFAULT 'disabled',
  `deposit` double DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_packages_customers_to_services`
--

CREATE TABLE `wp_amelia_packages_customers_to_services` (
  `id` int(11) NOT NULL,
  `packageCustomerId` int(11) NOT NULL,
  `serviceId` int(11) NOT NULL,
  `providerId` int(11) DEFAULT NULL,
  `locationId` int(11) DEFAULT NULL,
  `bookingsCount` int(5) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_packages_services_to_locations`
--

CREATE TABLE `wp_amelia_packages_services_to_locations` (
  `id` int(11) NOT NULL,
  `packageServiceId` int(11) NOT NULL,
  `locationId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_packages_services_to_providers`
--

CREATE TABLE `wp_amelia_packages_services_to_providers` (
  `id` int(11) NOT NULL,
  `packageServiceId` int(11) NOT NULL,
  `userId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_packages_to_customers`
--

CREATE TABLE `wp_amelia_packages_to_customers` (
  `id` int(11) NOT NULL,
  `packageId` int(11) NOT NULL,
  `customerId` int(11) NOT NULL,
  `price` double NOT NULL,
  `start` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `purchased` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_packages_to_services`
--

CREATE TABLE `wp_amelia_packages_to_services` (
  `id` int(11) NOT NULL,
  `serviceId` int(11) NOT NULL,
  `packageId` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `minimumScheduled` int(5) DEFAULT '1',
  `maximumScheduled` int(5) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_payments`
--

CREATE TABLE `wp_amelia_payments` (
  `id` int(11) NOT NULL,
  `customerBookingId` int(11) DEFAULT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dateTime` datetime DEFAULT NULL,
  `status` enum('paid','pending','partiallyPaid') NOT NULL,
  `gateway` enum('onSite','payPal','stripe','wc','mollie') NOT NULL,
  `gatewayTitle` varchar(255) DEFAULT NULL,
  `data` text,
  `packageCustomerId` int(11) DEFAULT NULL,
  `parentId` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_payments`
--

INSERT INTO `wp_amelia_payments` (`id`, `customerBookingId`, `amount`, `dateTime`, `status`, `gateway`, `gatewayTitle`, `data`, `packageCustomerId`, `parentId`) VALUES
(1, 1, 0, '2021-07-13 11:00:00', 'paid', 'onSite', '', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_daysoff`
--

CREATE TABLE `wp_amelia_providers_to_daysoff` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `startDate` date NOT NULL,
  `endDate` date NOT NULL,
  `repeat` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_events`
--

CREATE TABLE `wp_amelia_providers_to_events` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `eventId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_google_calendar`
--

CREATE TABLE `wp_amelia_providers_to_google_calendar` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `token` text NOT NULL,
  `calendarId` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_locations`
--

CREATE TABLE `wp_amelia_providers_to_locations` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `locationId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_providers_to_locations`
--

INSERT INTO `wp_amelia_providers_to_locations` (`id`, `userId`, `locationId`) VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_outlook_calendar`
--

CREATE TABLE `wp_amelia_providers_to_outlook_calendar` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `token` text NOT NULL,
  `calendarId` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_periods`
--

CREATE TABLE `wp_amelia_providers_to_periods` (
  `id` int(11) NOT NULL,
  `weekDayId` int(11) NOT NULL,
  `locationId` int(11) DEFAULT NULL,
  `startTime` time NOT NULL,
  `endTime` time NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_providers_to_periods`
--

INSERT INTO `wp_amelia_providers_to_periods` (`id`, `weekDayId`, `locationId`, `startTime`, `endTime`) VALUES
(1, 1, NULL, '09:00:00', '17:00:00'),
(2, 2, NULL, '09:00:00', '17:00:00'),
(3, 3, NULL, '09:00:00', '17:00:00'),
(4, 4, NULL, '09:00:00', '17:00:00'),
(5, 5, NULL, '09:00:00', '17:00:00');

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_periods_services`
--

CREATE TABLE `wp_amelia_providers_to_periods_services` (
  `id` int(11) NOT NULL,
  `periodId` int(11) NOT NULL,
  `serviceId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_services`
--

CREATE TABLE `wp_amelia_providers_to_services` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `serviceId` int(11) NOT NULL,
  `price` double NOT NULL,
  `minCapacity` int(11) NOT NULL,
  `maxCapacity` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_providers_to_services`
--

INSERT INTO `wp_amelia_providers_to_services` (`id`, `userId`, `serviceId`, `price`, `minCapacity`, `maxCapacity`) VALUES
(5, 1, 4, 0, 1, 1);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_specialdays`
--

CREATE TABLE `wp_amelia_providers_to_specialdays` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `startDate` date NOT NULL,
  `endDate` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_specialdays_periods`
--

CREATE TABLE `wp_amelia_providers_to_specialdays_periods` (
  `id` int(11) NOT NULL,
  `specialDayId` int(11) NOT NULL,
  `locationId` int(11) DEFAULT NULL,
  `startTime` time NOT NULL,
  `endTime` time NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_specialdays_periods_services`
--

CREATE TABLE `wp_amelia_providers_to_specialdays_periods_services` (
  `id` int(11) NOT NULL,
  `periodId` int(11) NOT NULL,
  `serviceId` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_timeouts`
--

CREATE TABLE `wp_amelia_providers_to_timeouts` (
  `id` int(11) NOT NULL,
  `weekDayId` int(11) NOT NULL,
  `startTime` time NOT NULL,
  `endTime` time NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_to_weekdays`
--

CREATE TABLE `wp_amelia_providers_to_weekdays` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dayIndex` tinyint(2) NOT NULL,
  `startTime` time NOT NULL,
  `endTime` time NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_providers_to_weekdays`
--

INSERT INTO `wp_amelia_providers_to_weekdays` (`id`, `userId`, `dayIndex`, `startTime`, `endTime`) VALUES
(1, 1, 1, '09:00:00', '17:00:00'),
(2, 1, 2, '09:00:00', '17:00:00'),
(3, 1, 3, '09:00:00', '17:00:00'),
(4, 1, 4, '09:00:00', '17:00:00'),
(5, 1, 5, '09:00:00', '17:00:00');

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_providers_views`
--

CREATE TABLE `wp_amelia_providers_views` (
  `id` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `date` date NOT NULL,
  `views` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_services`
--

CREATE TABLE `wp_amelia_services` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `color` varchar(255) NOT NULL DEFAULT '',
  `price` double NOT NULL,
  `status` enum('hidden','visible','disabled') NOT NULL DEFAULT 'visible',
  `categoryId` int(11) NOT NULL,
  `minCapacity` int(11) NOT NULL,
  `maxCapacity` int(11) NOT NULL,
  `duration` int(11) NOT NULL,
  `timeBefore` int(11) DEFAULT '0',
  `timeAfter` int(11) DEFAULT '0',
  `bringingAnyone` tinyint(1) DEFAULT '1',
  `priority` enum('least_expensive','most_expensive','least_occupied','most_occupied') NOT NULL,
  `pictureFullPath` varchar(767) DEFAULT NULL,
  `pictureThumbPath` varchar(767) DEFAULT NULL,
  `position` int(11) DEFAULT '0',
  `show` tinyint(1) DEFAULT '1',
  `aggregatedPrice` tinyint(1) DEFAULT '1',
  `settings` text,
  `recurringCycle` enum('disabled','all','daily','weekly','monthly') DEFAULT 'disabled',
  `recurringSub` enum('disabled','past','future','both') DEFAULT 'future',
  `recurringPayment` int(3) DEFAULT '0',
  `translations` text,
  `depositPayment` enum('disabled','fixed','percentage') DEFAULT 'disabled',
  `depositPerPerson` tinyint(1) DEFAULT '1',
  `deposit` double DEFAULT '0',
  `mandatoryExtra` tinyint(1) DEFAULT '0',
  `minSelectedExtras` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_services`
--

INSERT INTO `wp_amelia_services` (`id`, `name`, `description`, `color`, `price`, `status`, `categoryId`, `minCapacity`, `maxCapacity`, `duration`, `timeBefore`, `timeAfter`, `bringingAnyone`, `priority`, `pictureFullPath`, `pictureThumbPath`, `position`, `show`, `aggregatedPrice`, `settings`, `recurringCycle`, `recurringSub`, `recurringPayment`, `translations`, `depositPayment`, `depositPerPerson`, `deposit`, `mandatoryExtra`, `minSelectedExtras`) VALUES
(2, 'Hôpital privé Le Bois', '', '#1788FB', 0, 'visible', 6, 1, 1, 7200, NULL, NULL, 1, 'least_expensive', NULL, NULL, 2, 0, 1, '{\"payments\":{\"onSite\":true,\"payPal\":{\"enabled\":false},\"stripe\":{\"enabled\":false},\"mollie\":{\"enabled\":false}},\"zoom\":{\"enabled\":true},\"activation\":{\"version\":\"4.0.1\"}}', 'disabled', 'future', 0, NULL, 'disabled', 1, 0, 0, NULL),
(3, 'Centre Oscar Lambret', '', '#1788FB', 0, 'visible', 6, 1, 1, 7200, NULL, NULL, 1, 'least_expensive', NULL, NULL, 1, 0, 1, '{\"payments\":{\"onSite\":true,\"payPal\":{\"enabled\":false},\"stripe\":{\"enabled\":false},\"mollie\":{\"enabled\":false}},\"zoom\":{\"enabled\":false}}', 'disabled', 'future', 0, NULL, 'disabled', 1, 0, 0, NULL),
(4, 'reservation en ligne', '', '#1788FB', 0, 'visible', 1, 1, 1, 7200, NULL, NULL, 1, 'least_expensive', NULL, NULL, 3, 1, 1, '{\"payments\":{\"onSite\":true,\"payPal\":{\"enabled\":false},\"stripe\":{\"enabled\":false},\"mollie\":{\"enabled\":false}},\"zoom\":{\"enabled\":false}}', 'disabled', 'future', 0, NULL, 'disabled', 1, 0, 0, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_services_views`
--

CREATE TABLE `wp_amelia_services_views` (
  `id` int(11) NOT NULL,
  `serviceId` int(11) NOT NULL,
  `date` date NOT NULL,
  `views` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Structure de la table `wp_amelia_users`
--

CREATE TABLE `wp_amelia_users` (
  `id` int(11) NOT NULL,
  `status` enum('hidden','visible','disabled') NOT NULL DEFAULT 'visible',
  `type` enum('customer','provider','manager','admin') NOT NULL,
  `externalId` int(11) DEFAULT NULL,
  `firstName` varchar(255) NOT NULL DEFAULT '',
  `lastName` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `phone` varchar(63) DEFAULT NULL,
  `gender` enum('male','female') DEFAULT NULL,
  `note` text,
  `pictureFullPath` varchar(767) DEFAULT NULL,
  `pictureThumbPath` varchar(767) DEFAULT NULL,
  `password` varchar(128) DEFAULT NULL,
  `usedTokens` text,
  `zoomUserId` varchar(255) DEFAULT NULL,
  `countryPhoneIso` varchar(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Déchargement des données de la table `wp_amelia_users`
--

INSERT INTO `wp_amelia_users` (`id`, `status`, `type`, `externalId`, `firstName`, `lastName`, `email`, `birthday`, `phone`, `gender`, `note`, `pictureFullPath`, `pictureThumbPath`, `password`, `usedTokens`, `zoomUserId`, `countryPhoneIso`) VALUES
(1, 'visible', 'provider', 2, 'yann', 'durosini', 'yann.durosini@dside-agency.com', NULL, '+33102030405', NULL, NULL, NULL, NULL, '$2y$10$A5ofGq5j.hecjCBjWmytXOq9SPkGKeqeaeXUtVo9ULP6j0YAIvn/i', NULL, NULL, 'fr'),
(2, 'visible', 'customer', NULL, 'tata', 'rach', 't@gmail.com', '2021-07-13', '0102030405', 'female', 'kfh qmlsjd m', NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_ariadminer_connections`
--

CREATE TABLE `wp_ariadminer_connections` (
  `connection_id` int(11) UNSIGNED NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('server','sqlite','pgsql','oracle','mssql','firebird','simpledb','mongo','elastic') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'server',
  `host` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `db_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `author_id` int(11) DEFAULT NULL,
  `crypt` tinyint(1) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `wp_commentmeta`
--

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL,
  `comment_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `wp_comments`
--

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) UNSIGNED NOT NULL,
  `comment_post_ID` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `wp_comments`
--

INSERT INTO `wp_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
(1, 1, 'A WordPress Commenter', 'wapuu@wordpress.example', 'https://wordpress.org/', '', '2019-06-11 10:05:36', '2019-06-11 10:05:36', 'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\" rel=\"nofollow ugc\">Gravatar</a>.', 0, '1', '', 'comment', 0, 0);

-- --------------------------------------------------------

--
-- Structure de la table `wp_eg_grids`
--

CREATE TABLE `wp_eg_grids` (
  `id` mediumint(6) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `postparams` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layers` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  `last_modified` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `wp_eg_grids`
--

INSERT INTO `wp_eg_grids` (`id`, `name`, `handle`, `postparams`, `params`, `layers`, `settings`, `last_modified`) VALUES
(1, 'Accueil-essentiels-cap-douceur', 'Accueil-essentiels-cap-douceur', '{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-token-source\":\"account\",\"instagram-connected-to\":\"\",\"instagram-api-key\":\"\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-access-token\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"behance-api\":\"\",\"behance-user-id\":\"\",\"behance-type\":\"projects\",\"behance-project\":\"\",\"behance-project-select\":\"\",\"behance-projects-thumb-size\":\"202\",\"behance-projects-full-size\":\"202\",\"behance-project-thumb-size\":\"max_1240\",\"behance-project-full-size\":\"disp\",\"behance-count\":\"12\",\"behance-transient-sec\":\"86400\",\"dribbble-api\":\"\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\"}', '{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"4\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"videoplaybackingrid\":\"on\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"2\",\"2\",\"2\",\"2\",\"2\",\"2\",\"2\"],\"blank-item-breakpoint\":\"1\",\"rows-unlimited\":\"off\",\"rows\":\"3\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"20\",\"grid-padding\":[\"0\",\"40\",\"40\",\"40\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"11\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-title\":\"off\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\"}', '[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"84\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"jpg1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"83\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"jpg2\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]', NULL, NULL),
(2, 'Les tutos', 'Les tutos', '{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"stream-source-type\":\"youtube\",\"youtube-api\":\"AIzaSyDfBI5Nysaf64NYH8pBryHbeJFH9VS20N4\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-token-source\":\"account\",\"instagram-connected-to\":\"\",\"instagram-api-key\":\"\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-access-token\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"behance-api\":\"\",\"behance-user-id\":\"\",\"behance-type\":\"projects\",\"behance-project\":\"\",\"behance-project-select\":\"\",\"behance-projects-thumb-size\":\"202\",\"behance-projects-full-size\":\"202\",\"behance-project-thumb-size\":\"max_1240\",\"behance-project-full-size\":\"disp\",\"behance-count\":\"12\",\"behance-transient-sec\":\"86400\",\"dribbble-api\":\"\",\"media-source-order\":[\"youtube\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\"}', '{\"layout-sizing\":\"fullwidth\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"1\",\"y-ratio\":\"1\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"videoplaybackingrid\":\"on\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"3\",\"3\",\"3\",\"3\",\"3\",\"3\",\"2\"],\"blank-item-breakpoint\":\"1\",\"rows-unlimited\":\"off\",\"rows\":\"1\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"30\",\"grid-padding\":[\"0\",\"0\",\"0\",\"0\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"12\",\"grid-start-animation\":\"none\",\"hide-markup-before-load\":\"off\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"1\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"horizontal-slide\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"col\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"youtube\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-title\":\"off\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"slideShow\",\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"youtube\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"bottom\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"left\":{\"left\":\"0\"},\"right\":{\"right\":\"0\"}}}', '[\"{\\\"custom-type\\\":\\\"youtube\\\",\\\"custom-image\\\":\\\"141\\\",\\\"custom-youtube\\\":\\\"PPtnQmGwKTA\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"img1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"youtube\\\",\\\"custom-image\\\":\\\"139\\\",\\\"custom-youtube\\\":\\\"bFI8SoPSJtY\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"https:\\\\\\/\\\\\\/youtu.be\\\\\\/bFI8SoPSJtY\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"img3\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"youtube\\\",\\\"custom-image\\\":\\\"140\\\",\\\"custom-youtube\\\":\\\"eDX6EfmIGHU\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"img2\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"youtube\\\",\\\"custom-image\\\":\\\"38\\\",\\\"custom-youtube\\\":\\\"2qznis9yIcU\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"code2-staff-2\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"youtube\\\",\\\"custom-image\\\":\\\"37\\\",\\\"custom-youtube\\\":\\\"2qznis9yIcU\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"code2 staff 3\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"youtube\\\",\\\"custom-image\\\":\\\"39\\\",\\\"custom-youtube\\\":\\\"yUBezEWYkiU\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"code2-staff-1\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]', NULL, '2021-07-08 21:22:51'),
(3, 'les essentiels cap douceur', 'les essentiels cap douceur', '{\"source-type\":\"post\",\"post_types\":\"cap-douceur\",\"post_category\":\"category_10,category_12,category_3,category_4,category_5,category_6,category_7\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"stream-source-type\":\"instagram\",\"youtube-api\":\"\",\"youtube-channel-id\":\"\",\"youtube-type-source\":\"channel\",\"youtube-playlist\":\"\",\"youtube-playlist-select\":\"\",\"youtube-thumb-size\":\"default\",\"youtube-full-size\":\"default\",\"youtube-count\":\"12\",\"youtube-transient-sec\":\"86400\",\"vimeo-type-source\":\"user\",\"vimeo-username\":\"\",\"vimeo-groupname\":\"\",\"vimeo-albumid\":\"\",\"vimeo-channelname\":\"\",\"vimeo-thumb-size\":\"thumbnail_small\",\"vimeo-count\":\"12\",\"vimeo-transient-sec\":\"86400\",\"instagram-token-source\":\"account\",\"instagram-connected-to\":\"\",\"instagram-api-key\":\"\",\"instagram-count\":\"12\",\"instagram-transient-sec\":\"86400\",\"flickr-api-key\":\"\",\"flickr-type\":\"publicphotos\",\"flickr-user-url\":\"\",\"flickr-photoset\":\"\",\"flickr-photoset-select\":\"\",\"flickr-gallery-url\":\"\",\"flickr-group-url\":\"\",\"flickr-thumb-size\":\"Small 320\",\"flickr-full-size\":\"Medium 800\",\"flickr-count\":\"12\",\"flickr-transient-sec\":\"86400\",\"facebook-access-token\":\"\",\"facebook-page-url\":\"\",\"facebook-type-source\":\"timeline\",\"facebook-album\":\"\",\"facebook-album-select\":\"\",\"facebook-count\":\"12\",\"facebook-transient-sec\":\"86400\",\"twitter-consumer-key\":\"\",\"twitter-consumer-secret\":\"\",\"twitter-access-token\":\"\",\"twitter-access-secret\":\"\",\"twitter-user-id\":\"\",\"twitter-image-only\":\"true\",\"twitter-include-retweets\":\"on\",\"twitter-exclude-replies\":\"on\",\"twitter-count\":\"12\",\"twitter-transient-sec\":\"86400\",\"behance-api\":\"\",\"behance-user-id\":\"\",\"behance-type\":\"projects\",\"behance-project\":\"\",\"behance-project-select\":\"\",\"behance-projects-thumb-size\":\"202\",\"behance-projects-full-size\":\"202\",\"behance-project-thumb-size\":\"max_1240\",\"behance-project-full-size\":\"disp\",\"behance-count\":\"12\",\"behance-transient-sec\":\"86400\",\"dribbble-api\":\"\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\"}', '{\"layout-sizing\":\"fullwidth\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"1\",\"y-ratio\":\"1\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"videoplaybackingrid\":\"on\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"3\",\"3\",\"3\",\"3\",\"3\",\"3\",\"3\"],\"blank-item-breakpoint\":\"1\",\"rows-unlimited\":\"off\",\"rows\":\"3\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"20\",\"grid-padding\":[\"20\",\"100\",\"20\",\"100\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"1\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-selected\":[\"category_3\",\"category_1\",\"category_4\"],\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-title\":\"off\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"css-id\":\"\",\"navigation-layout\":{\"filter\":{\"top-1\":\"0\"}}}', '[]', NULL, NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_eg_item_elements`
--

CREATE TABLE `wp_eg_item_elements` (
  `id` mediumint(6) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `wp_eg_item_skins`
--

CREATE TABLE `wp_eg_item_skins` (
  `id` mediumint(6) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layers` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `wp_eg_item_skins`
--

INSERT INTO `wp_eg_item_skins` (`id`, `name`, `handle`, `params`, `layers`, `settings`) VALUES
(1, 'Washington', 'washington', '{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#3f424a\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}', '[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"8\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]', NULL),
(2, 'Adams', 'adams', '{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}', '[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]', NULL),
(3, 'Jefferson', 'jefferson', '{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}', '[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":3,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":6,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"   \",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":4,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]', NULL);
INSERT INTO `wp_eg_item_skins` (`id`, `name`, `handle`, `params`, `layers`, `settings`) VALUES
(4, 'Madison', 'madison', '{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(88,92,103,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#585c67\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipvertical\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"flipverticalout\",\"media-animation-delay\":\"0\"}', '[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"35\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"35\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"45\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]', NULL),
(5, 'ESGBlankSkin', 'esgblankskin', '{\"eg-item-skin-element-last-id\":\"0\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0, 0, 0, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"rgba(255, 255, 255, 0)\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"rgba(255, 255, 255, 0)\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}', '[]', NULL),
(6, 'Washington-205234', 'washington-205234', '{\"eg-item-skin-element-last-id\":\"9\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0,0,0,0.65)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#3f424a\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fade\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\"}', '[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.50)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"falldown\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"css\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css-hover\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"8\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"9\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]', NULL),
(7, 'Adams-205234', 'adams-205234', '{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}', '[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]', NULL);
INSERT INTO `wp_eg_item_skins` (`id`, `name`, `handle`, `params`, `layers`, `settings`) VALUES
(8, 'Jefferson-205234', 'jefferson-205234', '{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}', '[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":3,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":6,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"   \",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":4,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]', NULL),
(9, 'Madison-205234', 'madison-205234', '{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(88,92,103,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#585c67\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipvertical\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"flipverticalout\",\"media-animation-delay\":\"0\"}', '[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"35\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"35\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"45\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]', NULL),
(10, 'ESGBlankSkin-205234', 'esgblankskin-205234', '{\"eg-item-skin-element-last-id\":\"0\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0, 0, 0, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"rgba(255, 255, 255, 0)\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"rgba(255, 255, 255, 0)\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}', '[]', NULL),
(11, 'Image-fix', 'image-fix', '{\"eg-item-skin-element-last-id\":\"0\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"cover-blend-mode\":\"normal\",\"container-background-color\":\"#363839\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius-type\":\"px\",\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius-type\":\"px\",\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"content-box-shadow-inset\":\"false\",\"content-box-shadow-hover\":\"false\",\"cover-animation-top\":\"fade\",\"cover-animation-duration-top\":\"default\",\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-color-top\":\"#FFFFFF\",\"cover-animation-center\":\"fade\",\"cover-animation-duration-center\":\"default\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-color-center\":\"#FFFFFF\",\"cover-animation-bottom\":\"fade\",\"cover-animation-duration-bottom\":\"default\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-color-bottom\":\"#FFFFFF\",\"cover-group-animation\":\"none\",\"cover-group-animation-duration\":\"default\",\"cover-group-animation-delay\":\"0\",\"media-animation\":\"none\",\"media-animation-duration\":\"default\",\"media-animation-delay\":\"0\",\"media-animation-blur\":\"5\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-duration\":\"default\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-target\":\"_self\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\"}', '[]', NULL),
(12, 'Tuto-skin', 'tuto-skin', '{\"eg-item-skin-element-last-id\":\"1\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"cover-blend-mode\":\"normal\",\"container-background-color\":\"rgba(54, 56, 57, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius-type\":\"px\",\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius-type\":\"px\",\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"content-box-shadow-inset\":\"false\",\"content-box-shadow-hover\":\"false\",\"cover-animation-top\":\"fade\",\"cover-animation-duration-top\":\"default\",\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-color-top\":\"#FFFFFF\",\"cover-animation-center\":\"fade\",\"cover-animation-duration-center\":\"default\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-color-center\":\"#FFFFFF\",\"cover-animation-bottom\":\"fade\",\"cover-animation-duration-bottom\":\"default\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-color-bottom\":\"#FFFFFF\",\"cover-group-animation\":\"none\",\"cover-group-animation-duration\":\"default\",\"cover-group-animation-delay\":\"0\",\"media-animation\":\"none\",\"media-animation-duration\":\"default\",\"media-animation-delay\":\"0\",\"media-animation-blur\":\"5\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-duration\":\"default\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-target\":\"_self\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\"}', '[{\"id\":\"1\",\"order\":\"0\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"enable-hover\":\"on\",\"font-size\":\"40\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"1\",\"0\"],\"padding\":[\"13\",\"13\",\"13\",\"13\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"40\",\"line-height-hover\":\"22\",\"color-hover\":\"rgba(255,255,255,0)\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"false\",\"show-if-featured\":\"false\",\"transition\":\"slideup\",\"transition-type\":\"\",\"duration\":\"default\",\"delay\":\"20\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"letter-spacing\":\"normal\",\"margin-unit\":\"px\",\"source-function\":\"link\",\"min-height\":\"0\",\"max-height\":\"none\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"letter-spacing-hover\":\"normal\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-icon\":\"eg-icon-play\"}}]', NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_eg_navigation_skins`
--

CREATE TABLE `wp_eg_navigation_skins` (
  `id` mediumint(6) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `css` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `navversion` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `wp_eg_navigation_skins`
--

INSERT INTO `wp_eg_navigation_skins` (`id`, `name`, `handle`, `css`, `navversion`) VALUES
(1, 'Flat Light', 'flat-light', '/*************************************\n	-	FLAT LIGHT 3.0.0 SKIN -\n*************************************/\n\n.flat-light .navigationbuttons,\n.flat-light .esg-pagination,\n.flat-light .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.flat-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.flat-light input.eg-search-input,\n.flat-light .esg-filterbutton,\n.flat-light .esg-navigationbutton,\n.flat-light .esg-sortbutton,\n.flat-light .esg-cartbutton,\n.flat-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.flat-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 30px;\n	border: 1px solid rgba(0,0,0,0.15);\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n}\n\n.flat-light .esg-cartbutton a {\n	color: #999;\n}\n\n.flat-light input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#999;\n}\n\n.flat-light .esg-navigationbutton {\n	padding: 0px;\n	width:40px;\n}\n\n.flat-light .esg-navigationbutton * {\n	color: #999;\n}\n\n.flat-light .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.flat-light .esg-sortbutton-wrapper,\n.flat-light .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.flat-light .esg-sortbutton-order,\n.flat-light .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid rgba(0,0,0,0.15);\n	width: 40px;\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #eee;\n	background: #fff;\n	margin-left: 5px;\n}\n\n.flat-light .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.flat-light .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.flat-light .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.flat-light .esg-sortbutton,\n.flat-light .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.flat-light input.eg-search-input.hovered,\n.flat-light input.eg-search-input:focus,\n.flat-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.flat-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.flat-light .esg-navigationbutton.hovered,\n.flat-light .esg-filterbutton.hovered,\n.flat-light .esg-sortbutton.hovered,\n.flat-light .esg-sortbutton-order.hovered,\n.flat-light .esg-cartbutton-order.hovered,\n.flat-light .esg-filterbutton.selected,\n.flat-light .esg-cartbutton.hovered,\n.flat-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.flat-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	background: #fff;\n    box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\n}\n\n.flat-light .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.flat-light .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.flat-light .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.flat-light .esg-filterbutton.selected .esg-filter-checked,\n.flat-light .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.flat-light .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.flat-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.flat-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.flat-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.flat-light .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.flat-light .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.flat-light .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative\n}\n\n.flat-light .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n.flat-light .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.flat-light .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}', NULL),
(2, 'Flat Dark', 'flat-dark', '/********************************\n	-	FLAT DARK 3.0.0 SKIN -\n*********************************/\n\n.flat-dark .navigationbuttons,\n.flat-dark .esg-pagination,\n.flat-dark .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.flat-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.flat-dark input.eg-search-input,\n.flat-dark .esg-filterbutton,\n.flat-dark .esg-navigationbutton,\n.flat-dark .esg-sortbutton,\n.flat-dark .esg-cartbutton,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 5px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 1px 30px;\n	border: none;\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: rgba(0, 0, 0, 0.2);\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n.flat-dark .esg-cartbutton a {\n	color:#fff;\n}\n\n.flat-dark input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.flat-dark .esg-navigationbutton {\n	padding: 2px 12px;\n}\n\n.flat-dark .esg-navigationbutton * {\n	color: #fff;\n}\n\n.flat-dark .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.flat-dark .esg-sortbutton-wrapper,\n.flat-dark .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.flat-dark .esg-sortbutton-order,\n.flat-dark .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: none;\n	width: 40px;\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #fff;\n	cursor: pointer;\n	background: rgba(0, 0, 0, 0.2);\n	margin-left: 5px;\n}\n\n.flat-dark .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.flat-dark .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.flat-dark .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.flat-dark .esg-sortbutton,\n.flat-dark .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.flat-dark input.eg-search-input.hovered,\n.flat-dark input.eg-search-input:focus,\n.flat-dark .esg-navigationbutton.hovered,\n.flat-dark .esg-filterbutton.hovered,\n.flat-dark .esg-sortbutton.hovered,\n.flat-dark .esg-sortbutton-order.hovered,\n.flat-dark .esg-cartbutton-order.hovered,\n.flat-dark .esg-filterbutton.selected,\n.flat-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.flat-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.flat-dark .esg-cartbutton.hovered,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #fff;\n	background: rgba(0, 0, 0, 0.5);\n}\n\n.flat-dark .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.flat-dark .esg-sortbutton-order.hovered .tp-desc {\n	color: #333;\n}\n\n.flat-dark .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.2);\n	margin-left: 7px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.flat-dark .esg-filterbutton.selected .esg-filter-checked,\n.flat-dark .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: rgba(0, 0, 0, 0.2);\n}\n\n.flat-dark .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.flat-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.flat-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.flat-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.flat-dark .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.flat-dark .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	background:rgba(0,0,0,0.5);\n}\n\n.flat-dark .esg-dropdown-wrapper .esg-filterbutton.selected,\n.flat-dark .esg-dropdown-wrapper .esg-filterbutton.hovered {\n	background:rgba(0,0,0,0.75);\n}\n\n\n.flat-dark .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n	position: absolute;\n	left: 10px;\n	top: 50%;\n	transform: translateY(-50%);\n	width: 12px;\n	height: 12px;\n	text-align: center;\n	line-height: 12px\n}\n\n.flat-dark .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right:-10px;\n	font-size:12px;\n	color:#fff;\n}', NULL),
(3, 'Minimal Dark', 'minimal-dark', '/**************************************\n	-	MINIMAL DARK V3.0.0 SKIN    -\n**************************************/\n\n.minimal-dark .navigationbuttons,\n.minimal-dark .esg-pagination,\n.minimal-dark .esg-filters {\n	text-align: center;\n}\n\n.minimal-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.minimal-dark input.eg-search-input,\n.minimal-dark .esg-filterbutton,\n.minimal-dark .esg-navigationbutton,\n.minimal-dark .esg-sortbutton,\n.minimal-dark .esg-cartbutton,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: rgba(255, 255, 255, 1);\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 17px;\n	border: 1px solid rgba(255, 255, 255, 0.1);\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n.minimal-dark .esg-cartbutton a {\n	color:#fff;\n}\n\n.minimal-dark input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.minimal-dark .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 1);\n}\n\n.minimal-dark .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.minimal-dark .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.minimal-dark .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.minimal-dark .esg-sortbutton-wrapper,\n.minimal-dark .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.minimal-dark .esg-sortbutton-order,\n.minimal-dark .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid rgba(255, 255, 255, 0.1);\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0px 5px 5px 0px;\n	font-size: 12px;\n	font-weight: 600;\n	color: #fff;\n	cursor: pointer;\n	background: transparent;\n}\n\n.minimal-dark .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.minimal-dark .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.minimal-dark .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.minimal-dark .esg-sortbutton,\n.minimal-dark .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 5px 0px 0px 5px;\n}\n\n.minimal-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.minimal-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.minimal-dark .esg-navigationbutton.hovered,\n.minimal-dark .esg-filterbutton.hovered,\n.minimal-dark .esg-sortbutton.hovered,\n.minimal-dark .esg-sortbutton-order.hovered,\n.minimal-dark .esg-cartbutton-order.hovered,\n.minimal-dark .esg-filterbutton.selected,\n.minimal-dark .esg-cartbutton.hovered,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n	background: rgba(255, 255, 255, 0.1);\n}\n\n.minimal-dark .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.minimal-dark .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.minimal-dark .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n	margin-left:7px;\n}\n\n.minimal-dark .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left:-22px;\n	margin-right:10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.minimal-dark .esg-filterbutton.selected .esg-filter-checked,\n.minimal-dark .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: rgba(0, 0, 0, 0.10);\n}\n\n/* */\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.minimal-dark .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:rgba(0,0,0,0.95);\n	border-radius: 5px;\n}\n\n.minimal-dark .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border:none;\n	box-shadow: none;\n	text-align: left;\n	color:rgba(255,255,255,0.5);\n	background:transparent;\n	line-height: 25px;\n	min-height: 25px;\n}\n\n.minimal-dark .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.minimal-dark .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#fff;\n}\n\n\n.minimal-dark .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color:#fff;\n	font-size:12px;\n}', NULL),
(4, 'Minimal Light', 'minimal-light', '/*************************************\n	-	MINIMAL LIGHT 3.0.0 SKIN	-\n*************************************/\n\n.minimal-light .navigationbuttons,\n.minimal-light .esg-pagination,\n.minimal-light .esg-filters {\n	text-align: center;\n}\n\n.minimal-light .esg-filter-wrapper.dropdownstyle >.esg-selected-filterbutton,\n.minimal-light input.eg-search-input,\n.minimal-light .esg-filterbutton,\n.minimal-light .esg-navigationbutton,\n.minimal-light .esg-sortbutton,\n.minimal-light .esg-cartbutton a,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 16px;\n	border: 1px solid #e5e5e5;\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n .minimal-light input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n}\n\n.minimal-light .esg-navigationbutton * {\n	color: #999;\n}\n\n.minimal-light .esg-navigationbutton {\n	padding: 0px 16px;\n}\n\n.minimal-light .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.minimal-light .esg-left,\n.minimal-light .esg-right {\n	padding: 0px 11px;\n}\n\n.minimal-light .esg-sortbutton-wrapper,\n.minimal-light .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.minimal-light .esg-sortbutton-order,\n.minimal-light .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid #e5e5e5;\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0px 5px 5px 0px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #fff;\n}\n\n.minimal-light .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.minimal-light .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.minimal-light .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.minimal-light .esg-sortbutton,\n.minimal-light .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 5px 0px 0px 5px;\n}\n\n.minimal-light input.eg-search-input.hovered,\n.minimal-light input.eg-search-input:focus,\n.minimal-light .esg-navigationbutton.hovered,\n.minimal-light .esg-filterbutton.hovered,\n.minimal-light .esg-sortbutton.hovered,\n.minimal-light .esg-sortbutton-order.hovered,\n.minimal-light .esg-cartbutton.hovered a,\n.minimal-light .esg-filter-wrapper.dropdownstyle >.esg-selected-filterbutton.hovered,\n.minimal-light .esg-filterbutton.selected,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.minimal-light .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.minimal-light .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.minimal-light .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left:10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.minimal-light .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left:-22px;\n	margin-right:10px;\n}\n\n.minimal-light .esg-filterbutton.selected .esg-filter-checked,\n.minimal-light .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.minimal-light .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n\n.minimal-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.minimal-light .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.minimal-light .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left:50%;\n	background:rgba(255,255,255,0.95);\n	border-radius: 5px;\n	border: 1px solid #e5e5e5;\n}\n\n.minimal-light .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border:none;\n	box-shadow: none;\n	text-align: left;\n	color:#999;\n	background:transparent;\n	line-height: 25px;\n	min-height: 25px;\n}\n\n.minimal-light .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.minimal-light .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#333;\n}\n\n.minimal-light .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right:-10px;\n	font-size:12px;\n}\n\n.minimal-light .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#333;\n}', NULL),
(5, 'Simple Light', 'simple-light', '/*************************************\n	-	SIMPLE LIGHT 3.0.0 SKIN   -\n*************************************/\n\n.simple-light .navigationbuttons,\n.simple-light .esg-pagination,\n.simple-light .esg-filters {\n	text-align: center;\n}\n\n.simple-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.simple-light input.eg-search-input,\n.simple-light .esg-filterbutton,\n.simple-light .esg-navigationbutton,\n.simple-light .esg-sortbutton,\n.simple-light .esg-cartbutton,\n.simple-light .esg-sortbutton-order,\n.simple-light .esg-cartbutton-order,\n.simple-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.simple-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 11px;\n	border: 1px solid #e5e5e5;\n	line-height: 30px;\n	font-size: 12px;\n	font-weight: 400;\n	font-family: \"Open Sans\",sans-serif;\n 	display: inline-block;\n	background: #eee;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 30px;\n	vertical-align: middle;\n}\n\n.simple-light .esg-cartbutton a {\n	color:#000;\n}\n\n.simple-light input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.simple-light .esg-navigationbutton * {\n	color: #000;\n}\n\n.simple-light .esg-left,\n.simple-light .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.simple-light .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.simple-light .esg-sortbutton-wrapper,\n.simple-light .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.simple-light .esg-sortbutton-order,\n.simple-light .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.simple-light .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.simple-light .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.simple-light .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.simple-light .esg-sortbutton,\n.simple-light .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.simple-light input.eg-search-input.hovered,\n.simple-light input.eg-search-input:focus,\n.simple-light .esg-navigationbutton.hovered,\n.simple-light .esg-filterbutton.hovered,\n.simple-light .esg-sortbutton.hovered,\n.simple-light .esg-sortbutton-order.hovered,\n.simple-light .esg-cartbutton.hovered,\n.simple-light .esg-filterbutton.selected,\n.simple-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.simple-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.simple-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.simple-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.simple-light .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.simple-light .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.simple-light .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.simple-light .esg-filter-checked {\n	color: #c5c5c5;\n	background: #ddd;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 20px;\n	vertical-align: middle;\n}\n\n.simple-light .esg-filterbutton.selected .esg-filter-checked,\n.simple-light .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.simple-light .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.simple-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.simple-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.simple-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.simple-light .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius:0px;\n}\n\n.simple-light .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n}\n\n.simple-light .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n}\n\n.simple-light .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.simple-light .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.simple-light .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}', NULL),
(6, 'Simple Dark', 'simple-dark', '/*************************************\n	-	SIMPLE DARK 3.0.0 SKIN   -\n*************************************/\n\n.simple-dark .navigationbuttons,\n.simple-dark .esg-pagination,\n.simple-dark .esg-filters {\n	text-align: center;\n}\n\n.simple-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.simple-dark input.eg-search-input,\n.simple-dark .esg-filterbutton,\n.simple-dark .esg-navigationbutton,\n.simple-dark .esg-sortbutton,\n.simple-dark .esg-cartbutton,\n.simple-dark .esg-sortbutton-order,\n.simple-dark .esg-cartbutton-order,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 10px;\n	border:1px solid rgba(255,255,255,0.15);\n	line-height: 29px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\",sans-serif;\n 	display: inline-block;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 29px;\n	background: rgba(255,255,255,0.08 );\n	vertical-align: middle;\n}\n\n.simple-dark .esg-cartbutton a {\n	color:#fff;\n}\n\n.simple-dark input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n\n\n.simple-dark .esg-navigationbutton * {\n	color: #fff;\n}\n\n.simple-dark .esg-left,\n.simple-dark .esg-right {\n	color: #fff;\n	padding: 0px 7px;\n}\n\n.simple-dark .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.simple-dark .esg-sortbutton-wrapper,\n.simple-dark .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.simple-dark .esg-sortbutton-order,\n.simple-dark .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.simple-dark .esg-cartbutton {\n	color: #000;\n	cursor: default !important;\n}\n\n.simple-dark .esg-cartbutton .esgicon-basket {\n	color: #000;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.simple-dark .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.simple-dark .esg-sortbutton,\n.simple-dark .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.simple-dark input.eg-search-input.hovered,\n.simple-dark input.eg-search-input:focus,\n.simple-dark .esg-navigationbutton.hovered,\n.simple-dark .esg-filterbutton.hovered,\n.simple-dark .esg-sortbutton.hovered,\n.simple-dark .esg-sortbutton-order.hovered,\n.simple-dark .esg-cartbutton.hovered,\n.simple-dark .esg-filterbutton.selected,\n.simple-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.simple-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #fff;\n	color: #000;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.simple-dark .esg-cartbutton.hovered a,\n.simple-dark input.eg-search-input.hovered::placeholder {\n	color:#000;\n}\n\n.simple-dark .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.simple-dark .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	color: #000;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.simple-dark .esg-filter-checked {\n	color: transparent;\n	background: rgba(255,255,255,0.15);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	vertical-align: top;\n}\n\n.simple-dark .esg-filterbutton.selected .esg-filter-checked,\n.simple-dark .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n\n\n.simple-dark .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 29px;\n	white-space: nowrap;\n}\n\n.simple-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.simple-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.simple-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n    border-radius:0px;\n}\n\n.simple-dark .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n	border:1px solid rgba(255,255,255,0.15);\n}\n\n.simple-dark .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color:#777;\n}\n\n.simple-dark .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n	border: 1px solid rgba(0,0,0,0.2);\n}\n\n.simple-dark .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.simple-dark .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#000;\n}\n\n.simple-dark .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#fff;\n}\n.simple-dark .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.simple-dark .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#000;\n}', NULL),
(7, 'Text Dark', 'text-dark', '/*************************************\n	-	TEXT DARK 3.0.0 SKIN   -\n*************************************/\n\n.text-dark .navigationbuttons,\n.text-dark .esg-pagination,\n.text-dark .esg-filters {\n	text-align: center;\n}\n\n.text-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.text-dark input.eg-search-input,\n.text-dark .esg-filterbutton,\n.text-dark .esg-navigationbutton,\n.text-dark .esg-sortbutton,\n.text-dark .esg-cartbutton,\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	color: rgba(255, 255, 255, 0.4);\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px 0px 10px;\n	line-height: 20px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 20px;\n	vertical-align: top;\n}\n\n.text-dark .esg-cartbutton a {\n	color: #fff;\n}\n\n.text-dark input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color: rgba(255, 255, 255, 0.4);\n}\n\n.text-dark .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 0.4);\n}\n\n.text-dark .esg-sortbutton-wrapper,\n.text-dark .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.text-dark .esg-sortbutton-order,\n.text-dark .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 29px;\n	line-height: 20px;\n	font-size: 9px;\n	font-weight: 700;\n	color: #fff;\n	color: rgba(255, 255, 255, 0.4);\n	cursor: pointer;\n	background: transparent;\n}\n\n.text-dark .esg-cartbutton {\n	color: rgba(255, 255, 255, 0.4);\n	cursor: default !important;\n}\n\n.text-dark .esg-cartbutton .esgicon-basket {\n	color: rgba(255, 255, 255, 0.4);\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.text-dark .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.text-dark .esg-sortbutton,\n.text-dark .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n}\n\n.text-dark input.eg-search-input.hovered,\n.text-dark input.eg-search-input:focus,\n.text-dark .esg-navigationbutton.hovered,\n.text-dark .esg-filterbutton.hovered,\n.text-dark .esg-sortbutton.hovered,\n.text-dark .esg-filterbutton.selected,\n.text-dark .esg-sortbutton-order.hovered,\n.text-dark .esg-cartbutton-order.hovered,\n.text-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.text-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.text-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.text-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #fff;\n}\n\n.text-dark .esg-navigationbutton.hovered,\n.text-dark .esg-filterbutton:hover span:first-child,\n.text-dark .esg-filterbutton.selected span:first-child {\n	text-decoration: none;\n}\n\n.text-dark .esg-filterbutton {\n	border-right: 1px solid #fff;\n	border-right: 1px solid rgba(255, 255, 255, 0.15);\n}\n\n.text-dark .esg-filterbutton:last-child {\n	border-right: none;\n}\n\n.text-dark .esg-sortbutton-order {\n	padding-left: 10px;\n	border-left: 1px solid #fff;\n	border-left: 1px solid rgba(255, 255, 255, 0.15);\n}\n\n.text-dark .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.text-dark .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.15);\n	color: #fff;\n}\n\n.text-dark .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n\n.text-dark .esg-filterbutton.selected .esg-filter-checked,\n.text-dark .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n}\n\n.text-dark .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 20px;\n	white-space: nowrap;\n}\n\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:20px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border:none !important;\n	line-height: 20px;\n	height: 20px;\n}\n\n.text-dark .esg-dropdown-wrapper {\n	left: 0px;\n	background:rgba(0, 0, 0, 0.85);\n}\n\n.text-dark .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color: rgba(255, 255, 255, 0.4);\n}\n\n\n.text-dark .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.text-dark .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #fff;\n}\n\n.text-dark .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color: rgba(255, 255, 255, 0.4);\n}\n.text-dark .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.text-dark .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#fff;\n}', NULL),
(8, 'Text Light', 'text-light', '/*************************************\n	-	TEXT LIGHT 3.0.0 SKIN   -\n*************************************/\n\n.text-light .navigationbuttons,\n.text-light .esg-pagination,\n.text-light .esg-filters {\n	text-align: center;\n}\n\n.text-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.text-light input.eg-search-input,\n.text-light .esg-filterbutton,\n.text-light .esg-navigationbutton,\n.text-light .esg-sortbutton,\n.text-light .esg-cartbutton,\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px 0px 10px;\n	line-height: 20px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 20px;\n	vertical-align: top;\n}\n\n.text-light .esg-cartbutton a {\n	color: #999;\n}\n\n.text-light input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color: #999;\n}\n\n.text-light .esg-navigationbutton * {\n	color: #999;\n}\n\n.text-light .esg-sortbutton-wrapper,\n.text-light .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.text-light .esg-sortbutton-order,\n.text-light .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 29px;\n	line-height: 20px;\n	font-size: 9px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: transparent;\n}\n\n.text-light .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.text-light .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.text-light .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.text-light .esg-sortbutton,\n.text-light .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n}\n\n.text-light input.eg-search-input.hovered,\n.text-light input.eg-search-input:focus,\n.text-light .esg-navigationbutton.hovered,\n.text-light .esg-filterbutton.hovered,\n.text-light .esg-sortbutton.hovered,\n.text-light .esg-filterbutton.selected,\n.text-light .esg-sortbutton-order.hovered,\n.text-light .esg-cartbutton-order.hovered,\n.text-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.text-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.text-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.text-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #444;\n}\n\n.text-light .esg-cartbutton.hovered a,\n.text-light input.eg-search-input.hovered::placeholder {\n	color: #999;\n}\n\n.text-light .esg-navigationbutton.hovered,\n.text-light .esg-filterbutton:hover span:first-child,\n.text-light .esg-filterbutton.selected span:first-child {\n	text-decoration: none;\n}\n\n.text-light .esg-filterbutton {\n	border-right: 1px solid rgba(0, 0, 0, 0.15);\n}\n\n.text-light .esg-filterbutton:last-child {\n	border-right: none;\n}\n\n.text-light .esg-sortbutton-order {\n	padding-left: 10px;\n	border-left: 1px solid rgba(0, 0, 0, 0.15);\n}\n\n.text-light .esg-navigationbutton.hovered * {\n	color: #444;\n}\n\n.text-light .esg-sortbutton-order.hovered .tp-desc {\n	border-color: rgba(0, 0, 0, 0.15);\n	color: #444;\n}\n\n.text-light .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n\n.text-light .esg-filterbutton.selected .esg-filter-checked,\n.text-light .esg-filterbutton.hovered .esg-filter-checked {\n	color: #444;\n}\n\n.text-light .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 20px;\n	white-space: nowrap;\n}\n\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:20px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border:none !important;\n	line-height: 20px;\n	height: 20px;\n}\n\n.text-light .esg-dropdown-wrapper {\n	left: 0px;\n	background:rgba(255, 255, 255, 0.85);\n}\n\n.text-light .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color: #999;\n}\n\n\n.text-light .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.text-light .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #444;\n}\n\n.text-light .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color: #999;\n}\n.text-light .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.text-light .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#444;\n}', NULL),
(9, 'Pat LaFontaine', 'pat-lafontaine', '/*************************************\n	-	Pat LaFontaine 3.0.0 SKIN -\n*************************************/\n.pat-lafontaine .esg-overflowtrick {\n  margin: 20px 0\n}\n\n.pat-lafontaine .navigationbuttons,\n.pat-lafontaine .esg-pagination,\n.pat-lafontaine .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.pat-lafontaine .esg-filters {margin-bottom: 1px !important}\n\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.pat-lafontaine input.eg-search-input,\n.pat-lafontaine .esg-filterbutton,\n.pat-lafontaine .esg-navigationbutton,\n.pat-lafontaine .esg-sortbutton,\n.pat-lafontaine .esg-cartbutton,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 1px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 20px;\n	border: none;\n	line-height: 50px;\n	border-radius: 0;\n	font-size: 14px;\n	font-weight: 400;\n	font-family: \"Barlow Condensed\", sans-serif;\n	display: inline-block;\n	background: #eaedf1;\n	margin-bottom: 0 !important;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: middle;\n  	transition: all 0.3s ease;\n  	min-width: 50px;\n}\n\n.pat-lafontaine .esg-filter-wrapper {\n  margin: 0 !important\n    }\n\n.pat-lafontaine .esg-allfilter {\n  background: #f03e3f !important;\n  color: #fff !important\n}\n\n.pat-lafontaine .esg-allfilter.hovered {\n  background: #000 !important;\n  color: #fff !important\n}\n\n.pat-lafontaine span.eg-el-amount {\n  letter-spacing: 1px\n}\n\n.pat-lafontaine span.eg-el-amount:before {\n  content: \"[\";\n  opacity: 0.5\n}\n\n.pat-lafontaine span.eg-el-amount:after {\n  content: \"]\";\n  opacity: 0.5\n}\n\n.pat-lafontaine .esg-cartbutton a {\n	color: #000;\n}\n\n.pat-lafontaine input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#999;\n}\n\n.pat-lafontaine .esg-navigationbutton {\n	padding: 0px;\n	min-width: 50px;\n}\n\n.pat-lafontaine .esg-navigationbutton.esg-loadmore {\n  padding: 0 20px;\n  text-transform: uppercase;\n}\n\n.pat-lafontaine .esg-navigationbutton * {\n	color: #000;\n}\n\n.pat-lafontaine .esg-navigationbutton.hovered i {\n  	color: #fff;\n}\n\n.pat-lafontaine .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.pat-lafontaine .esg-sortbutton-wrapper,\n.pat-lafontaine .esg-cartbutton-wrapper {\n	display: inline-block;\n  	margin-right: 1px !important;\n  	margin-left: 0 !important;\n}\n\n.pat-lafontaine .esg-sortbutton-order,\n.pat-lafontaine .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: middle;\n	border: none;\n	width: 50px;\n	line-height: 50px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #eaedf1;\n	margin-left: 1px;\n  	border-radius: 0;\n}\n\n.pat-lafontaine .esg-sortbutton-order.eg-icon-down-open:before {\n  	content: \"arrow_downward\";\n 	font-family: \"Material Icons\";\n  	font-size: 18px;\n  	color: #000;\n  	vertical-align: middle;\n}\n\n.pat-lafontaine .esg-sortbutton-order.hovered.eg-icon-down-open:before {\n  color: #fff\n}\n\n.pat-lafontaine .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n 	border-radius: 0 !important;\n  	padding: 0 20px 0 16px\n}\n\n.pat-lafontaine .esg-cartbutton.hovered .eg-icon-basket,\n.pat-lafontaine .esg-cartbutton.hovered .ess-cart-content {\n  color: #fff\n}\n\n.pat-lafontaine .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.pat-lafontaine .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.pat-lafontaine .esg-sortbutton,\n.pat-lafontaine .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.pat-lafontaine input.eg-search-input.hovered,\n.pat-lafontaine input.eg-search-input:focus,\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.pat-lafontaine .esg-navigationbutton.hovered,\n.pat-lafontaine .esg-filterbutton.hovered,\n.pat-lafontaine .esg-sortbutton.hovered,\n.pat-lafontaine .esg-sortbutton-order.hovered,\n.pat-lafontaine .esg-cartbutton-order.hovered,\n.pat-lafontaine .esg-filterbutton.selected,\n.pat-lafontaine .esg-cartbutton.hovered,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #fff;\n	background: #000;\n}\n\n.pat-lafontaine .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.pat-lafontaine .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.pat-lafontaine .esg-filter-checked {\n	color: #cbcbcb;\n	background: none;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 13px;\n	vertical-align: middle;\n  	display: inline-block;\n    transform: translateY(-1px);\n  	border: 1px solid #cbcbcb;\n}\n.pat-lafontaine .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.pat-lafontaine .esg-filterbutton.selected .esg-filter-checked {\n  background: #fff;\n  color: #000;\n  border: 1px solid #fff;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.pat-lafontaine .esg-sortbutton {\n  	border-radius: 0;\n  	padding-right: 40px\n}\n\n.pat-lafontaine .esg-sortbutton:after,\n.pat-lafontaine .esg-selected-filterbutton .eg-icon-down-open:before{\n  	content: \"\";\n  	position: absolute;\n  	width: 5px;\n  	height: 5px;\n  	border-left: 1px solid #000;\n  	border-bottom: 1px solid #000;\n  	transform: rotate(-45deg) translateY(-6px);\n  	right: 15px;\n  	top: 50%\n}\n\n.pat-lafontaine .esg-sortbutton.hovered:after {\n  	border-left: 1px solid #fff;\n  	border-bottom: 1px solid #fff;\n}\n\n.pat-lafontaine .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.pat-lafontaine .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n  	width: 100%;\n}\n\n.pat-lafontaine .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n\n.pat-lafontaine .dropdownstyle .esg-filterbutton .esg-filter-checked {\n  margin-left: 0;\n  transform: translateY(-2px);\n}\n\n.pat-lafontaine .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.pat-lafontaine .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.pat-lafontaine .eg-search-wrapper {background: #3d3b3e}\n.pat-lafontaine .eg-search-wrapper .eg-search-input {\n  background: #3d3b3e;\n  font-style: italic;\n  border-bottom: 1px solid #868689;\n  line-height: 22px;\n  min-height: 22px;\n  padding: 0;\n  margin: 0 0 0 20px !important;\n}\n\n.pat-lafontaine .eg-search-wrapper .eg-search-input.hovered,\n.pat-lafontaine .eg-search-wrapper .eg-search-input:focus,\n.pat-lafontaine .eg-search-wrapper .eg-search-input:active,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  background-color: #3d3b3e !important;\n  color: #fff !important;\n}\n\n.pat-lafontaine .eg-search-wrapper .eg-search-input.hovered,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill:hover,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill:focus {\n  border-bottom: 1px solid #fff;\n  -webkit-text-fill-color: #fff;\n  -webkit-box-shadow: 0 0 0px 1000px #3d3b3e inset;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  margin-left: 0;\n  width: 46px;\n}\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered {\n  background: #000;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  margin-left: 0;\n  width: 46px;\n  background: #000;\n  color: #fff\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered {\n  background: #f03e3f;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Barlow+Condensed:ital,wght@0,400;0,500;0,600;1,400&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL);
INSERT INTO `wp_eg_navigation_skins` (`id`, `name`, `handle`, `css`, `navversion`) VALUES
(10, 'Grant Fuhr', 'grant-fuhr', '/*************************************\n	-	Grant Fuhr 3.0.0 SKIN -\n*************************************/\n.grant-fuhr .esg-filters {\n  margin-bottom: 20px !important;\n}\n\n.grant-fuhr .navigationbuttons,\n.grant-fuhr .esg-pagination,\n.grant-fuhr .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.grant-fuhr input.eg-search-input,\n.grant-fuhr .esg-filterbutton,\n.grant-fuhr .esg-navigationbutton,\n.grant-fuhr .esg-sortbutton,\n.grant-fuhr .esg-cartbutton,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 13px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 15px;\n	border: none;\n	line-height: 50px;\n	font-size: 12px;\n	font-weight: 400;\n	font-family: \"Open Sans\", sans-serif;\n  	font-style: italic;\n  	letter-spacing: 1px;\n	display: inline-block;\n	background: #2e2e34;\n	margin-bottom: 1px;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: top;\n  	border-radius: 0px !important;\n  	min-width: 42px;\n  	text-transform: none;\n}\n.grant-fuhr .esg-cartbutton-wrapper {\n  margin: 0 11px !important;\n}\n\n.grant-fuhr .esg-filterbutton.esg-allfilter {\n  	text-decoration: underline;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper {\n  position: relative;\n  margin: 0 2px 0 8px !important;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton {\n  padding-right: 35px;\n}\n\n.grant-fuhr .esg-filterbutton:before,\n.grant-fuhr .eg-search-wrapper:before,\n.grant-fuhr .esg-cartbutton:before,\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:before {\n  	width: 0;\n	height: 0;\n	border-style: solid;\n	border-width: 0 0 50px 12px;\n	border-color: transparent transparent #2e2e34 transparent;\n  	position: absolute;\n  	content:\"\";\n  	top: 0;\n  	left: -12px\n}\n\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton.hovered:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr .esg-filterbutton:after,\n.grant-fuhr .eg-search-wrapper .eg-search-clean:after,\n.grant-fuhr .esg-cartbutton:after,\n.grant-fuhr .esg-sortbutton-order:after,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:after {\n  	width: 0;\n	height: 0;\n	border-style: solid;\n	border-width: 50px 12px 0 0;\n	border-color: #2e2e34 transparent transparent transparent;\n  	position: absolute;\n  	content:\"\";\n  	top: 0;\n  	right: -12px\n}\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:after {\n  right: 1px\n}\n\n.grant-fuhr .esg-filterbutton.hovered:before,\n.grant-fuhr .esg-filterbutton.selected:before,\n.grant-fuhr .esg-cartbutton.hovered:before,\n.grant-fuhr .esg-sortbutton-wrapper.hovered:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr .esg-filterbutton.hovered:after,\n.grant-fuhr .esg-filterbutton.selected:after,\n.grant-fuhr .esg-cartbutton.hovered:after,\n.grant-fuhr .esg-sortbutton-wrapper.hovered:after,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover:after {\n  border-color: #fff157 transparent transparent transparent;\n}\n\n.esg-sortbutton-order.tp-desc {\n  transform: none;\n}\n\n.esg-sortbutton-order.tp-desc:before {\n  transform: scaleY(-1);\n}\n\n.grant-fuhr .esg-filterbutton .eg-el-amount {\n  position: absolute;\n  line-height: 27px;\n  min-width: 27px;\n  border-radius: 50%;\n  background: #fff157;\n  color: #000;\n  top: -13px;\n  right: -5px;\n  text-align: center;\n  z-index: 2;\n  font-style: normal;\n  font-weight: 600;\n\n}\n\n.grant-fuhr .esg-filterbutton .eg-el-amount:before,\n.grant-fuhr .esg-filterbutton .eg-el-amount:after {\n  display: none\n}\n\n.grant-fuhr .esg-filterbutton.selected .eg-el-amount {\n  background: #2e2e34;\n  color: #fff;\n}\n\n.grant-fuhr .esg-cartbutton a {\n	color: #fff;\n}\n\n.grant-fuhr .esg-cartbutton.hovered a {\n  color: #000;\n}\n\n.grant-fuhr .eg-search-wrapper {\n  position: relative\n}\n\n.grant-fuhr .eg-search-wrapper:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr input.eg-search-input {\n  background: #fff157;\n  outline-style: none;\n  margin-bottom: 0 !important;\n}\n\n.grant-fuhr input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.grant-fuhr input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  margin-left: 0 !important;\n  min-width: 50px;\n  background: #fff157;\n  color: #000;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered {\n  background: #2e2e34 !important;\n  color: #fff157 !important;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  margin-left: 0 !important;\n  min-width: 50px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered:after {\n	border-color: #fff157 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-sortbutton-order.eg-icon-down-open:before {\n  	content: \"arrow_downward\";\n 	font-family: \"Material Icons\";\n  	font-size: 18px;\n  	color: #000;\n  	vertical-align: middle;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered.eg-icon-down-open:before {\n  color: #fff\n}\n\n.grant-fuhr .esg-navigationbutton {\n	padding: 0px;\n	width:40px;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-loadmore {\n  	width: auto;\n  	padding: 0 20px\n}\n\n.grant-fuhr .esg-navigationbutton * {\n	color: #999;\n}\n\n.grant-fuhr .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.grant-fuhr .esg-navigationbutton.selected,\n.grant-fuhr .esg-navigationbutton.hovered {\n  color: #000 !important;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right,\n.grant-fuhr .esg-navigationbutton.esg-left {\n  width: 50px;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right i,\n.grant-fuhr .esg-navigationbutton.esg-left i {\n  color: #fff;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right.hovered i,\n.grant-fuhr .esg-navigationbutton.esg-left.hovered i {\n  color: #000;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper,\n.grant-fuhr .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.grant-fuhr .esg-sortbutton-order,\n.grant-fuhr .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: none;\n	width: 50px;\n	line-height: 40px;\n	border-radius: 0;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #fff157;\n	margin-left: 0;\n  	line-height: 50px;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered,\n.grant-fuhr .esg-cartbutton-order.hovered {\n  	color: #fff157 !important;\n  	background: #2e2e34 !important;\n}\n\n.grant-fuhr .esg-sortbutton-order:after {\n	border-color: #fff157 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered:after {\n  border-color: #2e2e34 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.grant-fuhr .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.grant-fuhr .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.grant-fuhr .esg-sortbutton,\n.grant-fuhr .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.grant-fuhr input.eg-search-input.hovered,\n.grant-fuhr input.eg-search-input:focus,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.grant-fuhr .esg-navigationbutton.hovered,\n.grant-fuhr .esg-filterbutton.hovered,\n.grant-fuhr .esg-sortbutton.hovered,\n.grant-fuhr .esg-sortbutton-order.hovered,\n.grant-fuhr .esg-cartbutton-order.hovered,\n.grant-fuhr .esg-filterbutton.selected,\n.grant-fuhr .esg-cartbutton.hovered,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #000;\n	background: #fff157;\n}\n\n.grant-fuhr .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.grant-fuhr .esg-allfilter.esg-allfilter {\n}\n\n.grant-fuhr .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.grant-fuhr .esg-filterbutton.selected .esg-filter-checked,\n.grant-fuhr .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.grant-fuhr .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative\n}\n\n.grant-fuhr .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n.grant-fuhr .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.grant-fuhr .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.grant-fuhr .esg-sortbutton:after,\n.grant-fuhr .esg-selected-filterbutton .eg-icon-down-open:before {\n  	content: \"\";\n  	position: absolute;\n  	width: 5px;\n  	height: 5px;\n  	border-left: 1px solid #fff157;\n  	border-bottom: 1px solid #fff157;\n  	transform: rotate(-45deg) translateY(-6px);\n  	right: 15px;\n  	top: 50%\n}\n\n.grant-fuhr .esg-sortbutton.hovered:after,\n.grant-fuhr .esg-selected-filterbutton.hovered .eg-icon-down-open:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover .esg-selected-filterbutton .eg-icon-down-open:before {\n  	border-left: 1px solid #000;\n  	border-bottom: 1px solid #000;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton {\n  width: 100%;\n  margin: 0;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton:before,\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton:after {\n  display: none;\n}\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover .esg-selected-filterbutton {\n  background: #fff157;\n  color: #000;\n}\n\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL),
(11, 'Leon Draisaitl', 'leon-draisaitl', '/*************************************\n	-	LEON DRAISAITL 3.0.0 SKIN   -\n*************************************/\n.leon-draisaitl .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.leon-draisaitl .navigationbuttons,\n.leon-draisaitl .esg-pagination,\n.leon-draisaitl .esg-filters {\n	text-align: center;\n}\n\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.leon-draisaitl input.eg-search-input,\n.leon-draisaitl .esg-filterbutton,\n.leon-draisaitl .esg-navigationbutton,\n.leon-draisaitl .esg-sortbutton,\n.leon-draisaitl .esg-cartbutton,\n.leon-draisaitl .esg-sortbutton-order,\n.leon-draisaitl .esg-cartbutton-order,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	cursor: pointer;\n	padding: 0px 20px;\n	border: 2px solid #000;\n	line-height: 50px;\n	font-size: 16px;\n	font-weight: 500;\n	font-family: \"Roboto Mono\", monospace;\n 	display: inline-block;\n	background: transparent;\n	margin: -2px -2px 0 0 !important;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: middle;\n  	min-width: 54px;\n  	box-shadow: inset 0px 0px 0px 0px #000;\n  	transition: all 0.4s ease;\n}\n\n.leon-draisaitl .esg-sortbutton-wrapper,\n.leon-draisaitl .esg-filter-wrapper,\n.leon-draisaitl .esg-cartbutton-wrapper {\n  margin: 0 !important;\n}\n\n.leon-draisaitl .esg-cartbutton a {\n	color:#000;\n}\n\n.leon-draisaitl input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.leon-draisaitl input.eg-search-input.hovered::placeholder {\n  color: #fff;\n}\n\n.leon-draisaitl .esg-navigationbutton * {\n	color: #000;\n}\n\n.leon-draisaitl .esg-left,\n.leon-draisaitl .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.leon-draisaitl .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.leon-draisaitl .esg-sortbutton-wrapper,\n.leon-draisaitl .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.leon-draisaitl .esg-sortbutton-order,\n.leon-draisaitl .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.leon-draisaitl .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.leon-draisaitl .esg-cartbutton.hovered *,\n.leon-draisaitl .esg-navigationbutton.hovered * {\n  color: #fff !important;\n}\n\n.leon-draisaitl .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.leon-draisaitl .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.leon-draisaitl .esg-sortbutton,\n.leon-draisaitl .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.leon-draisaitl input.eg-search-input.hovered,\n.leon-draisaitl input.eg-search-input:focus,\n.leon-draisaitl .esg-navigationbutton.hovered,\n.leon-draisaitl .esg-filterbutton.hovered,\n.leon-draisaitl .esg-sortbutton.hovered,\n.leon-draisaitl .esg-sortbutton-order.hovered,\n.leon-draisaitl .esg-cartbutton.hovered,\n.leon-draisaitl .esg-filterbutton.selected,\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #000;\n	color: #fff;\n	box-shadow: inset 0px 0px 0px 50px #000;\n}\n\n.leon-draisaitl .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.leon-draisaitl .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.leon-draisaitl .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.leon-draisaitl .esg-filter-checked {\n	color: #aaa;\n  	border: 2px solid #000;\n	background: transparent;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 14px;\n	vertical-align: middle;\n  	text-align: center;\n  	min-width: 18px;\n  	display: inline-block;\n}\n\n.leon-draisaitl .esg-filterbutton.selected .esg-filter-checked,\n.leon-draisaitl .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n	background: #fff;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius:0px;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper {\n	left: 0px;\n	background: #fff;\n  	border: 2px solid #000;\n  	margin-top: -2px;\n  	padding: 0;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding: 5px 20px;\n	border:none;\n	box-shadow: none;\n  	box-sizing: border-box;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.esg-allfilter {\n  width: 100%;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.selected,\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.hovered {\n  background: #000;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n  margin: 0 10px 0 -2px;\n}\n\n.leon-draisaitl .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.leon-draisaitl .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.leon-draisaitl .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open {\n	color: #fff;\n}\n\n.leon-draisaitl .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Roboto+Mono:wght@400;500&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n', NULL),
(12, 'Uwe Krupp', 'uwe-krupp', '/*************************************\n	-	UWE KRUPP 3.0.0 SKIN   -\n*************************************/\n.uwe-krupp .esg-overflowtrick {\n  margin: 50px 0;\n}\n\n.uwe-krupp .navigationbuttons,\n.uwe-krupp .esg-pagination,\n.uwe-krupp .esg-filters {\n	text-align: center;\n}\n\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.uwe-krupp input.eg-search-input,\n.uwe-krupp .esg-filterbutton,\n.uwe-krupp .esg-navigationbutton,\n.uwe-krupp .esg-sortbutton,\n.uwe-krupp .esg-cartbutton,\n.uwe-krupp .esg-sortbutton-order,\n.uwe-krupp .esg-cartbutton-order,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #6a666b;\n  	letter-spacing: 1px;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px;\n	line-height: 40px;\n	font-size: 13px;\n	font-weight: 400;\n	font-family: \"Arvo\", serif;\n 	display: inline-block;\n	background: rgba(255, 255, 255, 0.65);\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	min-width: 40px;\n  	border-radius: 12px;\n}\n\n.uwe-krupp .esg-cartbutton a {\n	color:#000;\n}\n\n.uwe-krupp input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color: #6a666b;\n}\n\n.uwe-krupp input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-right,\n.uwe-krupp .esg-navigationbutton.esg-left {\n  background: #b0a5b4;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-left {\n  border-radius: 0 12px 12px 0px;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-right {\n  border-radius: 12px 0px 0px 12px;\n}\n\n.uwe-krupp .esg-navigationbutton * {\n	color: #000;\n}\n\n.uwe-krupp .esg-left,\n.uwe-krupp .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.uwe-krupp .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.uwe-krupp .esg-sortbutton-wrapper,\n.uwe-krupp .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.uwe-krupp .esg-sortbutton-order,\n.uwe-krupp .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.uwe-krupp .esg-cartbutton {\n	color: #757176;\n	cursor: default !important;\n}\n\n.uwe-krupp .esg-cartbutton .esgicon-basket {\n	color: #757176;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.uwe-krupp .esg-cartbutton .ess-cart-content {\n  color: #757176;\n}\n\n.uwe-krupp .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.uwe-krupp .esg-sortbutton,\n.uwe-krupp .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.uwe-krupp input.eg-search-input.hovered,\n.uwe-krupp input.eg-search-input:focus,\n.uwe-krupp .esg-navigationbutton.hovered,\n.uwe-krupp .esg-filterbutton.hovered,\n.uwe-krupp .esg-sortbutton.hovered,\n.uwe-krupp .esg-sortbutton-order.hovered,\n.uwe-krupp .esg-cartbutton.hovered,\n.uwe-krupp .esg-filterbutton.selected,\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	color: #333;\n}\n\n.uwe-krupp .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.uwe-krupp .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.uwe-krupp .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.uwe-krupp .esg-filter-checked {\n	color: #b0a5b4;\n	background: transparent;\n  	border: 1px solid #b0a5b4;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 12px;\n 	min-width: 12px;\n	vertical-align: middle;\n  	display: inline-block;\n  	transform: translateY(-1px);\n}\n\n.uwe-krupp .esg-filterbutton.selected .esg-filter-checked,\n.uwe-krupp .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n  	border: 1px solid #000;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius: 12px 0px 0px 12px;\n  	border: none;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  border-radius: 0px 12px 12px 0px;\n  margin-left: 0;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  background: #b0a5b4;\n  color: #fff;\n}\n\n.uwe-krupp .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n}\n\n.uwe-krupp .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n}\n\n.uwe-krupp .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.uwe-krupp .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.uwe-krupp .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}\n\n.uwe-krupp .esg-sortbutton-order.eg-icon-down-open {\n  background: #b0a5b4;\n  color: #fff;\n}\n\n.uwe-krupp .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL),
(13, 'Clark Gillies', 'clark-gillies', '/*************************************\n	-	CLARK GILLIES 3.0.0 SKIN   -\n*************************************/\n.clark-gillies .navigationbuttons,\n.clark-gillies .esg-pagination,\n.clark-gillies .esg-filters {\n	text-align: center;\n}\n\n.clark-gillies .esg-filters {\n  margin-bottom: 20px !important;\n}\n\n.clark-gillies .esg-filter-wrapper {\n  margin: 0 !important;\n}\n\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.clark-gillies input.eg-search-input,\n.clark-gillies .esg-filterbutton,\n.clark-gillies .esg-navigationbutton,\n.clark-gillies .esg-sortbutton,\n.clark-gillies .esg-cartbutton,\n.clark-gillies .esg-sortbutton-order,\n.clark-gillies .esg-cartbutton-order,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin: 0 10px 0 0 !important;\n	cursor: pointer;\n	padding: 0px 10px;\n  	border: none;\n	line-height: 28px;\n	font-size: 13px;\n	font-weight: 400;\n	font-family: \"Arvo\", serif;\n 	display: inline-block;\n	background: transparent;\n	white-space: nowrap;\n	min-height: 28px;\n	vertical-align: middle;\n  	letter-spacing: -0.5px;\n  	min-width: 24px;\n  	position: relative;\n  	transition: all 0.3s ease;\n}\n\n.clark-gillies .esg-filterbutton:before,\n.clark-gillies .esg-selected-filterbutton:before,\n.clark-gillies .esg-sortbutton:before {\n  content: \"\";\n  position: absolute;\n  z-index: -1;\n  height: 2px;\n  width: calc(100% - 20px);\n  left: 10px;\n  bottom: 0;\n  background: #000;\n  transition: all 0.3s ease;\n}\n\n.clark-gillies .esg-filterbutton.hovered:before,\n.clark-gillies .esg-filterbutton.selected:before,\n.clark-gillies .esg-filter-wrapper:hover .esg-selected-filterbutton:before,\n.clark-gillies .esg-sortbutton.hovered:before{\n  width: 100%;\n  height: 100%;\n  left: 0;\n}\n\n.clark-gillies .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open {\n  color: #fff !important;\n}\n\n.clark-gillies .esg-cartbutton a {\n	color:#fff;\n}\n\n.clark-gillies input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.clark-gillies input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.clark-gillies .esg-navigationbutton {\n  min-width: 28px;\n}\n\n.clark-gillies .esg-navigationbutton * {\n	color: #fff;\n}\n\n.clark-gillies .esg-left,\n.clark-gillies .esg-right,\n.clark-gillies .esg-loadmore {\n	color: #fff;\n	padding: 2px 7px;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 20px #000;\n}\n.clark-gillies .esg-left.hovered,\n.clark-gillies .esg-right.hovered,\n.clark-gillies .esg-loadmore.hovered {\n  color: #000 !important;\n  box-shadow: inset 0 0 0 2px #000;\n}\n\n.clark-gillies .esg-loadmore {\n  padding: 0 10px;\n}\n\n.clark-gillies .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.clark-gillies .esg-sortbutton-wrapper,\n.clark-gillies .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.clark-gillies .esg-sortbutton-order,\n.clark-gillies .esg-cartbutton-order,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n	padding: 0px;\n	min-width: 30px;\n	font-size: 9px;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 2px #000;\n  	margin-right: 20px !important;\n}\n\n.clark-gillies .esg-sortbutton-order.hovered,\n.clark-gillies .esg-cartbutton-order.hovered,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered {\n  	box-shadow: inset 0 0 0 20px #000\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  font-size: 12px;\n  line-height: 28px !important;\n}\n\n.clark-gillies .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n.clark-gillies .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 20px #000;\n}\n\n.clark-gillies .esg-cartbutton.hovered {\n  	box-shadow: inset 0 0 0 2px #000;\n}\n\n.clark-gillies .esg-cartbutton .ess-cart-content {\n  	color: #fff;\n}\n\n.clark-gillies .esg-cartbutton.hovered .ess-cart-content {\n  	color: #000;\n}\n\n.clark-gillies .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.clark-gillies .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.clark-gillies .esg-sortbutton,\n.clark-gillies .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0 !important;\n}\n\n.clark-gillies input.eg-search-input.hovered,\n.clark-gillies input.eg-search-input:focus,\n.clark-gillies .esg-navigationbutton.hovered,\n.clark-gillies .esg-filterbutton.hovered,\n.clark-gillies .esg-sortbutton.hovered,\n.clark-gillies .esg-sortbutton-order.hovered,\n.clark-gillies .esg-cartbutton.hovered,\n.clark-gillies .esg-filterbutton.selected,\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #fff;\n}\n\n.clark-gillies .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.clark-gillies .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.clark-gillies .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.clark-gillies .esg-filter-checked {\n	color: #000;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 20px;\n	vertical-align: middle;\n  	border: 1px solid #000;\n  	background: transparent;\n  	padding: 1px 0;\n}\n\n.clark-gillies .esg-filterbutton.selected .esg-filter-checked,\n.clark-gillies .esg-filterbutton.hovered .esg-filter-checked,\n.clark-gillies .esg-dropdown-wrapper .esg-filter-checked {\n	color: #000;\n	background: #fff;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filter-checked {\n  margin-left: 0;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 22px;\n	white-space: nowrap;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 0;\n  	border-bottom: 2px solid #000;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width: 29px;\n	padding: 0px;\n	margin-left: 0px;\n	margin-right: 0px;\n  	min-height: 26px;\n  	line-height: 26px;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width: auto;\n	border-radius: 0px;\n  	border-bottom: 2px solid #000;\n  	margin: 0 !important;\n  	padding: 2px 0;\n  	min-height: 22px;\n  	line-height: 22px;\n  	font-size: 13px;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input:focus,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input:active,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input.hovered {\n  color: #000;\n}\n\n.clark-gillies .esg-dropdown-wrapper {\n	left: 0px;\n	background: #000;\n 	width: 100%;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background: transparent;\n	padding: 0px;\n	border: none;\n	box-shadow: none;\n  	color: #fff;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filterbutton.hovered {\n  opacity: 0.6;\n}\n\n.clark-gillies .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.clark-gillies .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.clark-gillies .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}\n\n.clark-gillies .esg-filterbutton .eg-el-amount:before,\n.clark-gillies .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL),
(14, 'Rod Langway', 'rod-langway', '/*************************************\n	-	ROD LANGWAY 3.0.0 SKIN	-\n*************************************/\n.rod-langway .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.rod-langway .navigationbuttons,\n.rod-langway .esg-pagination,\n.rod-langway .esg-filters {\n	text-align: center;\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.rod-langway input.eg-search-input,\n.rod-langway .esg-filterbutton,\n.rod-langway .esg-navigationbutton,\n.rod-langway .esg-sortbutton,\n.rod-langway .esg-cartbutton,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 0;\n	cursor: pointer;\n	padding: 4px 17px 0;\n	border: none;\n  	box-sizing: border-box;\n	line-height: 35px;\n	font-size: 10px;\n  	text-transform: uppercase;\n  	letter-spacing: 3px;\n	font-weight: 700;\n	font-family: \"Josefin Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	border-radius: 0;\n}\n.rod-langway  .esg-filterbutton .eg-el-amount {\n  background: #ced3d7;\n  display: inline-block;\n  line-height: 24px;\n  min-width: 26px;\n  padding-top: 2px;\n  text-align: center;\n  font-weight: 500;\n  font-size: 12px;\n  letter-spacing: 0;\n}\n\n.rod-langway  .esg-filterbutton.hovered .eg-el-amount,\n.rod-langway  .esg-filterbutton.selected .eg-el-amount {\n  background: #2f2f3a;\n  color: #fff;\n}\n\n.rod-langway .esg-filterbutton .eg-el-amount:before,\n.rod-langway .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n  margin-left: 0 !important;\n  font-size: 14px;\n  letter-spacing: 0;\n  line-height: 40px;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-cartbutton {\n  background: #ced3d7;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.rod-langway .esg-cartbutton.hovered {\n  background: #b0b5b9 !important;\n}\n\n.rod-langway .esg-cartbutton a {\n	color: #000;\n}\n\n.rod-langway .esg-cartbutton a:hover {\n	color: #000;\n}\n\n.rod-langway input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color: #b0b5b9;\n}\n\n.rod-langway input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.rod-langway .esg-navigationbutton {\n  line-height: 40px;\n  min-width: 40px;\n  letter-spacing: 0;\n  font-size: 14px;\n  font-weight: 400;\n}\n\n.rod-langway .esg-navigationbutton.esg-left {\n  transform: translateX(-40px)\n}\n\n.rod-langway .esg-navigationbutton.esg-right {\n  transform: translateX(40px)\n}\n\n.rod-langway .esg-navigationbutton * {\n	color: #000;\n\n}\n\n.rod-langway .esg-navigationbutton.hovered i {\n	color: #000;\n}\n\n.rod-langway .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.rod-langway .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.rod-langway .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.rod-langway .esg-sortbutton-wrapper,\n.rod-langway .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.rod-langway .esg-sortbutton-order,\n.rod-langway .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 40px;\n	line-height: 40px;\n	border-radius: 0;\n  	border: none;\n	font-size: 12px;\n	font-weight: 600;\n	color: #000;\n	cursor: pointer;\n  	background: #ced3d7;\n}\n\n.rod-langway .esg-sortbutton-order.hovered,\n.rod-langway .esg-cartbutton-order.hovered {\n  background: #b0b5b9 !important;\n}\n\n.rod-langway .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.rod-langway .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.rod-langway .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.rod-langway .esg-sortbutton,\n.rod-langway .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n}\n\n.rod-langway .esg-sortbutton{\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 0;\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.rod-langway .esg-navigationbutton.hovered,\n.rod-langway .esg-filterbutton.hovered,\n.rod-langway .esg-sortbutton.hovered,\n.rod-langway .esg-sortbutton-order.hovered,\n.rod-langway .esg-cartbutton-order.hovered,\n.rod-langway .esg-filterbutton.selected,\n.rod-langway .esg-cartbutton.hovered,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	box-shadow: none;\n	background: #ced3d7;\n}\n\n.rod-langway .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.rod-langway .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.rod-langway .esg-filter-checked {\n	color: #ced3d7;\n  	border: 1px solid #333;\n  	letter-spacing: 0;\n	background: transparent;\n	font-size: 9px;\n	font-weight: 300;\n	vertical-align: middle;\n  	line-height: 14px;\n	margin-left: 7px;\n  	display: inline-block;\n  	width: 14px;\n  	height: 14px;\n  	transform: translateY(-2px);\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left: 0;\n	margin-right: 10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.rod-langway .esg-filterbutton.selected .esg-filter-checked,\n.rod-langway .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n  	border: 1px solid #000;\n}\n\n/* */\n.rod-langway .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.rod-langway .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background: #000;\n	border-radius: 0;\n  	padding: 0;\n}\n\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border: none;\n	box-shadow: none;\n	text-align: left;\n	color: #fff;\n	background: transparent;\n	line-height: 25px;\n	min-height: 25px;\n  	padding: 10px 20px;\n  	display: inline-block;\n  	width: 100%;\n  	box-sizing: border-box;\n  	margin: 0;\n}\n\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #000;\n  	background: #fff;\n}\n\n\n.rod-langway .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color: #000;\n	font-size: 11px;\n}\n\n.rod-langway .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n@import url(\"https://fonts.googleapis.com/css2?family=Josefin+Sans:wght@400;500;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL),
(15, 'Ray Bourge', 'ray-bourque', '/**************************************\n	-	RAY BOURGE V3.0.0 SKIN    -\n**************************************/\n\n\n\n.ray-bourque .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.ray-bourque .navigationbuttons,\n.ray-bourque .esg-pagination,\n.ray-bourque .esg-filters {\n	text-align: center;\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.ray-bourque input.eg-search-input,\n.ray-bourque .esg-filterbutton,\n.ray-bourque .esg-navigationbutton,\n.ray-bourque .esg-sortbutton,\n.ray-bourque .esg-cartbutton,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: rgba(255, 255, 255, 1);\n	margin-right: 0;\n	cursor: pointer;\n	padding: 0px 17px;\n	border: none;\n	line-height: 40px;\n	font-size: 13px;\n  	letter-spacing: 1px;\n	font-weight: 400;\n	font-family: \"Barlow Condensed\", sans-serif;\n	display: inline-block;\n	background: #000;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	border-radius: 0;\n}\n.ray-bourque  .esg-filterbutton .eg-el-amount {\n  background: #2d2b2b;\n  display: inline-block;\n  line-height: 22px;\n  min-width: 22px;\n  text-align: center;\n  font-weight: 500;\n}\n\n.ray-bourque  .esg-filterbutton.hovered .eg-el-amount,\n.ray-bourque  .esg-filterbutton.selected .eg-el-amount {\n  background: #eaedf1;\n}\n\n.ray-bourque  .esg-filterbutton .eg-el-amount:before,\n.ray-bourque  .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n  margin-left: 0 !important;\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean {\n  background: #434242;\n}\n\n.ray-bourque .esg-cartbutton a {\n	color: #fff;\n}\n\n.ray-bourque .esg-cartbutton a:hover {\n	color: #000;\n}\n\n.ray-bourque input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.ray-bourque input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.ray-bourque .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 1);\n}\n\n.ray-bourque .esg-navigationbutton.hovered i {\n	color: #000;\n}\n\n.ray-bourque .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.ray-bourque .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.ray-bourque .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.ray-bourque .esg-sortbutton-wrapper,\n.ray-bourque .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.ray-bourque .esg-sortbutton-order,\n.ray-bourque .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0;\n  	border: none;\n	font-size: 12px;\n	font-weight: 600;\n	color: #fff;\n	cursor: pointer;\n	background: #434242;\n}\n\n.ray-bourque .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.ray-bourque .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.ray-bourque .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.ray-bourque .esg-sortbutton,\n.ray-bourque .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n}\n.ray-bourque .esg-sortbutton{\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 0;\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.ray-bourque .esg-navigationbutton.hovered,\n.ray-bourque .esg-filterbutton.hovered,\n.ray-bourque .esg-sortbutton.hovered,\n.ray-bourque .esg-sortbutton-order.hovered,\n.ray-bourque .esg-cartbutton-order.hovered,\n.ray-bourque .esg-filterbutton.selected,\n.ray-bourque .esg-cartbutton.hovered,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	box-shadow: none;\n	background: #fff;\n}\n\n.ray-bourque .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.ray-bourque .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.ray-bourque .esg-filter-checked {\n	color: rgba(255,255,255,.5);\n  	border: 1px solid rgba(255,255,255,.5);\n	background: transparent;\n	font-size: 9px;\n	font-weight: 300;\n	vertical-align: middle;\n  	line-height: 12px;\n	margin-left: 7px;\n  	display: inline-block;\n  	width: 14px;\n  	height: 14px;\n  	transform: translateY(-2px);\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left: 0;\n	margin-right: 10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.ray-bourque .esg-filterbutton.selected .esg-filter-checked,\n.ray-bourque .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n  	border: 1px solid #000;\n}\n\n/* */\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.ray-bourque .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background: #000;\n	border-radius: 0;\n  	padding: 0;\n}\n\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border: none;\n	box-shadow: none;\n	text-align: left;\n	color: #fff;\n	background: transparent;\n	line-height: 25px;\n	min-height: 25px;\n  	padding: 10px 20px;\n  	display: inline-block;\n  	width: 100%;\n  	box-sizing: border-box;\n  	margin: 0;\n}\n\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #000;\n  	background: #fff;\n}\n\n\n.ray-bourque .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color:#fff;\n	font-size:12px;\n}\n\n.ray-bourque .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Barlow+Condensed:wght@400;500&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL);
INSERT INTO `wp_eg_navigation_skins` (`id`, `name`, `handle`, `css`, `navversion`) VALUES
(16, 'Flat Light-205234', 'flat-light-205234', '/*************************************\n	-	FLAT LIGHT 3.0.0 SKIN -\n*************************************/\n\n.flat-light-205234 .navigationbuttons,\n.flat-light-205234 .esg-pagination,\n.flat-light-205234 .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.flat-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.flat-light-205234 input.eg-search-input,\n.flat-light-205234 .esg-filterbutton,\n.flat-light-205234 .esg-navigationbutton,\n.flat-light-205234 .esg-sortbutton,\n.flat-light-205234 .esg-cartbutton,\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 30px;\n	border: 1px solid rgba(0,0,0,0.15);\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n}\n\n.flat-light-205234 .esg-cartbutton a {\n	color: #999;\n}\n\n.flat-light-205234 input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#999;\n}\n\n.flat-light-205234 .esg-navigationbutton {\n	padding: 0px;\n	width:40px;\n}\n\n.flat-light-205234 .esg-navigationbutton * {\n	color: #999;\n}\n\n.flat-light-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.flat-light-205234 .esg-sortbutton-wrapper,\n.flat-light-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.flat-light-205234 .esg-sortbutton-order,\n.flat-light-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid rgba(0,0,0,0.15);\n	width: 40px;\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #eee;\n	background: #fff;\n	margin-left: 5px;\n}\n\n.flat-light-205234 .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.flat-light-205234 .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.flat-light-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.flat-light-205234 .esg-sortbutton,\n.flat-light-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.flat-light-205234 input.eg-search-input.hovered,\n.flat-light-205234 input.eg-search-input:focus,\n.flat-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.flat-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.flat-light-205234 .esg-navigationbutton.hovered,\n.flat-light-205234 .esg-filterbutton.hovered,\n.flat-light-205234 .esg-sortbutton.hovered,\n.flat-light-205234 .esg-sortbutton-order.hovered,\n.flat-light-205234 .esg-cartbutton-order.hovered,\n.flat-light-205234 .esg-filterbutton.selected,\n.flat-light-205234 .esg-cartbutton.hovered,\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	background: #fff;\n    box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\n}\n\n.flat-light-205234 .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.flat-light-205234 .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.flat-light-205234 .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.flat-light-205234 .esg-filterbutton.selected .esg-filter-checked,\n.flat-light-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.flat-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.flat-light-205234 .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.flat-light-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative\n}\n\n.flat-light-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n.flat-light-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.flat-light-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}', NULL),
(17, 'Flat Dark-205234', 'flat-dark-205234', '/********************************\n	-	FLAT DARK 3.0.0 SKIN -\n*********************************/\n\n.flat-dark-205234 .navigationbuttons,\n.flat-dark-205234 .esg-pagination,\n.flat-dark-205234 .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.flat-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.flat-dark-205234 input.eg-search-input,\n.flat-dark-205234 .esg-filterbutton,\n.flat-dark-205234 .esg-navigationbutton,\n.flat-dark-205234 .esg-sortbutton,\n.flat-dark-205234 .esg-cartbutton,\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 5px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 1px 30px;\n	border: none;\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: rgba(0, 0, 0, 0.2);\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n.flat-dark-205234 .esg-cartbutton a {\n	color:#fff;\n}\n\n.flat-dark-205234 input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.flat-dark-205234 .esg-navigationbutton {\n	padding: 2px 12px;\n}\n\n.flat-dark-205234 .esg-navigationbutton * {\n	color: #fff;\n}\n\n.flat-dark-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.flat-dark-205234 .esg-sortbutton-wrapper,\n.flat-dark-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.flat-dark-205234 .esg-sortbutton-order,\n.flat-dark-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: none;\n	width: 40px;\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #fff;\n	cursor: pointer;\n	background: rgba(0, 0, 0, 0.2);\n	margin-left: 5px;\n}\n\n.flat-dark-205234 .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.flat-dark-205234 .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.flat-dark-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.flat-dark-205234 .esg-sortbutton,\n.flat-dark-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.flat-dark-205234 input.eg-search-input.hovered,\n.flat-dark-205234 input.eg-search-input:focus,\n.flat-dark-205234 .esg-navigationbutton.hovered,\n.flat-dark-205234 .esg-filterbutton.hovered,\n.flat-dark-205234 .esg-sortbutton.hovered,\n.flat-dark-205234 .esg-sortbutton-order.hovered,\n.flat-dark-205234 .esg-cartbutton-order.hovered,\n.flat-dark-205234 .esg-filterbutton.selected,\n.flat-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.flat-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.flat-dark-205234 .esg-cartbutton.hovered,\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #fff;\n	background: rgba(0, 0, 0, 0.5);\n}\n\n.flat-dark-205234 .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.flat-dark-205234 .esg-sortbutton-order.hovered .tp-desc {\n	color: #333;\n}\n\n.flat-dark-205234 .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.2);\n	margin-left: 7px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.flat-dark-205234 .esg-filterbutton.selected .esg-filter-checked,\n.flat-dark-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: rgba(0, 0, 0, 0.2);\n}\n\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.flat-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.flat-dark-205234 .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.flat-dark-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	background:rgba(0,0,0,0.5);\n}\n\n.flat-dark-205234 .esg-dropdown-wrapper .esg-filterbutton.selected,\n.flat-dark-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered {\n	background:rgba(0,0,0,0.75);\n}\n\n\n.flat-dark-205234 .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n	position: absolute;\n	left: 10px;\n	top: 50%;\n	transform: translateY(-50%);\n	width: 12px;\n	height: 12px;\n	text-align: center;\n	line-height: 12px\n}\n\n.flat-dark-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right:-10px;\n	font-size:12px;\n	color:#fff;\n}', NULL),
(18, 'Minimal Dark-205234', 'minimal-dark-205234', '/**************************************\n	-	MINIMAL DARK V3.0.0 SKIN    -\n**************************************/\n\n.minimal-dark-205234 .navigationbuttons,\n.minimal-dark-205234 .esg-pagination,\n.minimal-dark-205234 .esg-filters {\n	text-align: center;\n}\n\n.minimal-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.minimal-dark-205234 input.eg-search-input,\n.minimal-dark-205234 .esg-filterbutton,\n.minimal-dark-205234 .esg-navigationbutton,\n.minimal-dark-205234 .esg-sortbutton,\n.minimal-dark-205234 .esg-cartbutton,\n.minimal-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.minimal-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: rgba(255, 255, 255, 1);\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 17px;\n	border: 1px solid rgba(255, 255, 255, 0.1);\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n.minimal-dark-205234 .esg-cartbutton a {\n	color:#fff;\n}\n\n.minimal-dark-205234 input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.minimal-dark-205234 .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 1);\n}\n\n.minimal-dark-205234 .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.minimal-dark-205234 .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.minimal-dark-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.minimal-dark-205234 .esg-sortbutton-wrapper,\n.minimal-dark-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.minimal-dark-205234 .esg-sortbutton-order,\n.minimal-dark-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid rgba(255, 255, 255, 0.1);\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0px 5px 5px 0px;\n	font-size: 12px;\n	font-weight: 600;\n	color: #fff;\n	cursor: pointer;\n	background: transparent;\n}\n\n.minimal-dark-205234 .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.minimal-dark-205234 .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.minimal-dark-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.minimal-dark-205234 .esg-sortbutton,\n.minimal-dark-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 5px 0px 0px 5px;\n}\n\n.minimal-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.minimal-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.minimal-dark-205234 .esg-navigationbutton.hovered,\n.minimal-dark-205234 .esg-filterbutton.hovered,\n.minimal-dark-205234 .esg-sortbutton.hovered,\n.minimal-dark-205234 .esg-sortbutton-order.hovered,\n.minimal-dark-205234 .esg-cartbutton-order.hovered,\n.minimal-dark-205234 .esg-filterbutton.selected,\n.minimal-dark-205234 .esg-cartbutton.hovered,\n.minimal-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.minimal-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n	background: rgba(255, 255, 255, 0.1);\n}\n\n.minimal-dark-205234 .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.minimal-dark-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.minimal-dark-205234 .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n	margin-left:7px;\n}\n\n.minimal-dark-205234 .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left:-22px;\n	margin-right:10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.minimal-dark-205234 .esg-filterbutton.selected .esg-filter-checked,\n.minimal-dark-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: rgba(0, 0, 0, 0.10);\n}\n\n/* */\n.minimal-dark-205234 .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.minimal-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.minimal-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.minimal-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.minimal-dark-205234 .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:rgba(0,0,0,0.95);\n	border-radius: 5px;\n}\n\n.minimal-dark-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border:none;\n	box-shadow: none;\n	text-align: left;\n	color:rgba(255,255,255,0.5);\n	background:transparent;\n	line-height: 25px;\n	min-height: 25px;\n}\n\n.minimal-dark-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.minimal-dark-205234 .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#fff;\n}\n\n\n.minimal-dark-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color:#fff;\n	font-size:12px;\n}', NULL),
(19, 'Minimal Light-205234', 'minimal-light-205234', '/*************************************\n	-	MINIMAL LIGHT 3.0.0 SKIN	-\n*************************************/\n\n.minimal-light-205234 .navigationbuttons,\n.minimal-light-205234 .esg-pagination,\n.minimal-light-205234 .esg-filters {\n	text-align: center;\n}\n\n.minimal-light-205234 .esg-filter-wrapper.dropdownstyle >.esg-selected-filterbutton,\n.minimal-light-205234 input.eg-search-input,\n.minimal-light-205234 .esg-filterbutton,\n.minimal-light-205234 .esg-navigationbutton,\n.minimal-light-205234 .esg-sortbutton,\n.minimal-light-205234 .esg-cartbutton a,\n.minimal-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.minimal-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 16px;\n	border: 1px solid #e5e5e5;\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n .minimal-light-205234 input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n}\n\n.minimal-light-205234 .esg-navigationbutton * {\n	color: #999;\n}\n\n.minimal-light-205234 .esg-navigationbutton {\n	padding: 0px 16px;\n}\n\n.minimal-light-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.minimal-light-205234 .esg-left,\n.minimal-light-205234 .esg-right {\n	padding: 0px 11px;\n}\n\n.minimal-light-205234 .esg-sortbutton-wrapper,\n.minimal-light-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.minimal-light-205234 .esg-sortbutton-order,\n.minimal-light-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid #e5e5e5;\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0px 5px 5px 0px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #fff;\n}\n\n.minimal-light-205234 .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.minimal-light-205234 .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.minimal-light-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.minimal-light-205234 .esg-sortbutton,\n.minimal-light-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 5px 0px 0px 5px;\n}\n\n.minimal-light-205234 input.eg-search-input.hovered,\n.minimal-light-205234 input.eg-search-input:focus,\n.minimal-light-205234 .esg-navigationbutton.hovered,\n.minimal-light-205234 .esg-filterbutton.hovered,\n.minimal-light-205234 .esg-sortbutton.hovered,\n.minimal-light-205234 .esg-sortbutton-order.hovered,\n.minimal-light-205234 .esg-cartbutton.hovered a,\n.minimal-light-205234 .esg-filter-wrapper.dropdownstyle >.esg-selected-filterbutton.hovered,\n.minimal-light-205234 .esg-filterbutton.selected,\n.minimal-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.minimal-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.minimal-light-205234 .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.minimal-light-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.minimal-light-205234 .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left:10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.minimal-light-205234 .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left:-22px;\n	margin-right:10px;\n}\n\n.minimal-light-205234 .esg-filterbutton.selected .esg-filter-checked,\n.minimal-light-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.minimal-light-205234 .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n\n.minimal-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.minimal-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.minimal-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.minimal-light-205234 .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left:50%;\n	background:rgba(255,255,255,0.95);\n	border-radius: 5px;\n	border: 1px solid #e5e5e5;\n}\n\n.minimal-light-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border:none;\n	box-shadow: none;\n	text-align: left;\n	color:#999;\n	background:transparent;\n	line-height: 25px;\n	min-height: 25px;\n}\n\n.minimal-light-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.minimal-light-205234 .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#333;\n}\n\n.minimal-light-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right:-10px;\n	font-size:12px;\n}\n\n.minimal-light-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#333;\n}', NULL),
(20, 'Simple Light-205234', 'simple-light-205234', '/*************************************\n	-	SIMPLE LIGHT 3.0.0 SKIN   -\n*************************************/\n\n.simple-light-205234 .navigationbuttons,\n.simple-light-205234 .esg-pagination,\n.simple-light-205234 .esg-filters {\n	text-align: center;\n}\n\n.simple-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.simple-light-205234 input.eg-search-input,\n.simple-light-205234 .esg-filterbutton,\n.simple-light-205234 .esg-navigationbutton,\n.simple-light-205234 .esg-sortbutton,\n.simple-light-205234 .esg-cartbutton,\n.simple-light-205234 .esg-sortbutton-order,\n.simple-light-205234 .esg-cartbutton-order,\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 11px;\n	border: 1px solid #e5e5e5;\n	line-height: 30px;\n	font-size: 12px;\n	font-weight: 400;\n	font-family: \"Open Sans\",sans-serif;\n 	display: inline-block;\n	background: #eee;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 30px;\n	vertical-align: middle;\n}\n\n.simple-light-205234 .esg-cartbutton a {\n	color:#000;\n}\n\n.simple-light-205234 input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.simple-light-205234 .esg-navigationbutton * {\n	color: #000;\n}\n\n.simple-light-205234 .esg-left,\n.simple-light-205234 .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.simple-light-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.simple-light-205234 .esg-sortbutton-wrapper,\n.simple-light-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.simple-light-205234 .esg-sortbutton-order,\n.simple-light-205234 .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.simple-light-205234 .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.simple-light-205234 .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.simple-light-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.simple-light-205234 .esg-sortbutton,\n.simple-light-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.simple-light-205234 input.eg-search-input.hovered,\n.simple-light-205234 input.eg-search-input:focus,\n.simple-light-205234 .esg-navigationbutton.hovered,\n.simple-light-205234 .esg-filterbutton.hovered,\n.simple-light-205234 .esg-sortbutton.hovered,\n.simple-light-205234 .esg-sortbutton-order.hovered,\n.simple-light-205234 .esg-cartbutton.hovered,\n.simple-light-205234 .esg-filterbutton.selected,\n.simple-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.simple-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.simple-light-205234 .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.simple-light-205234 .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.simple-light-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.simple-light-205234 .esg-filter-checked {\n	color: #c5c5c5;\n	background: #ddd;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 20px;\n	vertical-align: middle;\n}\n\n.simple-light-205234 .esg-filterbutton.selected .esg-filter-checked,\n.simple-light-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.simple-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius:0px;\n}\n\n.simple-light-205234 .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n}\n\n.simple-light-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n}\n\n.simple-light-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.simple-light-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.simple-light-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}', NULL),
(21, 'Simple Dark-205234', 'simple-dark-205234', '/*************************************\n	-	SIMPLE DARK 3.0.0 SKIN   -\n*************************************/\n\n.simple-dark-205234 .navigationbuttons,\n.simple-dark-205234 .esg-pagination,\n.simple-dark-205234 .esg-filters {\n	text-align: center;\n}\n\n.simple-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.simple-dark-205234 input.eg-search-input,\n.simple-dark-205234 .esg-filterbutton,\n.simple-dark-205234 .esg-navigationbutton,\n.simple-dark-205234 .esg-sortbutton,\n.simple-dark-205234 .esg-cartbutton,\n.simple-dark-205234 .esg-sortbutton-order,\n.simple-dark-205234 .esg-cartbutton-order,\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 10px;\n	border:1px solid rgba(255,255,255,0.15);\n	line-height: 29px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\",sans-serif;\n 	display: inline-block;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 29px;\n	background: rgba(255,255,255,0.08 );\n	vertical-align: middle;\n}\n\n.simple-dark-205234 .esg-cartbutton a {\n	color:#fff;\n}\n\n.simple-dark-205234 input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n\n\n.simple-dark-205234 .esg-navigationbutton * {\n	color: #fff;\n}\n\n.simple-dark-205234 .esg-left,\n.simple-dark-205234 .esg-right {\n	color: #fff;\n	padding: 0px 7px;\n}\n\n.simple-dark-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.simple-dark-205234 .esg-sortbutton-wrapper,\n.simple-dark-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.simple-dark-205234 .esg-sortbutton-order,\n.simple-dark-205234 .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.simple-dark-205234 .esg-cartbutton {\n	color: #000;\n	cursor: default !important;\n}\n\n.simple-dark-205234 .esg-cartbutton .esgicon-basket {\n	color: #000;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.simple-dark-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.simple-dark-205234 .esg-sortbutton,\n.simple-dark-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.simple-dark-205234 input.eg-search-input.hovered,\n.simple-dark-205234 input.eg-search-input:focus,\n.simple-dark-205234 .esg-navigationbutton.hovered,\n.simple-dark-205234 .esg-filterbutton.hovered,\n.simple-dark-205234 .esg-sortbutton.hovered,\n.simple-dark-205234 .esg-sortbutton-order.hovered,\n.simple-dark-205234 .esg-cartbutton.hovered,\n.simple-dark-205234 .esg-filterbutton.selected,\n.simple-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.simple-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #fff;\n	color: #000;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.simple-dark-205234 .esg-cartbutton.hovered a,\n.simple-dark-205234 input.eg-search-input.hovered::placeholder {\n	color:#000;\n}\n\n.simple-dark-205234 .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.simple-dark-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	color: #000;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.simple-dark-205234 .esg-filter-checked {\n	color: transparent;\n	background: rgba(255,255,255,0.15);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	vertical-align: top;\n}\n\n.simple-dark-205234 .esg-filterbutton.selected .esg-filter-checked,\n.simple-dark-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n\n\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 29px;\n	white-space: nowrap;\n}\n\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.simple-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n    border-radius:0px;\n}\n\n.simple-dark-205234 .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n	border:1px solid rgba(255,255,255,0.15);\n}\n\n.simple-dark-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color:#777;\n}\n\n.simple-dark-205234 .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n	border: 1px solid rgba(0,0,0,0.2);\n}\n\n.simple-dark-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.simple-dark-205234 .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#000;\n}\n\n.simple-dark-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#fff;\n}\n.simple-dark-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.simple-dark-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#000;\n}', NULL),
(22, 'Text Dark-205234', 'text-dark-205234', '/*************************************\n	-	TEXT DARK 3.0.0 SKIN   -\n*************************************/\n\n.text-dark-205234 .navigationbuttons,\n.text-dark-205234 .esg-pagination,\n.text-dark-205234 .esg-filters {\n	text-align: center;\n}\n\n.text-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.text-dark-205234 input.eg-search-input,\n.text-dark-205234 .esg-filterbutton,\n.text-dark-205234 .esg-navigationbutton,\n.text-dark-205234 .esg-sortbutton,\n.text-dark-205234 .esg-cartbutton,\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	color: rgba(255, 255, 255, 0.4);\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px 0px 10px;\n	line-height: 20px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 20px;\n	vertical-align: top;\n}\n\n.text-dark-205234 .esg-cartbutton a {\n	color: #fff;\n}\n\n.text-dark-205234 input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color: rgba(255, 255, 255, 0.4);\n}\n\n.text-dark-205234 .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 0.4);\n}\n\n.text-dark-205234 .esg-sortbutton-wrapper,\n.text-dark-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.text-dark-205234 .esg-sortbutton-order,\n.text-dark-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 29px;\n	line-height: 20px;\n	font-size: 9px;\n	font-weight: 700;\n	color: #fff;\n	color: rgba(255, 255, 255, 0.4);\n	cursor: pointer;\n	background: transparent;\n}\n\n.text-dark-205234 .esg-cartbutton {\n	color: rgba(255, 255, 255, 0.4);\n	cursor: default !important;\n}\n\n.text-dark-205234 .esg-cartbutton .esgicon-basket {\n	color: rgba(255, 255, 255, 0.4);\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.text-dark-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.text-dark-205234 .esg-sortbutton,\n.text-dark-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n}\n\n.text-dark-205234 input.eg-search-input.hovered,\n.text-dark-205234 input.eg-search-input:focus,\n.text-dark-205234 .esg-navigationbutton.hovered,\n.text-dark-205234 .esg-filterbutton.hovered,\n.text-dark-205234 .esg-sortbutton.hovered,\n.text-dark-205234 .esg-filterbutton.selected,\n.text-dark-205234 .esg-sortbutton-order.hovered,\n.text-dark-205234 .esg-cartbutton-order.hovered,\n.text-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.text-dark-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #fff;\n}\n\n.text-dark-205234 .esg-navigationbutton.hovered,\n.text-dark-205234 .esg-filterbutton:hover span:first-child,\n.text-dark-205234 .esg-filterbutton.selected span:first-child {\n	text-decoration: none;\n}\n\n.text-dark-205234 .esg-filterbutton {\n	border-right: 1px solid #fff;\n	border-right: 1px solid rgba(255, 255, 255, 0.15);\n}\n\n.text-dark-205234 .esg-filterbutton:last-child {\n	border-right: none;\n}\n\n.text-dark-205234 .esg-sortbutton-order {\n	padding-left: 10px;\n	border-left: 1px solid #fff;\n	border-left: 1px solid rgba(255, 255, 255, 0.15);\n}\n\n.text-dark-205234 .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.text-dark-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.15);\n	color: #fff;\n}\n\n.text-dark-205234 .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n\n.text-dark-205234 .esg-filterbutton.selected .esg-filter-checked,\n.text-dark-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n}\n\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 20px;\n	white-space: nowrap;\n}\n\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:20px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.text-dark-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border:none !important;\n	line-height: 20px;\n	height: 20px;\n}\n\n.text-dark-205234 .esg-dropdown-wrapper {\n	left: 0px;\n	background:rgba(0, 0, 0, 0.85);\n}\n\n.text-dark-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color: rgba(255, 255, 255, 0.4);\n}\n\n\n.text-dark-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.text-dark-205234 .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #fff;\n}\n\n.text-dark-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color: rgba(255, 255, 255, 0.4);\n}\n.text-dark-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.text-dark-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#fff;\n}', NULL),
(23, 'Text Light-205234', 'text-light-205234', '/*************************************\n	-	TEXT LIGHT 3.0.0 SKIN   -\n*************************************/\n\n.text-light-205234 .navigationbuttons,\n.text-light-205234 .esg-pagination,\n.text-light-205234 .esg-filters {\n	text-align: center;\n}\n\n.text-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.text-light-205234 input.eg-search-input,\n.text-light-205234 .esg-filterbutton,\n.text-light-205234 .esg-navigationbutton,\n.text-light-205234 .esg-sortbutton,\n.text-light-205234 .esg-cartbutton,\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px 0px 10px;\n	line-height: 20px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 20px;\n	vertical-align: top;\n}\n\n.text-light-205234 .esg-cartbutton a {\n	color: #999;\n}\n\n.text-light-205234 input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color: #999;\n}\n\n.text-light-205234 .esg-navigationbutton * {\n	color: #999;\n}\n\n.text-light-205234 .esg-sortbutton-wrapper,\n.text-light-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.text-light-205234 .esg-sortbutton-order,\n.text-light-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 29px;\n	line-height: 20px;\n	font-size: 9px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: transparent;\n}\n\n.text-light-205234 .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.text-light-205234 .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.text-light-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.text-light-205234 .esg-sortbutton,\n.text-light-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n}\n\n.text-light-205234 input.eg-search-input.hovered,\n.text-light-205234 input.eg-search-input:focus,\n.text-light-205234 .esg-navigationbutton.hovered,\n.text-light-205234 .esg-filterbutton.hovered,\n.text-light-205234 .esg-sortbutton.hovered,\n.text-light-205234 .esg-filterbutton.selected,\n.text-light-205234 .esg-sortbutton-order.hovered,\n.text-light-205234 .esg-cartbutton-order.hovered,\n.text-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.text-light-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #444;\n}\n\n.text-light-205234 .esg-cartbutton.hovered a,\n.text-light-205234 input.eg-search-input.hovered::placeholder {\n	color: #999;\n}\n\n.text-light-205234 .esg-navigationbutton.hovered,\n.text-light-205234 .esg-filterbutton:hover span:first-child,\n.text-light-205234 .esg-filterbutton.selected span:first-child {\n	text-decoration: none;\n}\n\n.text-light-205234 .esg-filterbutton {\n	border-right: 1px solid rgba(0, 0, 0, 0.15);\n}\n\n.text-light-205234 .esg-filterbutton:last-child {\n	border-right: none;\n}\n\n.text-light-205234 .esg-sortbutton-order {\n	padding-left: 10px;\n	border-left: 1px solid rgba(0, 0, 0, 0.15);\n}\n\n.text-light-205234 .esg-navigationbutton.hovered * {\n	color: #444;\n}\n\n.text-light-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: rgba(0, 0, 0, 0.15);\n	color: #444;\n}\n\n.text-light-205234 .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n\n.text-light-205234 .esg-filterbutton.selected .esg-filter-checked,\n.text-light-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #444;\n}\n\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 20px;\n	white-space: nowrap;\n}\n\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:20px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.text-light-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border:none !important;\n	line-height: 20px;\n	height: 20px;\n}\n\n.text-light-205234 .esg-dropdown-wrapper {\n	left: 0px;\n	background:rgba(255, 255, 255, 0.85);\n}\n\n.text-light-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color: #999;\n}\n\n\n.text-light-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.text-light-205234 .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #444;\n}\n\n.text-light-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color: #999;\n}\n.text-light-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.text-light-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#444;\n}', NULL);
INSERT INTO `wp_eg_navigation_skins` (`id`, `name`, `handle`, `css`, `navversion`) VALUES
(24, 'Pat LaFontaine-205234', 'pat-lafontaine-205234', '/*************************************\n	-	Pat LaFontaine 3.0.0 SKIN -\n*************************************/\n.pat-lafontaine-205234 .esg-overflowtrick {\n  margin: 20px 0\n}\n\n.pat-lafontaine-205234 .navigationbuttons,\n.pat-lafontaine-205234 .esg-pagination,\n.pat-lafontaine-205234 .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.pat-lafontaine-205234 .esg-filters {margin-bottom: 1px !important}\n\n.pat-lafontaine-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.pat-lafontaine-205234 input.eg-search-input,\n.pat-lafontaine-205234 .esg-filterbutton,\n.pat-lafontaine-205234 .esg-navigationbutton,\n.pat-lafontaine-205234 .esg-sortbutton,\n.pat-lafontaine-205234 .esg-cartbutton,\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 1px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 20px;\n	border: none;\n	line-height: 50px;\n	border-radius: 0;\n	font-size: 14px;\n	font-weight: 400;\n	font-family: \"Barlow Condensed\", sans-serif;\n	display: inline-block;\n	background: #eaedf1;\n	margin-bottom: 0 !important;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: middle;\n  	transition: all 0.3s ease;\n  	min-width: 50px;\n}\n\n.pat-lafontaine-205234 .esg-filter-wrapper {\n  margin: 0 !important\n    }\n\n.pat-lafontaine-205234 .esg-allfilter {\n  background: #f03e3f !important;\n  color: #fff !important\n}\n\n.pat-lafontaine-205234 .esg-allfilter.hovered {\n  background: #000 !important;\n  color: #fff !important\n}\n\n.pat-lafontaine-205234 span.eg-el-amount {\n  letter-spacing: 1px\n}\n\n.pat-lafontaine-205234 span.eg-el-amount:before {\n  content: \"[\";\n  opacity: 0.5\n}\n\n.pat-lafontaine-205234 span.eg-el-amount:after {\n  content: \"]\";\n  opacity: 0.5\n}\n\n.pat-lafontaine-205234 .esg-cartbutton a {\n	color: #000;\n}\n\n.pat-lafontaine-205234 input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#999;\n}\n\n.pat-lafontaine-205234 .esg-navigationbutton {\n	padding: 0px;\n	min-width: 50px;\n}\n\n.pat-lafontaine-205234 .esg-navigationbutton.esg-loadmore {\n  padding: 0 20px;\n  text-transform: uppercase;\n}\n\n.pat-lafontaine-205234 .esg-navigationbutton * {\n	color: #000;\n}\n\n.pat-lafontaine-205234 .esg-navigationbutton.hovered i {\n  	color: #fff;\n}\n\n.pat-lafontaine-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.pat-lafontaine-205234 .esg-sortbutton-wrapper,\n.pat-lafontaine-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n  	margin-right: 1px !important;\n  	margin-left: 0 !important;\n}\n\n.pat-lafontaine-205234 .esg-sortbutton-order,\n.pat-lafontaine-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: middle;\n	border: none;\n	width: 50px;\n	line-height: 50px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #eaedf1;\n	margin-left: 1px;\n  	border-radius: 0;\n}\n\n.pat-lafontaine-205234 .esg-sortbutton-order.eg-icon-down-open:before {\n  	content: \"arrow_downward\";\n 	font-family: \"Material Icons\";\n  	font-size: 18px;\n  	color: #000;\n  	vertical-align: middle;\n}\n\n.pat-lafontaine-205234 .esg-sortbutton-order.hovered.eg-icon-down-open:before {\n  color: #fff\n}\n\n.pat-lafontaine-205234 .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n 	border-radius: 0 !important;\n  	padding: 0 20px 0 16px\n}\n\n.pat-lafontaine-205234 .esg-cartbutton.hovered .eg-icon-basket,\n.pat-lafontaine-205234 .esg-cartbutton.hovered .ess-cart-content {\n  color: #fff\n}\n\n.pat-lafontaine-205234 .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.pat-lafontaine-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.pat-lafontaine-205234 .esg-sortbutton,\n.pat-lafontaine-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.pat-lafontaine-205234 input.eg-search-input.hovered,\n.pat-lafontaine-205234 input.eg-search-input:focus,\n.pat-lafontaine-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.pat-lafontaine-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.pat-lafontaine-205234 .esg-navigationbutton.hovered,\n.pat-lafontaine-205234 .esg-filterbutton.hovered,\n.pat-lafontaine-205234 .esg-sortbutton.hovered,\n.pat-lafontaine-205234 .esg-sortbutton-order.hovered,\n.pat-lafontaine-205234 .esg-cartbutton-order.hovered,\n.pat-lafontaine-205234 .esg-filterbutton.selected,\n.pat-lafontaine-205234 .esg-cartbutton.hovered,\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #fff;\n	background: #000;\n}\n\n.pat-lafontaine-205234 .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.pat-lafontaine-205234 .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.pat-lafontaine-205234 .esg-filter-checked {\n	color: #cbcbcb;\n	background: none;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 13px;\n	vertical-align: middle;\n  	display: inline-block;\n    transform: translateY(-1px);\n  	border: 1px solid #cbcbcb;\n}\n.pat-lafontaine-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.pat-lafontaine-205234 .esg-filterbutton.selected .esg-filter-checked {\n  background: #fff;\n  color: #000;\n  border: 1px solid #fff;\n}\n\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.pat-lafontaine-205234 .esg-sortbutton {\n  	border-radius: 0;\n  	padding-right: 40px\n}\n\n.pat-lafontaine-205234 .esg-sortbutton:after,\n.pat-lafontaine-205234 .esg-selected-filterbutton .eg-icon-down-open:before{\n  	content: \"\";\n  	position: absolute;\n  	width: 5px;\n  	height: 5px;\n  	border-left: 1px solid #000;\n  	border-bottom: 1px solid #000;\n  	transform: rotate(-45deg) translateY(-6px);\n  	right: 15px;\n  	top: 50%\n}\n\n.pat-lafontaine-205234 .esg-sortbutton.hovered:after {\n  	border-left: 1px solid #fff;\n  	border-bottom: 1px solid #fff;\n}\n\n.pat-lafontaine-205234 .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.pat-lafontaine-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n  	width: 100%;\n}\n\n.pat-lafontaine-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n\n.pat-lafontaine-205234 .dropdownstyle .esg-filterbutton .esg-filter-checked {\n  margin-left: 0;\n  transform: translateY(-2px);\n}\n\n.pat-lafontaine-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.pat-lafontaine-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.pat-lafontaine-205234 .eg-search-wrapper {background: #3d3b3e}\n.pat-lafontaine-205234 .eg-search-wrapper .eg-search-input {\n  background: #3d3b3e;\n  font-style: italic;\n  border-bottom: 1px solid #868689;\n  line-height: 22px;\n  min-height: 22px;\n  padding: 0;\n  margin: 0 0 0 20px !important;\n}\n\n.pat-lafontaine-205234 .eg-search-wrapper .eg-search-input.hovered,\n.pat-lafontaine-205234 .eg-search-wrapper .eg-search-input:focus,\n.pat-lafontaine-205234 .eg-search-wrapper .eg-search-input:active,\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  background-color: #3d3b3e !important;\n  color: #fff !important;\n}\n\n.pat-lafontaine-205234 .eg-search-wrapper .eg-search-input.hovered,\n.pat-lafontaine-205234 .eg-search-wrapper input:-webkit-autofill,\n.pat-lafontaine-205234 .eg-search-wrapper input:-webkit-autofill:hover,\n.pat-lafontaine-205234 .eg-search-wrapper input:-webkit-autofill:focus {\n  border-bottom: 1px solid #fff;\n  -webkit-text-fill-color: #fff;\n  -webkit-box-shadow: 0 0 0px 1000px #3d3b3e inset;\n}\n\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  margin-left: 0;\n  width: 46px;\n}\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered {\n  background: #000;\n}\n\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  margin-left: 0;\n  width: 46px;\n  background: #000;\n  color: #fff\n}\n\n.pat-lafontaine-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered {\n  background: #f03e3f;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Barlow+Condensed:ital,wght@0,400;0,500;0,600;1,400&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL),
(25, 'Grant Fuhr-205234', 'grant-fuhr-205234', '/*************************************\n	-	Grant Fuhr 3.0.0 SKIN -\n*************************************/\n.grant-fuhr-205234 .esg-filters {\n  margin-bottom: 20px !important;\n}\n\n.grant-fuhr-205234 .navigationbuttons,\n.grant-fuhr-205234 .esg-pagination,\n.grant-fuhr-205234 .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.grant-fuhr-205234 input.eg-search-input,\n.grant-fuhr-205234 .esg-filterbutton,\n.grant-fuhr-205234 .esg-navigationbutton,\n.grant-fuhr-205234 .esg-sortbutton,\n.grant-fuhr-205234 .esg-cartbutton,\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 13px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 15px;\n	border: none;\n	line-height: 50px;\n	font-size: 12px;\n	font-weight: 400;\n	font-family: \"Open Sans\", sans-serif;\n  	font-style: italic;\n  	letter-spacing: 1px;\n	display: inline-block;\n	background: #2e2e34;\n	margin-bottom: 1px;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: top;\n  	border-radius: 0px !important;\n  	min-width: 42px;\n  	text-transform: none;\n}\n.grant-fuhr-205234 .esg-cartbutton-wrapper {\n  margin: 0 11px !important;\n}\n\n.grant-fuhr-205234 .esg-filterbutton.esg-allfilter {\n  	text-decoration: underline;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-wrapper {\n  position: relative;\n  margin: 0 2px 0 8px !important;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-wrapper .esg-sortbutton {\n  padding-right: 35px;\n}\n\n.grant-fuhr-205234 .esg-filterbutton:before,\n.grant-fuhr-205234 .eg-search-wrapper:before,\n.grant-fuhr-205234 .esg-cartbutton:before,\n.grant-fuhr-205234 .esg-sortbutton-wrapper .esg-sortbutton:before,\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle:before {\n  	width: 0;\n	height: 0;\n	border-style: solid;\n	border-width: 0 0 50px 12px;\n	border-color: transparent transparent #2e2e34 transparent;\n  	position: absolute;\n  	content:\"\";\n  	top: 0;\n  	left: -12px\n}\n\n.grant-fuhr-205234 .esg-sortbutton-wrapper .esg-sortbutton.hovered:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr-205234 .esg-filterbutton:after,\n.grant-fuhr-205234 .eg-search-wrapper .eg-search-clean:after,\n.grant-fuhr-205234 .esg-cartbutton:after,\n.grant-fuhr-205234 .esg-sortbutton-order:after,\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle:after {\n  	width: 0;\n	height: 0;\n	border-style: solid;\n	border-width: 50px 12px 0 0;\n	border-color: #2e2e34 transparent transparent transparent;\n  	position: absolute;\n  	content:\"\";\n  	top: 0;\n  	right: -12px\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle:after {\n  right: 1px\n}\n\n.grant-fuhr-205234 .esg-filterbutton.hovered:before,\n.grant-fuhr-205234 .esg-filterbutton.selected:before,\n.grant-fuhr-205234 .esg-cartbutton.hovered:before,\n.grant-fuhr-205234 .esg-sortbutton-wrapper.hovered:before,\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle:hover:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr-205234 .esg-filterbutton.hovered:after,\n.grant-fuhr-205234 .esg-filterbutton.selected:after,\n.grant-fuhr-205234 .esg-cartbutton.hovered:after,\n.grant-fuhr-205234 .esg-sortbutton-wrapper.hovered:after,\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle:hover:after {\n  border-color: #fff157 transparent transparent transparent;\n}\n\n.esg-sortbutton-order.tp-desc {\n  transform: none;\n}\n\n.esg-sortbutton-order.tp-desc:before {\n  transform: scaleY(-1);\n}\n\n.grant-fuhr-205234 .esg-filterbutton .eg-el-amount {\n  position: absolute;\n  line-height: 27px;\n  min-width: 27px;\n  border-radius: 50%;\n  background: #fff157;\n  color: #000;\n  top: -13px;\n  right: -5px;\n  text-align: center;\n  z-index: 2;\n  font-style: normal;\n  font-weight: 600;\n\n}\n\n.grant-fuhr-205234 .esg-filterbutton .eg-el-amount:before,\n.grant-fuhr-205234 .esg-filterbutton .eg-el-amount:after {\n  display: none\n}\n\n.grant-fuhr-205234 .esg-filterbutton.selected .eg-el-amount {\n  background: #2e2e34;\n  color: #fff;\n}\n\n.grant-fuhr-205234 .esg-cartbutton a {\n	color: #fff;\n}\n\n.grant-fuhr-205234 .esg-cartbutton.hovered a {\n  color: #000;\n}\n\n.grant-fuhr-205234 .eg-search-wrapper {\n  position: relative\n}\n\n.grant-fuhr-205234 .eg-search-wrapper:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr-205234 input.eg-search-input {\n  background: #fff157;\n  outline-style: none;\n  margin-bottom: 0 !important;\n}\n\n.grant-fuhr-205234 input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.grant-fuhr-205234 input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  margin-left: 0 !important;\n  min-width: 50px;\n  background: #fff157;\n  color: #000;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered {\n  background: #2e2e34 !important;\n  color: #fff157 !important;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  margin-left: 0 !important;\n  min-width: 50px;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered:after {\n	border-color: #fff157 transparent transparent transparent;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-order.eg-icon-down-open:before {\n  	content: \"arrow_downward\";\n 	font-family: \"Material Icons\";\n  	font-size: 18px;\n  	color: #000;\n  	vertical-align: middle;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-order.hovered.eg-icon-down-open:before {\n  color: #fff\n}\n\n.grant-fuhr-205234 .esg-navigationbutton {\n	padding: 0px;\n	width:40px;\n}\n\n.grant-fuhr-205234 .esg-navigationbutton.esg-loadmore {\n  	width: auto;\n  	padding: 0 20px\n}\n\n.grant-fuhr-205234 .esg-navigationbutton * {\n	color: #999;\n}\n\n.grant-fuhr-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.grant-fuhr-205234 .esg-navigationbutton.selected,\n.grant-fuhr-205234 .esg-navigationbutton.hovered {\n  color: #000 !important;\n}\n\n.grant-fuhr-205234 .esg-navigationbutton.esg-right,\n.grant-fuhr-205234 .esg-navigationbutton.esg-left {\n  width: 50px;\n}\n\n.grant-fuhr-205234 .esg-navigationbutton.esg-right i,\n.grant-fuhr-205234 .esg-navigationbutton.esg-left i {\n  color: #fff;\n}\n\n.grant-fuhr-205234 .esg-navigationbutton.esg-right.hovered i,\n.grant-fuhr-205234 .esg-navigationbutton.esg-left.hovered i {\n  color: #000;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-wrapper,\n.grant-fuhr-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-order,\n.grant-fuhr-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: none;\n	width: 50px;\n	line-height: 40px;\n	border-radius: 0;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #fff157;\n	margin-left: 0;\n  	line-height: 50px;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-order.hovered,\n.grant-fuhr-205234 .esg-cartbutton-order.hovered {\n  	color: #fff157 !important;\n  	background: #2e2e34 !important;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-order:after {\n	border-color: #fff157 transparent transparent transparent;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-order.hovered:after {\n  border-color: #2e2e34 transparent transparent transparent;\n}\n\n.grant-fuhr-205234 .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.grant-fuhr-205234 .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.grant-fuhr-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.grant-fuhr-205234 .esg-sortbutton,\n.grant-fuhr-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.grant-fuhr-205234 input.eg-search-input.hovered,\n.grant-fuhr-205234 input.eg-search-input:focus,\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.grant-fuhr-205234 .esg-navigationbutton.hovered,\n.grant-fuhr-205234 .esg-filterbutton.hovered,\n.grant-fuhr-205234 .esg-sortbutton.hovered,\n.grant-fuhr-205234 .esg-sortbutton-order.hovered,\n.grant-fuhr-205234 .esg-cartbutton-order.hovered,\n.grant-fuhr-205234 .esg-filterbutton.selected,\n.grant-fuhr-205234 .esg-cartbutton.hovered,\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #000;\n	background: #fff157;\n}\n\n.grant-fuhr-205234 .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.grant-fuhr-205234 .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.grant-fuhr-205234 .esg-allfilter.esg-allfilter {\n}\n\n.grant-fuhr-205234 .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.grant-fuhr-205234 .esg-filterbutton.selected .esg-filter-checked,\n.grant-fuhr-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.grant-fuhr-205234 .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.grant-fuhr-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative\n}\n\n.grant-fuhr-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n.grant-fuhr-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.grant-fuhr-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.grant-fuhr-205234 .esg-sortbutton:after,\n.grant-fuhr-205234 .esg-selected-filterbutton .eg-icon-down-open:before {\n  	content: \"\";\n  	position: absolute;\n  	width: 5px;\n  	height: 5px;\n  	border-left: 1px solid #fff157;\n  	border-bottom: 1px solid #fff157;\n  	transform: rotate(-45deg) translateY(-6px);\n  	right: 15px;\n  	top: 50%\n}\n\n.grant-fuhr-205234 .esg-sortbutton.hovered:after,\n.grant-fuhr-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open:before,\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle:hover .esg-selected-filterbutton .eg-icon-down-open:before {\n  	border-left: 1px solid #000;\n  	border-bottom: 1px solid #000;\n}\n\n.grant-fuhr-205234 .esg-dropdown-wrapper .esg-filterbutton {\n  width: 100%;\n  margin: 0;\n}\n\n.grant-fuhr-205234 .esg-dropdown-wrapper .esg-filterbutton:before,\n.grant-fuhr-205234 .esg-dropdown-wrapper .esg-filterbutton:after {\n  display: none;\n}\n\n.grant-fuhr-205234 .esg-filter-wrapper.dropdownstyle:hover .esg-selected-filterbutton {\n  background: #fff157;\n  color: #000;\n}\n\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL),
(26, 'Leon Draisaitl-205234', 'leon-draisaitl-205234', '/*************************************\n	-	LEON DRAISAITL 3.0.0 SKIN   -\n*************************************/\n.leon-draisaitl-205234 .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.leon-draisaitl-205234 .navigationbuttons,\n.leon-draisaitl-205234 .esg-pagination,\n.leon-draisaitl-205234 .esg-filters {\n	text-align: center;\n}\n\n.leon-draisaitl-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.leon-draisaitl-205234 input.eg-search-input,\n.leon-draisaitl-205234 .esg-filterbutton,\n.leon-draisaitl-205234 .esg-navigationbutton,\n.leon-draisaitl-205234 .esg-sortbutton,\n.leon-draisaitl-205234 .esg-cartbutton,\n.leon-draisaitl-205234 .esg-sortbutton-order,\n.leon-draisaitl-205234 .esg-cartbutton-order,\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	cursor: pointer;\n	padding: 0px 20px;\n	border: 2px solid #000;\n	line-height: 50px;\n	font-size: 16px;\n	font-weight: 500;\n	font-family: \"Roboto Mono\", monospace;\n 	display: inline-block;\n	background: transparent;\n	margin: -2px -2px 0 0 !important;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: middle;\n  	min-width: 54px;\n  	box-shadow: inset 0px 0px 0px 0px #000;\n  	transition: all 0.4s ease;\n}\n\n.leon-draisaitl-205234 .esg-sortbutton-wrapper,\n.leon-draisaitl-205234 .esg-filter-wrapper,\n.leon-draisaitl-205234 .esg-cartbutton-wrapper {\n  margin: 0 !important;\n}\n\n.leon-draisaitl-205234 .esg-cartbutton a {\n	color:#000;\n}\n\n.leon-draisaitl-205234 input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.leon-draisaitl-205234 input.eg-search-input.hovered::placeholder {\n  color: #fff;\n}\n\n.leon-draisaitl-205234 .esg-navigationbutton * {\n	color: #000;\n}\n\n.leon-draisaitl-205234 .esg-left,\n.leon-draisaitl-205234 .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.leon-draisaitl-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.leon-draisaitl-205234 .esg-sortbutton-wrapper,\n.leon-draisaitl-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.leon-draisaitl-205234 .esg-sortbutton-order,\n.leon-draisaitl-205234 .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.leon-draisaitl-205234 .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.leon-draisaitl-205234 .esg-cartbutton.hovered *,\n.leon-draisaitl-205234 .esg-navigationbutton.hovered * {\n  color: #fff !important;\n}\n\n.leon-draisaitl-205234 .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.leon-draisaitl-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.leon-draisaitl-205234 .esg-sortbutton,\n.leon-draisaitl-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.leon-draisaitl-205234 input.eg-search-input.hovered,\n.leon-draisaitl-205234 input.eg-search-input:focus,\n.leon-draisaitl-205234 .esg-navigationbutton.hovered,\n.leon-draisaitl-205234 .esg-filterbutton.hovered,\n.leon-draisaitl-205234 .esg-sortbutton.hovered,\n.leon-draisaitl-205234 .esg-sortbutton-order.hovered,\n.leon-draisaitl-205234 .esg-cartbutton.hovered,\n.leon-draisaitl-205234 .esg-filterbutton.selected,\n.leon-draisaitl-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.leon-draisaitl-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #000;\n	color: #fff;\n	box-shadow: inset 0px 0px 0px 50px #000;\n}\n\n.leon-draisaitl-205234 .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.leon-draisaitl-205234 .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.leon-draisaitl-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.leon-draisaitl-205234 .esg-filter-checked {\n	color: #aaa;\n  	border: 2px solid #000;\n	background: transparent;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 14px;\n	vertical-align: middle;\n  	text-align: center;\n  	min-width: 18px;\n  	display: inline-block;\n}\n\n.leon-draisaitl-205234 .esg-filterbutton.selected .esg-filter-checked,\n.leon-draisaitl-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n	background: #fff;\n}\n\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.leon-draisaitl-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius:0px;\n}\n\n.leon-draisaitl-205234 .esg-dropdown-wrapper {\n	left: 0px;\n	background: #fff;\n  	border: 2px solid #000;\n  	margin-top: -2px;\n  	padding: 0;\n}\n\n.leon-draisaitl-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding: 5px 20px;\n	border:none;\n	box-shadow: none;\n  	box-sizing: border-box;\n}\n\n.leon-draisaitl-205234 .esg-dropdown-wrapper .esg-filterbutton.esg-allfilter {\n  width: 100%;\n}\n\n.leon-draisaitl-205234 .esg-dropdown-wrapper .esg-filterbutton.selected,\n.leon-draisaitl-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered {\n  background: #000;\n}\n\n.leon-draisaitl-205234 .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n  margin: 0 10px 0 -2px;\n}\n\n.leon-draisaitl-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.leon-draisaitl-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.leon-draisaitl-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open {\n	color: #fff;\n}\n\n.leon-draisaitl-205234 .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Roboto+Mono:wght@400;500&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n', NULL),
(27, 'Uwe Krupp-205234', 'uwe-krupp-205234', '/*************************************\n	-	UWE KRUPP 3.0.0 SKIN   -\n*************************************/\n.uwe-krupp-205234 .esg-overflowtrick {\n  margin: 50px 0;\n}\n\n.uwe-krupp-205234 .navigationbuttons,\n.uwe-krupp-205234 .esg-pagination,\n.uwe-krupp-205234 .esg-filters {\n	text-align: center;\n}\n\n.uwe-krupp-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.uwe-krupp-205234 input.eg-search-input,\n.uwe-krupp-205234 .esg-filterbutton,\n.uwe-krupp-205234 .esg-navigationbutton,\n.uwe-krupp-205234 .esg-sortbutton,\n.uwe-krupp-205234 .esg-cartbutton,\n.uwe-krupp-205234 .esg-sortbutton-order,\n.uwe-krupp-205234 .esg-cartbutton-order,\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #6a666b;\n  	letter-spacing: 1px;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px;\n	line-height: 40px;\n	font-size: 13px;\n	font-weight: 400;\n	font-family: \"Arvo\", serif;\n 	display: inline-block;\n	background: rgba(255, 255, 255, 0.65);\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	min-width: 40px;\n  	border-radius: 12px;\n}\n\n.uwe-krupp-205234 .esg-cartbutton a {\n	color:#000;\n}\n\n.uwe-krupp-205234 input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color: #6a666b;\n}\n\n.uwe-krupp-205234 input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.uwe-krupp-205234 .esg-navigationbutton.esg-right,\n.uwe-krupp-205234 .esg-navigationbutton.esg-left {\n  background: #b0a5b4;\n}\n\n.uwe-krupp-205234 .esg-navigationbutton.esg-left {\n  border-radius: 0 12px 12px 0px;\n}\n\n.uwe-krupp-205234 .esg-navigationbutton.esg-right {\n  border-radius: 12px 0px 0px 12px;\n}\n\n.uwe-krupp-205234 .esg-navigationbutton * {\n	color: #000;\n}\n\n.uwe-krupp-205234 .esg-left,\n.uwe-krupp-205234 .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.uwe-krupp-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.uwe-krupp-205234 .esg-sortbutton-wrapper,\n.uwe-krupp-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.uwe-krupp-205234 .esg-sortbutton-order,\n.uwe-krupp-205234 .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.uwe-krupp-205234 .esg-cartbutton {\n	color: #757176;\n	cursor: default !important;\n}\n\n.uwe-krupp-205234 .esg-cartbutton .esgicon-basket {\n	color: #757176;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.uwe-krupp-205234 .esg-cartbutton .ess-cart-content {\n  color: #757176;\n}\n\n.uwe-krupp-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.uwe-krupp-205234 .esg-sortbutton,\n.uwe-krupp-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.uwe-krupp-205234 input.eg-search-input.hovered,\n.uwe-krupp-205234 input.eg-search-input:focus,\n.uwe-krupp-205234 .esg-navigationbutton.hovered,\n.uwe-krupp-205234 .esg-filterbutton.hovered,\n.uwe-krupp-205234 .esg-sortbutton.hovered,\n.uwe-krupp-205234 .esg-sortbutton-order.hovered,\n.uwe-krupp-205234 .esg-cartbutton.hovered,\n.uwe-krupp-205234 .esg-filterbutton.selected,\n.uwe-krupp-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.uwe-krupp-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	color: #333;\n}\n\n.uwe-krupp-205234 .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.uwe-krupp-205234 .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.uwe-krupp-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.uwe-krupp-205234 .esg-filter-checked {\n	color: #b0a5b4;\n	background: transparent;\n  	border: 1px solid #b0a5b4;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 12px;\n 	min-width: 12px;\n	vertical-align: middle;\n  	display: inline-block;\n  	transform: translateY(-1px);\n}\n\n.uwe-krupp-205234 .esg-filterbutton.selected .esg-filter-checked,\n.uwe-krupp-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n  	border: 1px solid #000;\n}\n\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius: 12px 0px 0px 12px;\n  	border: none;\n}\n\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  border-radius: 0px 12px 12px 0px;\n  margin-left: 0;\n}\n\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered,\n.uwe-krupp-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  background: #b0a5b4;\n  color: #fff;\n}\n\n.uwe-krupp-205234 .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n}\n\n.uwe-krupp-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n}\n\n.uwe-krupp-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.uwe-krupp-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.uwe-krupp-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}\n\n.uwe-krupp-205234 .esg-sortbutton-order.eg-icon-down-open {\n  background: #b0a5b4;\n  color: #fff;\n}\n\n.uwe-krupp-205234 .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL),
(28, 'Clark Gillies-205234', 'clark-gillies-205234', '/*************************************\n	-	CLARK GILLIES 3.0.0 SKIN   -\n*************************************/\n.clark-gillies-205234 .navigationbuttons,\n.clark-gillies-205234 .esg-pagination,\n.clark-gillies-205234 .esg-filters {\n	text-align: center;\n}\n\n.clark-gillies-205234 .esg-filters {\n  margin-bottom: 20px !important;\n}\n\n.clark-gillies-205234 .esg-filter-wrapper {\n  margin: 0 !important;\n}\n\n.clark-gillies-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.clark-gillies-205234 input.eg-search-input,\n.clark-gillies-205234 .esg-filterbutton,\n.clark-gillies-205234 .esg-navigationbutton,\n.clark-gillies-205234 .esg-sortbutton,\n.clark-gillies-205234 .esg-cartbutton,\n.clark-gillies-205234 .esg-sortbutton-order,\n.clark-gillies-205234 .esg-cartbutton-order,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin: 0 10px 0 0 !important;\n	cursor: pointer;\n	padding: 0px 10px;\n  	border: none;\n	line-height: 28px;\n	font-size: 13px;\n	font-weight: 400;\n	font-family: \"Arvo\", serif;\n 	display: inline-block;\n	background: transparent;\n	white-space: nowrap;\n	min-height: 28px;\n	vertical-align: middle;\n  	letter-spacing: -0.5px;\n  	min-width: 24px;\n  	position: relative;\n  	transition: all 0.3s ease;\n}\n\n.clark-gillies-205234 .esg-filterbutton:before,\n.clark-gillies-205234 .esg-selected-filterbutton:before,\n.clark-gillies-205234 .esg-sortbutton:before {\n  content: \"\";\n  position: absolute;\n  z-index: -1;\n  height: 2px;\n  width: calc(100% - 20px);\n  left: 10px;\n  bottom: 0;\n  background: #000;\n  transition: all 0.3s ease;\n}\n\n.clark-gillies-205234 .esg-filterbutton.hovered:before,\n.clark-gillies-205234 .esg-filterbutton.selected:before,\n.clark-gillies-205234 .esg-filter-wrapper:hover .esg-selected-filterbutton:before,\n.clark-gillies-205234 .esg-sortbutton.hovered:before{\n  width: 100%;\n  height: 100%;\n  left: 0;\n}\n\n.clark-gillies-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open {\n  color: #fff !important;\n}\n\n.clark-gillies-205234 .esg-cartbutton a {\n	color:#fff;\n}\n\n.clark-gillies-205234 input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.clark-gillies-205234 input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.clark-gillies-205234 .esg-navigationbutton {\n  min-width: 28px;\n}\n\n.clark-gillies-205234 .esg-navigationbutton * {\n	color: #fff;\n}\n\n.clark-gillies-205234 .esg-left,\n.clark-gillies-205234 .esg-right,\n.clark-gillies-205234 .esg-loadmore {\n	color: #fff;\n	padding: 2px 7px;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 20px #000;\n}\n.clark-gillies-205234 .esg-left.hovered,\n.clark-gillies-205234 .esg-right.hovered,\n.clark-gillies-205234 .esg-loadmore.hovered {\n  color: #000 !important;\n  box-shadow: inset 0 0 0 2px #000;\n}\n\n.clark-gillies-205234 .esg-loadmore {\n  padding: 0 10px;\n}\n\n.clark-gillies-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.clark-gillies-205234 .esg-sortbutton-wrapper,\n.clark-gillies-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.clark-gillies-205234 .esg-sortbutton-order,\n.clark-gillies-205234 .esg-cartbutton-order,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n	padding: 0px;\n	min-width: 30px;\n	font-size: 9px;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 2px #000;\n  	margin-right: 20px !important;\n}\n\n.clark-gillies-205234 .esg-sortbutton-order.hovered,\n.clark-gillies-205234 .esg-cartbutton-order.hovered,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered {\n  	box-shadow: inset 0 0 0 20px #000\n}\n\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  font-size: 12px;\n  line-height: 28px !important;\n}\n\n.clark-gillies-205234 .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n.clark-gillies-205234 .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 20px #000;\n}\n\n.clark-gillies-205234 .esg-cartbutton.hovered {\n  	box-shadow: inset 0 0 0 2px #000;\n}\n\n.clark-gillies-205234 .esg-cartbutton .ess-cart-content {\n  	color: #fff;\n}\n\n.clark-gillies-205234 .esg-cartbutton.hovered .ess-cart-content {\n  	color: #000;\n}\n\n.clark-gillies-205234 .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.clark-gillies-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.clark-gillies-205234 .esg-sortbutton,\n.clark-gillies-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0 !important;\n}\n\n.clark-gillies-205234 input.eg-search-input.hovered,\n.clark-gillies-205234 input.eg-search-input:focus,\n.clark-gillies-205234 .esg-navigationbutton.hovered,\n.clark-gillies-205234 .esg-filterbutton.hovered,\n.clark-gillies-205234 .esg-sortbutton.hovered,\n.clark-gillies-205234 .esg-sortbutton-order.hovered,\n.clark-gillies-205234 .esg-cartbutton.hovered,\n.clark-gillies-205234 .esg-filterbutton.selected,\n.clark-gillies-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.clark-gillies-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #fff;\n}\n\n.clark-gillies-205234 .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.clark-gillies-205234 .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.clark-gillies-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.clark-gillies-205234 .esg-filter-checked {\n	color: #000;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 20px;\n	vertical-align: middle;\n  	border: 1px solid #000;\n  	background: transparent;\n  	padding: 1px 0;\n}\n\n.clark-gillies-205234 .esg-filterbutton.selected .esg-filter-checked,\n.clark-gillies-205234 .esg-filterbutton.hovered .esg-filter-checked,\n.clark-gillies-205234 .esg-dropdown-wrapper .esg-filter-checked {\n	color: #000;\n	background: #fff;\n}\n\n.clark-gillies-205234 .esg-dropdown-wrapper .esg-filter-checked {\n  margin-left: 0;\n}\n\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 22px;\n	white-space: nowrap;\n}\n\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 0;\n  	border-bottom: 2px solid #000;\n}\n\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width: 29px;\n	padding: 0px;\n	margin-left: 0px;\n	margin-right: 0px;\n  	min-height: 26px;\n  	line-height: 26px;\n}\n\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width: auto;\n	border-radius: 0px;\n  	border-bottom: 2px solid #000;\n  	margin: 0 !important;\n  	padding: 2px 0;\n  	min-height: 22px;\n  	line-height: 22px;\n  	font-size: 13px;\n}\n\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input:focus,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input:active,\n.clark-gillies-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input.hovered {\n  color: #000;\n}\n\n.clark-gillies-205234 .esg-dropdown-wrapper {\n	left: 0px;\n	background: #000;\n 	width: 100%;\n}\n\n.clark-gillies-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background: transparent;\n	padding: 0px;\n	border: none;\n	box-shadow: none;\n  	color: #fff;\n}\n\n.clark-gillies-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered {\n  opacity: 0.6;\n}\n\n.clark-gillies-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.clark-gillies-205234 .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.clark-gillies-205234 .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}\n\n.clark-gillies-205234 .esg-filterbutton .eg-el-amount:before,\n.clark-gillies-205234 .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL);
INSERT INTO `wp_eg_navigation_skins` (`id`, `name`, `handle`, `css`, `navversion`) VALUES
(29, 'Rod Langway-205234', 'rod-langway-205234', '/*************************************\n	-	ROD LANGWAY 3.0.0 SKIN	-\n*************************************/\n.rod-langway-205234 .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.rod-langway-205234 .navigationbuttons,\n.rod-langway-205234 .esg-pagination,\n.rod-langway-205234 .esg-filters {\n	text-align: center;\n}\n\n.rod-langway-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.rod-langway-205234 input.eg-search-input,\n.rod-langway-205234 .esg-filterbutton,\n.rod-langway-205234 .esg-navigationbutton,\n.rod-langway-205234 .esg-sortbutton,\n.rod-langway-205234 .esg-cartbutton,\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 0;\n	cursor: pointer;\n	padding: 4px 17px 0;\n	border: none;\n  	box-sizing: border-box;\n	line-height: 35px;\n	font-size: 10px;\n  	text-transform: uppercase;\n  	letter-spacing: 3px;\n	font-weight: 700;\n	font-family: \"Josefin Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	border-radius: 0;\n}\n.rod-langway-205234  .esg-filterbutton .eg-el-amount {\n  background: #ced3d7;\n  display: inline-block;\n  line-height: 24px;\n  min-width: 26px;\n  padding-top: 2px;\n  text-align: center;\n  font-weight: 500;\n  font-size: 12px;\n  letter-spacing: 0;\n}\n\n.rod-langway-205234  .esg-filterbutton.hovered .eg-el-amount,\n.rod-langway-205234  .esg-filterbutton.selected .eg-el-amount {\n  background: #2f2f3a;\n  color: #fff;\n}\n\n.rod-langway-205234 .esg-filterbutton .eg-el-amount:before,\n.rod-langway-205234 .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n  margin-left: 0 !important;\n  font-size: 14px;\n  letter-spacing: 0;\n  line-height: 40px;\n}\n\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway-205234 .esg-cartbutton {\n  background: #ced3d7;\n}\n\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.rod-langway-205234 .esg-cartbutton.hovered {\n  background: #b0b5b9 !important;\n}\n\n.rod-langway-205234 .esg-cartbutton a {\n	color: #000;\n}\n\n.rod-langway-205234 .esg-cartbutton a:hover {\n	color: #000;\n}\n\n.rod-langway-205234 input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color: #b0b5b9;\n}\n\n.rod-langway-205234 input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.rod-langway-205234 .esg-navigationbutton {\n  line-height: 40px;\n  min-width: 40px;\n  letter-spacing: 0;\n  font-size: 14px;\n  font-weight: 400;\n}\n\n.rod-langway-205234 .esg-navigationbutton.esg-left {\n  transform: translateX(-40px)\n}\n\n.rod-langway-205234 .esg-navigationbutton.esg-right {\n  transform: translateX(40px)\n}\n\n.rod-langway-205234 .esg-navigationbutton * {\n	color: #000;\n\n}\n\n.rod-langway-205234 .esg-navigationbutton.hovered i {\n	color: #000;\n}\n\n.rod-langway-205234 .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.rod-langway-205234 .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.rod-langway-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.rod-langway-205234 .esg-sortbutton-wrapper,\n.rod-langway-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.rod-langway-205234 .esg-sortbutton-order,\n.rod-langway-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 40px;\n	line-height: 40px;\n	border-radius: 0;\n  	border: none;\n	font-size: 12px;\n	font-weight: 600;\n	color: #000;\n	cursor: pointer;\n  	background: #ced3d7;\n}\n\n.rod-langway-205234 .esg-sortbutton-order.hovered,\n.rod-langway-205234 .esg-cartbutton-order.hovered {\n  background: #b0b5b9 !important;\n}\n\n.rod-langway-205234 .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.rod-langway-205234 .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.rod-langway-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.rod-langway-205234 .esg-sortbutton,\n.rod-langway-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n}\n\n.rod-langway-205234 .esg-sortbutton{\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 0;\n}\n\n.rod-langway-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.rod-langway-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.rod-langway-205234 .esg-navigationbutton.hovered,\n.rod-langway-205234 .esg-filterbutton.hovered,\n.rod-langway-205234 .esg-sortbutton.hovered,\n.rod-langway-205234 .esg-sortbutton-order.hovered,\n.rod-langway-205234 .esg-cartbutton-order.hovered,\n.rod-langway-205234 .esg-filterbutton.selected,\n.rod-langway-205234 .esg-cartbutton.hovered,\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	box-shadow: none;\n	background: #ced3d7;\n}\n\n.rod-langway-205234 .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.rod-langway-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.rod-langway-205234 .esg-filter-checked {\n	color: #ced3d7;\n  	border: 1px solid #333;\n  	letter-spacing: 0;\n	background: transparent;\n	font-size: 9px;\n	font-weight: 300;\n	vertical-align: middle;\n  	line-height: 14px;\n	margin-left: 7px;\n  	display: inline-block;\n  	width: 14px;\n  	height: 14px;\n  	transform: translateY(-2px);\n}\n\n.rod-langway-205234 .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left: 0;\n	margin-right: 10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.rod-langway-205234 .esg-filterbutton.selected .esg-filter-checked,\n.rod-langway-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n  	border: 1px solid #000;\n}\n\n/* */\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.rod-langway-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.rod-langway-205234 .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background: #000;\n	border-radius: 0;\n  	padding: 0;\n}\n\n.rod-langway-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border: none;\n	box-shadow: none;\n	text-align: left;\n	color: #fff;\n	background: transparent;\n	line-height: 25px;\n	min-height: 25px;\n  	padding: 10px 20px;\n  	display: inline-block;\n  	width: 100%;\n  	box-sizing: border-box;\n  	margin: 0;\n}\n\n.rod-langway-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.rod-langway-205234 .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #000;\n  	background: #fff;\n}\n\n\n.rod-langway-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color: #000;\n	font-size: 11px;\n}\n\n.rod-langway-205234 .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n@import url(\"https://fonts.googleapis.com/css2?family=Josefin+Sans:wght@400;500;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL),
(30, 'Ray Bourge-205234', 'ray-bourque-205234', '/**************************************\n	-	RAY BOURGE V3.0.0 SKIN    -\n**************************************/\n\n\n\n.ray-bourque-205234 .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.ray-bourque-205234 .navigationbuttons,\n.ray-bourque-205234 .esg-pagination,\n.ray-bourque-205234 .esg-filters {\n	text-align: center;\n}\n\n.ray-bourque-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.ray-bourque-205234 input.eg-search-input,\n.ray-bourque-205234 .esg-filterbutton,\n.ray-bourque-205234 .esg-navigationbutton,\n.ray-bourque-205234 .esg-sortbutton,\n.ray-bourque-205234 .esg-cartbutton,\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: rgba(255, 255, 255, 1);\n	margin-right: 0;\n	cursor: pointer;\n	padding: 0px 17px;\n	border: none;\n	line-height: 40px;\n	font-size: 13px;\n  	letter-spacing: 1px;\n	font-weight: 400;\n	font-family: \"Barlow Condensed\", sans-serif;\n	display: inline-block;\n	background: #000;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	border-radius: 0;\n}\n.ray-bourque-205234  .esg-filterbutton .eg-el-amount {\n  background: #2d2b2b;\n  display: inline-block;\n  line-height: 22px;\n  min-width: 22px;\n  text-align: center;\n  font-weight: 500;\n}\n\n.ray-bourque-205234  .esg-filterbutton.hovered .eg-el-amount,\n.ray-bourque-205234  .esg-filterbutton.selected .eg-el-amount {\n  background: #eaedf1;\n}\n\n.ray-bourque-205234  .esg-filterbutton .eg-el-amount:before,\n.ray-bourque-205234  .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n  margin-left: 0 !important;\n}\n\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean {\n  background: #434242;\n}\n\n.ray-bourque-205234 .esg-cartbutton a {\n	color: #fff;\n}\n\n.ray-bourque-205234 .esg-cartbutton a:hover {\n	color: #000;\n}\n\n.ray-bourque-205234 input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.ray-bourque-205234 input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.ray-bourque-205234 .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 1);\n}\n\n.ray-bourque-205234 .esg-navigationbutton.hovered i {\n	color: #000;\n}\n\n.ray-bourque-205234 .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.ray-bourque-205234 .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.ray-bourque-205234 .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.ray-bourque-205234 .esg-sortbutton-wrapper,\n.ray-bourque-205234 .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.ray-bourque-205234 .esg-sortbutton-order,\n.ray-bourque-205234 .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0;\n  	border: none;\n	font-size: 12px;\n	font-weight: 600;\n	color: #fff;\n	cursor: pointer;\n	background: #434242;\n}\n\n.ray-bourque-205234 .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.ray-bourque-205234 .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.ray-bourque-205234 .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.ray-bourque-205234 .esg-sortbutton,\n.ray-bourque-205234 .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n}\n.ray-bourque-205234 .esg-sortbutton{\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 0;\n}\n\n.ray-bourque-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.ray-bourque-205234 .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.ray-bourque-205234 .esg-navigationbutton.hovered,\n.ray-bourque-205234 .esg-filterbutton.hovered,\n.ray-bourque-205234 .esg-sortbutton.hovered,\n.ray-bourque-205234 .esg-sortbutton-order.hovered,\n.ray-bourque-205234 .esg-cartbutton-order.hovered,\n.ray-bourque-205234 .esg-filterbutton.selected,\n.ray-bourque-205234 .esg-cartbutton.hovered,\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	box-shadow: none;\n	background: #fff;\n}\n\n.ray-bourque-205234 .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.ray-bourque-205234 .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.ray-bourque-205234 .esg-filter-checked {\n	color: rgba(255,255,255,.5);\n  	border: 1px solid rgba(255,255,255,.5);\n	background: transparent;\n	font-size: 9px;\n	font-weight: 300;\n	vertical-align: middle;\n  	line-height: 12px;\n	margin-left: 7px;\n  	display: inline-block;\n  	width: 14px;\n  	height: 14px;\n  	transform: translateY(-2px);\n}\n\n.ray-bourque-205234 .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left: 0;\n	margin-right: 10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.ray-bourque-205234 .esg-filterbutton.selected .esg-filter-checked,\n.ray-bourque-205234 .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n  	border: 1px solid #000;\n}\n\n/* */\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.ray-bourque-205234 .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.ray-bourque-205234 .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background: #000;\n	border-radius: 0;\n  	padding: 0;\n}\n\n.ray-bourque-205234 .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border: none;\n	box-shadow: none;\n	text-align: left;\n	color: #fff;\n	background: transparent;\n	line-height: 25px;\n	min-height: 25px;\n  	padding: 10px 20px;\n  	display: inline-block;\n  	width: 100%;\n  	box-sizing: border-box;\n  	margin: 0;\n}\n\n.ray-bourque-205234 .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.ray-bourque-205234 .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #000;\n  	background: #fff;\n}\n\n\n.ray-bourque-205234 .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color:#fff;\n	font-size:12px;\n}\n\n.ray-bourque-205234 .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n@import url(\"https://fonts.googleapis.com/css2?family=Barlow+Condensed:wght@400;500&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n', NULL);

-- --------------------------------------------------------

--
-- Structure de la table `wp_links`
--

CREATE TABLE `wp_links` (
  `link_id` bigint(20) UNSIGNED NOT NULL,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) UNSIGNED NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `wp_options`
--

CREATE TABLE `wp_options` (
  `option_id` bigint(20) UNSIGNED NOT NULL,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `wp_options`
--

INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1, 'siteurl', 'http://localhost:88/Bellebien/sites', 'yes'),
(2, 'home', 'http://localhost:88/Bellebien/sites', 'yes'),
(3, 'blogname', 'Belle &amp; Bien', 'yes'),
(4, 'blogdescription', 'Face au cancer l&#039;ordonnance de beauté', 'yes'),
(5, 'users_can_register', '0', 'yes'),
(6, 'admin_email', 'masteraf1@gmail.com', 'yes'),
(7, 'start_of_week', '1', 'yes'),
(8, 'use_balanceTags', '0', 'yes'),
(9, 'use_smilies', '1', 'yes'),
(10, 'require_name_email', '1', 'yes'),
(11, 'comments_notify', '1', 'yes'),
(12, 'posts_per_rss', '10', 'yes'),
(13, 'rss_use_excerpt', '0', 'yes'),
(14, 'mailserver_url', 'mail.example.com', 'yes'),
(15, 'mailserver_login', 'login@example.com', 'yes'),
(16, 'mailserver_pass', 'password', 'yes'),
(17, 'mailserver_port', '110', 'yes'),
(18, 'default_category', '1', 'yes'),
(19, 'default_comment_status', 'open', 'yes'),
(20, 'default_ping_status', 'open', 'yes'),
(21, 'default_pingback_flag', '1', 'yes'),
(22, 'posts_per_page', '10', 'yes'),
(23, 'date_format', 'j F Y', 'yes'),
(24, 'time_format', 'G\\hi', 'yes'),
(25, 'links_updated_date_format', 'd F Y G\\hi', 'yes'),
(26, 'comment_moderation', '0', 'yes'),
(27, 'moderation_notify', '1', 'yes'),
(28, 'permalink_structure', '/%year%/%monthnum%/%day%/%postname%/', 'yes'),
(29, 'rewrite_rules', 'a:273:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:39:\"Cap-Douceur/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"Cap-Douceur/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"Cap-Douceur/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"Cap-Douceur/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"Cap-Douceur/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"Cap-Douceur/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"Cap-Douceur/([^/]+)/embed/?$\";s:44:\"index.php?cap-douceur=$matches[1]&embed=true\";s:32:\"Cap-Douceur/([^/]+)/trackback/?$\";s:38:\"index.php?cap-douceur=$matches[1]&tb=1\";s:40:\"Cap-Douceur/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?cap-douceur=$matches[1]&paged=$matches[2]\";s:47:\"Cap-Douceur/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?cap-douceur=$matches[1]&cpage=$matches[2]\";s:36:\"Cap-Douceur/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?cap-douceur=$matches[1]&page=$matches[2]\";s:28:\"Cap-Douceur/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"Cap-Douceur/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"Cap-Douceur/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"Cap-Douceur/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"Cap-Douceur/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"Cap-Douceur/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"client/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"client/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"client/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"client/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"client/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"client/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"client/([^/]+)/embed/?$\";s:39:\"index.php?client=$matches[1]&embed=true\";s:27:\"client/([^/]+)/trackback/?$\";s:33:\"index.php?client=$matches[1]&tb=1\";s:35:\"client/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?client=$matches[1]&paged=$matches[2]\";s:42:\"client/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?client=$matches[1]&cpage=$matches[2]\";s:31:\"client/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?client=$matches[1]&page=$matches[2]\";s:23:\"client/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"client/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"client/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"client/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"client/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"client/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"client-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?client-types=$matches[1]&feed=$matches[2]\";s:48:\"client-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?client-types=$matches[1]&feed=$matches[2]\";s:29:\"client-types/([^/]+)/embed/?$\";s:45:\"index.php?client-types=$matches[1]&embed=true\";s:41:\"client-types/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?client-types=$matches[1]&paged=$matches[2]\";s:23:\"client-types/([^/]+)/?$\";s:34:\"index.php?client-types=$matches[1]\";s:33:\"offer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"offer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"offer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"offer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"offer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"offer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"offer/([^/]+)/embed/?$\";s:38:\"index.php?offer=$matches[1]&embed=true\";s:26:\"offer/([^/]+)/trackback/?$\";s:32:\"index.php?offer=$matches[1]&tb=1\";s:34:\"offer/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?offer=$matches[1]&paged=$matches[2]\";s:41:\"offer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?offer=$matches[1]&cpage=$matches[2]\";s:30:\"offer/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?offer=$matches[1]&page=$matches[2]\";s:22:\"offer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"offer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"offer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"offer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"offer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"offer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"offer-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?offer-types=$matches[1]&feed=$matches[2]\";s:47:\"offer-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?offer-types=$matches[1]&feed=$matches[2]\";s:28:\"offer-types/([^/]+)/embed/?$\";s:44:\"index.php?offer-types=$matches[1]&embed=true\";s:40:\"offer-types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?offer-types=$matches[1]&paged=$matches[2]\";s:22:\"offer-types/([^/]+)/?$\";s:33:\"index.php?offer-types=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"portfolio-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"portfolio-item/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:39:\"portfolio-item/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"portfolio-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"portfolio-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio-types=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio-types=$matches[1]&feed=$matches[2]\";s:32:\"portfolio-types/([^/]+)/embed/?$\";s:48:\"index.php?portfolio-types=$matches[1]&embed=true\";s:44:\"portfolio-types/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?portfolio-types=$matches[1]&paged=$matches[2]\";s:26:\"portfolio-types/([^/]+)/?$\";s:37:\"index.php?portfolio-types=$matches[1]\";s:33:\"slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"slide/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:26:\"slide/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:34:\"slide/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:41:\"slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:30:\"slide/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:22:\"slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"slide-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?slide-types=$matches[1]&feed=$matches[2]\";s:47:\"slide-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?slide-types=$matches[1]&feed=$matches[2]\";s:28:\"slide-types/([^/]+)/embed/?$\";s:44:\"index.php?slide-types=$matches[1]&embed=true\";s:40:\"slide-types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?slide-types=$matches[1]&paged=$matches[2]\";s:22:\"slide-types/([^/]+)/?$\";s:33:\"index.php?slide-types=$matches[1]\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"testimonial-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?testimonial-types=$matches[1]&feed=$matches[2]\";s:53:\"testimonial-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?testimonial-types=$matches[1]&feed=$matches[2]\";s:34:\"testimonial-types/([^/]+)/embed/?$\";s:50:\"index.php?testimonial-types=$matches[1]&embed=true\";s:46:\"testimonial-types/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?testimonial-types=$matches[1]&paged=$matches[2]\";s:28:\"testimonial-types/([^/]+)/?$\";s:39:\"index.php?testimonial-types=$matches[1]\";s:34:\"layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"layout/([^/]+)/embed/?$\";s:39:\"index.php?layout=$matches[1]&embed=true\";s:27:\"layout/([^/]+)/trackback/?$\";s:33:\"index.php?layout=$matches[1]&tb=1\";s:35:\"layout/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?layout=$matches[1]&paged=$matches[2]\";s:42:\"layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?layout=$matches[1]&cpage=$matches[2]\";s:31:\"layout/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?layout=$matches[1]&page=$matches[2]\";s:23:\"layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"template-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"template-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"template-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"template-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"template-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"template-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"template-item/([^/]+)/embed/?$\";s:41:\"index.php?template=$matches[1]&embed=true\";s:34:\"template-item/([^/]+)/trackback/?$\";s:35:\"index.php?template=$matches[1]&tb=1\";s:42:\"template-item/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?template=$matches[1]&paged=$matches[2]\";s:49:\"template-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?template=$matches[1]&cpage=$matches[2]\";s:38:\"template-item/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?template=$matches[1]&page=$matches[2]\";s:30:\"template-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"template-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"template-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"template-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"template-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"template-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=86&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}', 'yes'),
(30, 'hack_file', '0', 'yes'),
(31, 'blog_charset', 'UTF-8', 'yes'),
(32, 'moderation_keys', '', 'no'),
(33, 'active_plugins', 'a:20:{i:0;s:41:\"acf-to-rest-api/class-acf-to-rest-api.php\";i:1;s:30:\"advanced-custom-fields/acf.php\";i:2;s:31:\"ameliabooking/ameliabooking.php\";i:3;s:27:\"ari-adminer/ari-adminer.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:43:\"custom-post-type-ui/custom-post-type-ui.php\";i:6;s:33:\"duplicate-post/duplicate-post.php\";i:7;s:33:\"essential-grid/essential-grid.php\";i:8;s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";i:9;s:39:\"google-apps-login/google_apps_login.php\";i:10;s:27:\"js_composer/js_composer.php\";i:11;s:47:\"jwt-authentication-for-wp-rest-api/jwt-auth.php\";i:12;s:25:\"loginpress/loginpress.php\";i:13;s:19:\"rest-api/plugin.php\";i:14;s:23:\"revslider/revslider.php\";i:15;s:48:\"simple-301-redirects/wp-simple-301-redirects.php\";i:16;s:37:\"user-role-editor/user-role-editor.php\";i:17;s:41:\"wordpress-importer/wordpress-importer.php\";i:18;s:37:\"wp-store-locator/wp-store-locator.php\";i:19;s:33:\"wps-hide-login/wps-hide-login.php\";}', 'yes'),
(34, 'category_base', '', 'yes'),
(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(36, 'comment_max_links', '2', 'yes'),
(37, 'gmt_offset', '', 'yes'),
(38, 'default_email_category', '1', 'yes'),
(39, 'recently_edited', '', 'no'),
(40, 'template', 'betheme', 'yes'),
(41, 'stylesheet', 'betheme-child', 'yes'),
(42, 'comment_registration', '0', 'yes'),
(43, 'html_type', 'text/html', 'yes'),
(44, 'use_trackback', '0', 'yes'),
(45, 'default_role', 'subscriber', 'yes'),
(46, 'db_version', '49752', 'yes'),
(47, 'uploads_use_yearmonth_folders', '1', 'yes'),
(48, 'upload_path', '', 'yes'),
(49, 'blog_public', '1', 'yes'),
(50, 'default_link_category', '2', 'yes'),
(51, 'show_on_front', 'page', 'yes'),
(52, 'tag_base', '', 'yes'),
(53, 'show_avatars', '1', 'yes'),
(54, 'avatar_rating', 'G', 'yes'),
(55, 'upload_url_path', '', 'yes'),
(56, 'thumbnail_size_w', '150', 'yes'),
(57, 'thumbnail_size_h', '150', 'yes'),
(58, 'thumbnail_crop', '1', 'yes'),
(59, 'medium_size_w', '300', 'yes'),
(60, 'medium_size_h', '300', 'yes'),
(61, 'avatar_default', 'mystery', 'yes'),
(62, 'large_size_w', '1024', 'yes'),
(63, 'large_size_h', '1024', 'yes'),
(64, 'image_default_link_type', 'none', 'yes'),
(65, 'image_default_size', '', 'yes'),
(66, 'image_default_align', '', 'yes'),
(67, 'close_comments_for_old_posts', '0', 'yes'),
(68, 'close_comments_days_old', '14', 'yes'),
(69, 'thread_comments', '1', 'yes'),
(70, 'thread_comments_depth', '5', 'yes'),
(71, 'page_comments', '0', 'yes'),
(72, 'comments_per_page', '50', 'yes'),
(73, 'default_comments_page', 'newest', 'yes'),
(74, 'comment_order', 'asc', 'yes'),
(75, 'sticky_posts', 'a:0:{}', 'yes'),
(76, 'widget_categories', 'a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(77, 'widget_text', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
(78, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
(79, 'uninstall_plugins', 'a:3:{s:25:\"loginpress/loginpress.php\";a:2:{i:0;s:10:\"LoginPress\";i:1;s:21:\"plugin_uninstallation\";}s:31:\"ameliabooking/ameliabooking.php\";a:2:{i:0;s:20:\"AmeliaBooking\\Plugin\";i:1;s:8:\"deletion\";}s:37:\"user-role-editor/user-role-editor.php\";a:2:{i:0;s:16:\"User_Role_Editor\";i:1;s:9:\"uninstall\";}}', 'no'),
(80, 'timezone_string', 'Europe/Paris', 'yes'),
(81, 'page_for_posts', '8', 'yes'),
(82, 'page_on_front', '86', 'yes'),
(83, 'default_post_format', '0', 'yes'),
(84, 'link_manager_enabled', '0', 'yes'),
(85, 'finished_splitting_shared_terms', '1', 'yes'),
(86, 'site_icon', '0', 'yes'),
(87, 'medium_large_size_w', '768', 'yes'),
(88, 'medium_large_size_h', '0', 'yes'),
(89, 'wp_page_for_privacy_policy', '3', 'yes'),
(90, 'show_comments_cookies_opt_in', '1', 'yes'),
(91, 'admin_email_lifespan', '1641325836', 'yes'),
(92, 'disallowed_keys', '', 'no'),
(93, 'comment_previously_approved', '1', 'yes'),
(94, 'auto_plugin_theme_update_emails', 'a:0:{}', 'no'),
(95, 'auto_update_core_dev', 'enabled', 'yes'),
(96, 'auto_update_core_minor', 'enabled', 'yes'),
(97, 'auto_update_core_major', 'enabled', 'yes'),
(98, 'initial_db_version', '49752', 'yes'),
(99, 'wp_user_roles', 'a:9:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:144:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:16:\"amelia_read_menu\";b:1;s:21:\"amelia_read_dashboard\";b:1;s:20:\"amelia_read_calendar\";b:1;s:24:\"amelia_read_appointments\";b:1;s:18:\"amelia_read_events\";b:1;s:21:\"amelia_read_employees\";b:1;s:20:\"amelia_read_services\";b:1;s:20:\"amelia_read_packages\";b:1;s:21:\"amelia_read_locations\";b:1;s:19:\"amelia_read_coupons\";b:1;s:21:\"amelia_read_customers\";b:1;s:19:\"amelia_read_finance\";b:1;s:25:\"amelia_read_notifications\";b:1;s:21:\"amelia_read_customize\";b:1;s:25:\"amelia_read_custom_fields\";b:1;s:20:\"amelia_read_settings\";b:1;s:27:\"amelia_read_others_calendar\";b:1;s:31:\"amelia_read_others_appointments\";b:1;s:28:\"amelia_read_others_employees\";b:1;s:28:\"amelia_read_others_customers\";b:1;s:22:\"amelia_write_dashboard\";b:1;s:21:\"amelia_write_calendar\";b:1;s:25:\"amelia_write_appointments\";b:1;s:19:\"amelia_write_events\";b:1;s:22:\"amelia_write_employees\";b:1;s:21:\"amelia_write_services\";b:1;s:21:\"amelia_write_packages\";b:1;s:22:\"amelia_write_locations\";b:1;s:20:\"amelia_write_coupons\";b:1;s:22:\"amelia_write_customers\";b:1;s:20:\"amelia_write_finance\";b:1;s:26:\"amelia_write_notifications\";b:1;s:22:\"amelia_write_customize\";b:1;s:26:\"amelia_write_custom_fields\";b:1;s:21:\"amelia_write_settings\";b:1;s:19:\"amelia_write_status\";b:1;s:28:\"amelia_write_others_calendar\";b:1;s:32:\"amelia_write_others_appointments\";b:1;s:29:\"amelia_write_others_employees\";b:1;s:26:\"amelia_write_others_events\";b:1;s:27:\"amelia_write_others_finance\";b:1;s:29:\"amelia_write_others_dashboard\";b:1;s:23:\"amelia_delete_dashboard\";b:1;s:22:\"amelia_delete_calendar\";b:1;s:26:\"amelia_delete_appointments\";b:1;s:20:\"amelia_delete_events\";b:1;s:23:\"amelia_delete_employees\";b:1;s:22:\"amelia_delete_services\";b:1;s:22:\"amelia_delete_packages\";b:1;s:23:\"amelia_delete_locations\";b:1;s:21:\"amelia_delete_coupons\";b:1;s:23:\"amelia_delete_customers\";b:1;s:21:\"amelia_delete_finance\";b:1;s:27:\"amelia_delete_notifications\";b:1;s:23:\"amelia_delete_customize\";b:1;s:27:\"amelia_delete_custom_fields\";b:1;s:22:\"amelia_delete_settings\";b:1;s:32:\"amelia_write_status_appointments\";b:1;s:26:\"amelia_write_status_events\";b:1;s:30:\"amelia_write_time_appointments\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:20:\"manage_wpsl_settings\";b:1;s:10:\"edit_store\";b:1;s:10:\"read_store\";b:1;s:12:\"delete_store\";b:1;s:11:\"edit_stores\";b:1;s:18:\"edit_others_stores\";b:1;s:14:\"publish_stores\";b:1;s:19:\"read_private_stores\";b:1;s:13:\"delete_stores\";b:1;s:21:\"delete_private_stores\";b:1;s:23:\"delete_published_stores\";b:1;s:20:\"delete_others_stores\";b:1;s:19:\"edit_private_stores\";b:1;s:21:\"edit_published_stores\";b:1;s:11:\"run_adminer\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:26:\"wpsl_store_locator_manager\";a:2:{s:4:\"name\";s:21:\"Store Locator Manager\";s:12:\"capabilities\";a:37:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:12:\"delete_posts\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:19:\"delete_others_pages\";b:1;s:19:\"delete_others_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;s:10:\"edit_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:17:\"moderate_comments\";b:1;s:13:\"publish_pages\";b:1;s:13:\"publish_posts\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_store\";b:1;s:10:\"read_store\";b:1;s:12:\"delete_store\";b:1;s:11:\"edit_stores\";b:1;s:18:\"edit_others_stores\";b:1;s:14:\"publish_stores\";b:1;s:19:\"read_private_stores\";b:1;s:13:\"delete_stores\";b:1;s:21:\"delete_private_stores\";b:1;s:23:\"delete_published_stores\";b:1;s:20:\"delete_others_stores\";b:1;s:19:\"edit_private_stores\";b:1;s:21:\"edit_published_stores\";b:1;}}s:17:\"wpamelia-customer\";a:2:{s:4:\"name\";s:15:\"Amelia Customer\";s:12:\"capabilities\";a:7:{s:4:\"read\";b:1;s:16:\"amelia_read_menu\";b:1;s:20:\"amelia_read_calendar\";b:1;s:24:\"amelia_read_appointments\";b:1;s:18:\"amelia_read_events\";b:1;s:32:\"amelia_write_status_appointments\";b:1;s:30:\"amelia_write_time_appointments\";b:1;}}s:17:\"wpamelia-provider\";a:2:{s:4:\"name\";s:15:\"Amelia Employee\";s:12:\"capabilities\";a:16:{s:4:\"read\";b:1;s:20:\"amelia_delete_events\";b:1;s:16:\"amelia_read_menu\";b:1;s:20:\"amelia_read_calendar\";b:1;s:24:\"amelia_read_appointments\";b:1;s:18:\"amelia_read_events\";b:1;s:21:\"amelia_read_employees\";b:1;s:28:\"amelia_read_others_customers\";b:1;s:22:\"amelia_write_employees\";b:1;s:32:\"amelia_write_status_appointments\";b:1;s:26:\"amelia_write_status_events\";b:1;s:30:\"amelia_write_time_appointments\";b:1;s:32:\"amelia_write_others_appointments\";b:0;s:25:\"amelia_write_appointments\";b:1;s:19:\"amelia_write_events\";b:1;s:26:\"amelia_write_others_events\";b:0;}}s:16:\"wpamelia-manager\";a:2:{s:4:\"name\";s:14:\"Amelia Manager\";s:12:\"capabilities\";a:41:{s:4:\"read\";b:1;s:20:\"amelia_delete_events\";b:1;s:16:\"amelia_read_menu\";b:1;s:21:\"amelia_read_dashboard\";b:1;s:20:\"amelia_read_calendar\";b:1;s:24:\"amelia_read_appointments\";b:1;s:18:\"amelia_read_events\";b:1;s:21:\"amelia_read_employees\";b:1;s:20:\"amelia_read_services\";b:1;s:20:\"amelia_read_packages\";b:1;s:21:\"amelia_read_locations\";b:1;s:19:\"amelia_read_coupons\";b:1;s:21:\"amelia_read_customers\";b:1;s:19:\"amelia_read_finance\";b:1;s:25:\"amelia_read_notifications\";b:1;s:27:\"amelia_read_others_calendar\";b:1;s:31:\"amelia_read_others_appointments\";b:1;s:28:\"amelia_read_others_employees\";b:1;s:28:\"amelia_read_others_customers\";b:1;s:22:\"amelia_write_dashboard\";b:1;s:21:\"amelia_write_calendar\";b:1;s:25:\"amelia_write_appointments\";b:1;s:19:\"amelia_write_events\";b:1;s:22:\"amelia_write_employees\";b:1;s:21:\"amelia_write_services\";b:1;s:21:\"amelia_write_packages\";b:1;s:22:\"amelia_write_locations\";b:1;s:20:\"amelia_write_coupons\";b:1;s:22:\"amelia_write_customers\";b:1;s:20:\"amelia_write_finance\";b:1;s:26:\"amelia_write_notifications\";b:1;s:28:\"amelia_write_others_calendar\";b:1;s:32:\"amelia_write_others_appointments\";b:1;s:29:\"amelia_write_others_employees\";b:1;s:26:\"amelia_write_others_events\";b:1;s:27:\"amelia_write_others_finance\";b:1;s:29:\"amelia_write_others_dashboard\";b:1;s:32:\"amelia_write_status_appointments\";b:1;s:26:\"amelia_write_status_events\";b:1;s:30:\"amelia_write_time_appointments\";b:1;s:12:\"upload_files\";b:1;}}}', 'yes'),
(100, 'fresh_site', '0', 'yes'),
(101, 'WPLANG', 'fr_FR', 'yes'),
(102, 'widget_search', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(103, 'widget_recent-posts', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(104, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(105, 'widget_archives', 'a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(106, 'widget_meta', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(108, 'cron', 'a:6:{i:1626180636;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1626205836;a:5:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1626205845;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1626205846;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1626465036;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}', 'yes'),
(109, 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(110, 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(111, 'widget_media_audio', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(112, 'widget_media_image', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(113, 'widget_media_gallery', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(114, 'widget_media_video', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(115, 'widget_tag_cloud', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(116, 'widget_nav_menu', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(117, 'widget_custom_html', 'a:4:{i:2;a:2:{s:5:\"title\";s:10:\"Contact us\";s:7:\"content\";s:164:\"\r\n[divider height=\"10\"]\r\n<p>\r\n	Nullam viverra consectetuer<br /> quisque cursus et, porttitor risus.\r\n</p>\r\n<p>\r\n+61 (0) 3 8376 6284<br />\r\nnoreply@envato.com\r\n</p>\";}i:4;a:2:{s:5:\"title\";s:12:\"Localization\";s:7:\"content\";s:105:\"[divider height=\"10\"]\r\n<p>Envato<br />\r\nLevel 13, 2 Elizabeth<br />\r\nVictoria 3000<br />\r\nAustralia\r\n</p>\";}i:3;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:170:\"[divider height=\"40\"]\r\n<div style=\"text-align:center;\">\r\n<img src=\"https://themes.muffingroup.com/be/code2/wp-content/uploads/2019/06/code2-footer-logo.png\" />\r\n	\r\n</div>\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(119, 'recovery_keys', 'a:0:{}', 'yes'),
(120, 'https_detection_errors', 'a:1:{s:20:\"https_request_failed\";a:1:{i:0;s:28:\"La demande HTTPS a échoué.\";}}', 'yes'),
(124, 'theme_mods_twentytwentyone', 'a:3:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:2;s:6:\"footer\";i:3;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1625775767;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}', 'yes'),
(132, '_site_transient_timeout_browser_d3581de507ceb29c498f509f31ea7f50', '1626378646', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(133, '_site_transient_browser_d3581de507ceb29c498f509f31ea7f50', 'a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"91.0.4472.114\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}', 'no'),
(134, '_site_transient_timeout_php_check_75809dde56e3fe2c2fb740f1b55807ac', '1626378646', 'no'),
(135, '_site_transient_php_check_75809dde56e3fe2c2fb740f1b55807ac', 'a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}', 'no'),
(139, 'can_compress_scripts', '1', 'no'),
(150, 'recently_activated', 'a:0:{}', 'yes'),
(151, 'loginpress_customization', 'a:28:{s:24:\"setting_background_color\";s:7:\"#d52878\";s:21:\"loginpress_display_bg\";b:0;s:12:\"setting_logo\";s:74:\"http://localhost:88/Bellebien/sites/wp-content/uploads/2021/07/logo_bb.png\";s:20:\"customize_logo_width\";i:336;s:21:\"customize_logo_height\";i:134;s:22:\"customize_logo_padding\";i:14;s:26:\"customize_login_page_title\";s:8:\"extranet\";s:20:\"customize_form_width\";i:454;s:21:\"customize_form_height\";i:207;s:21:\"customize_form_radius\";i:55;s:21:\"customize_form_shadow\";i:0;s:26:\"textfield_background_color\";s:0:\"\";s:15:\"textfield_color\";s:7:\"#d52878\";s:21:\"textfield_label_color\";s:7:\"#d52878\";s:22:\"remember_me_label_size\";s:7:\"#d52878\";s:19:\"custom_button_color\";s:7:\"#d52878\";s:19:\"button_border_color\";s:7:\"#000000\";s:19:\"button_hover_border\";s:7:\"#000000\";s:18:\"button_hover_color\";s:7:\"#d65993\";s:23:\"button_hover_text_color\";s:7:\"#ffffff\";s:17:\"button_text_color\";s:7:\"#ffffff\";s:18:\"login_footer_color\";s:7:\"#d52878\";s:24:\"login_footer_color_hover\";s:7:\"#d66d9e\";s:22:\"login_footer_font_size\";i:13;s:16:\"login_back_color\";s:7:\"#d52878\";s:22:\"login_back_color_hover\";s:7:\"#d66d9e\";s:24:\"login_copy_right_display\";b:0;s:20:\"loginpress_show_love\";b:0;}', 'yes'),
(152, 'loginpress_setting', 'a:6:{s:18:\"session_expiration\";i:0;s:16:\"auto_remember_me\";s:3:\"off\";s:21:\"enable_reg_pass_field\";s:3:\"off\";s:11:\"login_order\";s:7:\"default\";s:14:\"reset_settings\";s:3:\"off\";s:20:\"loginpress_uninstall\";s:3:\"off\";}', 'yes'),
(153, 'loginpress_active_time', '1625773873', 'no'),
(154, 'loginpress_login_redirects', '', 'yes'),
(155, 'loginpress_social_logins', '', 'yes'),
(156, 'loginpress_limit_login_attempts', '', 'yes'),
(157, 'loginpress_autologin', '', 'yes'),
(158, 'loginpress_hidelogin', '', 'yes'),
(159, 'loginpress_premium', '', 'yes'),
(161, '_loginpress_optin', 'yes', 'yes'),
(164, 'nav_menu_options', 'a:1:{s:8:\"auto_add\";a:0:{}}', 'yes'),
(167, 'finished_updating_comment_type', '1', 'yes'),
(168, '_site_transient_timeout_php_check_7841c854be39099ac1d9b61bb411ecb0', '1626379366', 'no'),
(169, '_site_transient_php_check_7841c854be39099ac1d9b61bb411ecb0', 'a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}', 'no'),
(179, 'new_admin_email', 'masteraf1@gmail.com', 'yes'),
(180, 'whl_page', 'extranet', 'yes'),
(181, 'whl_redirect_admin', '404', 'yes'),
(186, '_transient_timeout_loginpress_rdn_fetch_notifications', '1626381050', 'no'),
(187, '_transient_loginpress_rdn_fetch_notifications', 'rdn_fetch_notifications', 'no'),
(196, 'amelia_settings', '{\"db\":{\"mysqliEnabled\":false,\"pdoEmulatePrepares\":false,\"pdoBigSelect\":false,\"ssl\":{\"enable\":false,\"key\":null,\"cert\":null,\"ca\":null}},\"general\":{\"timeSlotLength\":1800,\"serviceDurationAsSlot\":false,\"bufferTimeInSlot\":true,\"defaultAppointmentStatus\":\"approved\",\"minimumTimeRequirementPriorToBooking\":0,\"minimumTimeRequirementPriorToCanceling\":0,\"minimumTimeRequirementPriorToRescheduling\":0,\"numberOfDaysAvailableForBooking\":365,\"backendSlotsDaysInFuture\":365,\"backendSlotsDaysInPast\":365,\"phoneDefaultCountryCode\":\"auto\",\"requiredPhoneNumberField\":false,\"requiredEmailField\":true,\"itemsPerPage\":12,\"appointmentsPerPage\":100,\"customersFilterLimit\":100,\"gMapApiKey\":\"\",\"addToCalendar\":true,\"sendIcsAttachment\":false,\"defaultPageOnBackend\":\"Dashboard\",\"showClientTimeZone\":false,\"redirectUrlAfterAppointment\":\"\",\"customFieldsUploadsPath\":\"\",\"runInstantPostBookingActions\":false,\"useWindowVueInAmelia\":true,\"useWindowVueInAmeliaBack\":true,\"sortingPackages\":\"nameAsc\",\"sortingServices\":\"nameAsc\",\"calendarLocaleSubstitutes\":[],\"googleRecaptcha\":{\"enabled\":false,\"invisible\":true,\"siteKey\":\"\",\"secret\":\"\"},\"usedLanguages\":[]},\"company\":{\"pictureFullPath\":\"\",\"pictureThumbPath\":\"\",\"name\":\"\",\"address\":\"\",\"phone\":\"\",\"countryPhoneIso\":\"\",\"website\":\"\"},\"notifications\":{\"mailService\":\"php\",\"smtpHost\":\"\",\"smtpPort\":\"\",\"smtpSecure\":\"ssl\",\"smtpUsername\":\"\",\"smtpPassword\":\"\",\"mailgunApiKey\":\"\",\"mailgunDomain\":\"\",\"mailgunEndpoint\":\"\",\"senderName\":\"\",\"senderEmail\":\"\",\"notifyCustomers\":true,\"sendAllCF\":true,\"smsAlphaSenderId\":\"Amelia\",\"smsSignedIn\":false,\"smsApiToken\":\"\",\"bccEmail\":\"\",\"cancelSuccessUrl\":\"\",\"cancelErrorUrl\":\"\",\"breakReplacement\":\"<br>\"},\"daysOff\":[],\"weekSchedule\":[{\"day\":\"Monday\",\"time\":[\"09:00\",\"17:00\"],\"breaks\":[],\"periods\":[]},{\"day\":\"Tuesday\",\"time\":[\"09:00\",\"17:00\"],\"breaks\":[],\"periods\":[]},{\"day\":\"Wednesday\",\"time\":[\"09:00\",\"17:00\"],\"breaks\":[],\"periods\":[]},{\"day\":\"Thursday\",\"time\":[\"09:00\",\"17:00\"],\"breaks\":[],\"periods\":[]},{\"day\":\"Friday\",\"time\":[\"09:00\",\"17:00\"],\"breaks\":[],\"periods\":[]},{\"day\":\"Saturday\",\"time\":[],\"breaks\":[],\"periods\":[]},{\"day\":\"Sunday\",\"time\":[],\"breaks\":[],\"periods\":[]}],\"googleCalendar\":{\"clientID\":\"\",\"clientSecret\":\"\",\"redirectURI\":\"http:\\/\\/localhost:88\\/Bellebien\\/sites\\/wp-admin\\/admin.php?page=wpamelia-employees\",\"showAttendees\":false,\"insertPendingAppointments\":false,\"addAttendees\":false,\"sendEventInvitationEmail\":false,\"removeGoogleCalendarBusySlots\":false,\"maximumNumberOfEventsReturned\":50,\"eventTitle\":\"%service_name%\",\"eventDescription\":\"\",\"includeBufferTimeGoogleCalendar\":false,\"status\":\"tentative\",\"enableGoogleMeet\":false},\"outlookCalendar\":{\"clientID\":\"\",\"clientSecret\":\"\",\"redirectURI\":\"http:\\/\\/localhost:88\\/Bellebien\\/sites\\/wp-admin\\/\",\"insertPendingAppointments\":false,\"addAttendees\":false,\"sendEventInvitationEmail\":false,\"removeOutlookCalendarBusySlots\":false,\"maximumNumberOfEventsReturned\":50,\"eventTitle\":\"%service_name%\",\"eventDescription\":\"\",\"includeBufferTimeOutlookCalendar\":false},\"payments\":{\"currency\":\"USD\",\"symbol\":\"$\",\"priceSymbolPosition\":\"before\",\"priceNumberOfDecimals\":2,\"priceSeparator\":1,\"hideCurrencySymbolFrontend\":false,\"defaultPaymentMethod\":\"onSite\",\"onSite\":true,\"coupons\":true,\"payPal\":{\"enabled\":false,\"sandboxMode\":false,\"liveApiClientId\":\"\",\"liveApiSecret\":\"\",\"testApiClientId\":\"\",\"testApiSecret\":\"\",\"description\":{\"enabled\":false,\"appointment\":\"\",\"package\":\"\",\"event\":\"\"}},\"stripe\":{\"enabled\":false,\"testMode\":false,\"livePublishableKey\":\"\",\"liveSecretKey\":\"\",\"testPublishableKey\":\"\",\"testSecretKey\":\"\",\"description\":{\"enabled\":false,\"appointment\":\"\",\"package\":\"\",\"event\":\"\"},\"metaData\":{\"enabled\":false,\"appointment\":null,\"package\":null,\"event\":null},\"manualCapture\":false},\"wc\":{\"enabled\":false,\"productId\":\"\",\"onSiteIfFree\":false,\"page\":\"cart\",\"dashboard\":true,\"checkoutData\":{\"appointment\":\"\",\"package\":\"\",\"event\":\"\",\"translations\":{\"appointment\":null,\"event\":null,\"package\":null}},\"skipCheckoutGetValueProcessing\":false},\"mollie\":{\"enabled\":false,\"testMode\":false,\"liveApiKey\":\"\",\"testApiKey\":\"\",\"description\":{\"enabled\":false,\"appointment\":\"\",\"package\":\"\",\"event\":\"\"},\"metaData\":{\"enabled\":false,\"appointment\":null,\"package\":null,\"event\":null},\"method\":[]}},\"activation\":{\"showActivationSettings\":true,\"active\":false,\"purchaseCodeStore\":\"\",\"envatoTokenEmail\":\"\",\"version\":\"4.0.1\",\"deleteTables\":false,\"stash\":false},\"customization\":{\"primaryColor\":\"#d52878\",\"primaryGradient1\":\"#d52878\",\"primaryGradient2\":\"#0454A2\",\"textColor\":\"#354052\",\"textColorOnBackground\":\"#FFFFFF\",\"font\":\"Roboto\",\"useGenerated\":false,\"hash\":\"kcCGswopWJ\"},\"labels\":{\"enabled\":true,\"employee\":\"employee\",\"employees\":\"employees\",\"service\":\"service\",\"services\":\"services\"},\"roles\":{\"allowConfigureSchedule\":false,\"allowConfigureDaysOff\":false,\"allowConfigureSpecialDays\":false,\"allowConfigureServices\":false,\"allowWriteAppointments\":false,\"automaticallyCreateCustomer\":false,\"inspectCustomerInfo\":false,\"allowCustomerReschedule\":false,\"allowCustomerDeleteProfile\":false,\"allowWriteEvents\":false,\"enabledHttpAuthorization\":true,\"customerCabinet\":{\"enabled\":true,\"headerJwtSecret\":\"519e23a581ef9717f2b7\",\"urlJwtSecret\":\"8b856bd84a267b90ee04\",\"tokenValidTime\":2592000,\"pageUrl\":\"\",\"loginEnabled\":true,\"filterDate\":false,\"translations\":[]},\"providerCabinet\":{\"enabled\":true,\"headerJwtSecret\":\"b379d26aff0afb421b57\",\"urlJwtSecret\":\"1db4dadcbf41b794be55\",\"tokenValidTime\":2592000,\"pageUrl\":\"\",\"loginEnabled\":true,\"filterDate\":false},\"urlAttachment\":{\"enabled\":true,\"headerJwtSecret\":\"db43572e00f9b16566fe\",\"urlJwtSecret\":\"3775c22fb805dbe038b2\",\"tokenValidTime\":2592000,\"pageUrl\":\"\",\"loginEnabled\":true,\"filterDate\":false}},\"appointments\":{\"isGloballyBusySlot\":false,\"allowBookingIfPending\":true,\"allowBookingIfNotMin\":true,\"openedBookingAfterMin\":false,\"recurringPlaceholders\":\"DateTime: %appointment_date_time%\",\"recurringPlaceholdersSms\":\"DateTime: %appointment_date_time%\",\"recurringPlaceholdersCustomer\":\"DateTime: %appointment_date_time%\",\"recurringPlaceholdersCustomerSms\":\"DateTime: %appointment_date_time%\",\"packagePlaceholders\":\"DateTime: %appointment_date_time%\",\"packagePlaceholdersSms\":\"DateTime: %appointment_date_time%\",\"packagePlaceholdersCustomer\":\"DateTime: %appointment_date_time%\",\"packagePlaceholdersCustomerSms\":\"DateTime: %appointment_date_time%\",\"translations\":{\"recurringPlaceholdersCustomer\":null,\"recurringPlaceholdersCustomerSms\":null,\"packagePlaceholdersCustomer\":null,\"packagePlaceholdersCustomerSms\":null}},\"webHooks\":[],\"zoom\":{\"enabled\":true,\"apiKey\":\"\",\"apiSecret\":\"\",\"meetingTitle\":\"%reservation_name%\",\"meetingAgenda\":\"%reservation_description%\",\"pendingAppointmentsMeetings\":false,\"maxUsersCount\":300},\"ics\":{\"description\":{\"appointment\":\"\",\"event\":\"\",\"translations\":{\"appointment\":null,\"event\":null}}}}', 'yes'),
(197, 'wpcf7', 'a:2:{s:7:\"version\";s:5:\"5.4.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1625775627;s:7:\"version\";s:5:\"5.4.1\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}', 'yes'),
(200, 'essgrid_servers', 'a:7:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:16:\"themepunch.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-a.tools\";i:4;s:22:\"themepunch-ext-a.tools\";i:5;s:22:\"themepunch-ext-b.tools\";i:6;s:22:\"themepunch-ext-b.tools\";}', 'yes'),
(201, 'essgrid_server_refresh', '1625775627', 'yes'),
(202, 'tp_eg_grids_version', '3.0', 'yes'),
(203, 'tp_eg_custom_css_imported', 'true', 'yes'),
(204, 'tp_eg_custom_css', '/* HENRY HARRISON */\n\na.eg-henryharrison-element-1,\na.eg-henryharrison-element-2 {\n  -webkit-transition: all .4s linear;  \n    -moz-transition: all .4s linear;  \n    -o-transition: all .4s linear;  \n    -ms-transition: all .4s linear;  \n    transition: all .4s linear; \n}\n\n/* JIMMY CARTER */\n.eg-jimmy-carter-element-11 i:before { margin-left:0px; margin-right:0px;}\n\n\n/* HARDING */\n.eg-harding-element-17 { letter-spacing:1px}\n.eg-harding-wrapper .esg-entry-media { overflow:hidden; \n            box-sizing:border-box;\n            -webkit-box-sizing:border-box;\n            -moz-box-sizing:border-box;\n            padding:30px 30px 0px 30px;\n}\n\n.eg-harding-wrapper .esg-media-poster { overflow:hidden; \n            border-radius:50%;\n            -webkit-border-radius:50%;\n            -moz-border-radius:50%;\n}\n\n/*ULYSSES S GRANT */\n.eg-ulysses-s-grant-wrapper .esg-entry-media { overflow:hidden; \n            box-sizing:border-box;\n            -webkit-box-sizing:border-box;\n            -moz-box-sizing:border-box;\n            padding:30px 30px 0px 30px;\n}\n\n.eg-ulysses-s-grant-wrapper .esg-media-poster { overflow:hidden; \n            border-radius:50%;\n            -webkit-border-radius:50%;\n            -moz-border-radius:50%;\n}\n\n/*RICHARD NIXON */\n.eg-richard-nixon-wrapper .esg-entry-media { overflow:hidden; \n            box-sizing:border-box;\n            -webkit-box-sizing:border-box;\n            -moz-box-sizing:border-box;\n            padding:30px 30px 0px 30px;\n}\n\n.eg-richard-nixon-wrapper .esg-media-poster { overflow:hidden; \n            border-radius:50%;\n            -webkit-border-radius:50%;\n            -moz-border-radius:50%;\n}\n\n\n/* HERBERT HOOVER */\n.eg-herbert-hoover-wrapper .esg-media-poster{\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\"); /* Firefox 10+, Firefox on Android */\n    filter: gray; /* IE6-9 */\n    -webkit-filter: grayscale(100%); /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n\n.eg-herbert-hoover-wrapper:hover .esg-media-poster{\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\");\n    -webkit-filter: grayscale(0%);}\n\n\n/* JOOHNSON */\n.eg-lyndon-johnson-wrapper .esg-media-poster{\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\"); /* Firefox 10+, Firefox on Android */\n    filter: gray; /* IE6-9 */\n    -webkit-filter: grayscale(100%); /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n\n.eg-lyndon-johnson-wrapper:hover .esg-media-poster{\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\");\n    -webkit-filter: grayscale(0%);}\n\n\n/*RONALD REAGAN*/\n.esg-overlay.eg-ronald-reagan-container {background: -moz-linear-gradient(top, rgba(0,0,0,0) 50%, rgba(0,0,0,0.83) 99%, rgba(0,0,0,0.85) 100%); /* FF3.6+ */\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(50%,rgba(0,0,0,0)), color-stop(99%,rgba(0,0,0,0.83)), color-stop(100%,rgba(0,0,0,0.85))); /* Chrome,Safari4+ */\nbackground: -webkit-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* Chrome10+,Safari5.1+ */\nbackground: -o-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* Opera 11.10+ */\nbackground: -ms-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* IE10+ */\nbackground: linear-gradient(to bottom, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* W3C */\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#00000000\', endColorstr=\'#d9000000\',GradientType=0 ); /* IE6-9 */}\n\n/*GEORGE BUSH*/\n.eg-georgebush-wrapper .esg-entry-cover {background: -moz-linear-gradient(top, rgba(0,0,0,0) 50%, rgba(0,0,0,0.83) 99%, rgba(0,0,0,0.85) 100%); /* FF3.6+ */\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(50%,rgba(0,0,0,0)), color-stop(99%,rgba(0,0,0,0.83)), color-stop(100%,rgba(0,0,0,0.85))); /* Chrome,Safari4+ */\nbackground: -webkit-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* Chrome10+,Safari5.1+ */\nbackground: -o-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* Opera 11.10+ */\nbackground: -ms-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* IE10+ */\nbackground: linear-gradient(to bottom, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* W3C */\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#00000000\', endColorstr=\'#d9000000\',GradientType=0 ); /* IE6-9 */}\n\n/*GEORGE BUSH\n.eg-georgebush-wrapper .esg-entry-cover { background: rgba(0,0,0,0.5);}*/\n\n/*JEFFERSON*/\n.eg-jefferson-wrapper { -webkit-border-radius: 5px !important; -moz-border-radius: 5px !important; border-radius: 5px !important; -webkit-mask-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAA5JREFUeNpiYGBgAAgwAAAEAAGbA+oJAAAAAElFTkSuQmCC) !important; }\n\n/*MONROE*/\n.eg-monroe-element-1 { text-shadow: 0px 1px 3px rgba(0, 0, 0, 0.1); }\n\n/*LYNDON JOHNSON*/\n.eg-lyndon-johnson-wrapper .esg-entry-cover { background: -moz-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%, rgba(18,18,18,0) 96%, rgba(19,19,19,0) 100%); /* FF3.6+ */\nbackground: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,rgba(0,0,0,0.35)), color-stop(96%,rgba(18,18,18,0)), color-stop(100%,rgba(19,19,19,0))); /* Chrome,Safari4+ */\nbackground: -webkit-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* Chrome10+,Safari5.1+ */\nbackground: -o-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* Opera 12+ */\nbackground: -ms-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* IE10+ */\nbackground: radial-gradient(ellipse at center,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* W3C */\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#59000000\', endColorstr=\'#00131313\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\n }\n\n/*WILBERT*/\n.eg-wilbert-wrapper .esg-entry-cover { background: -moz-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%, rgba(18,18,18,0) 96%, rgba(19,19,19,0) 100%); /* FF3.6+ */\nbackground: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,rgba(0,0,0,0.35)), color-stop(96%,rgba(18,18,18,0)), color-stop(100%,rgba(19,19,19,0))); /* Chrome,Safari4+ */\nbackground: -webkit-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* Chrome10+,Safari5.1+ */\nbackground: -o-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* Opera 12+ */\nbackground: -ms-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* IE10+ */\nbackground: radial-gradient(ellipse at center,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* W3C */\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#59000000\', endColorstr=\'#00131313\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\n }\n.eg-wilbert-wrapper .esg-media-poster{\n  -webkit-transition: 0.4s ease-in-out;\n    -moz-transition:  0.4s ease-in-out;\n    -o-transition:  0.4s ease-in-out;\n    transition:  0.4s ease-in-out;\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\"); /* Firefox 10+, Firefox on Android */\n    filter: gray; /* IE6-9 */\n    -webkit-filter: grayscale(100%); /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n\n.eg-wilbert-wrapper:hover .esg-media-poster{\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\");\n    -webkit-filter: grayscale(0%);}\n\n/*PHILLIE*/\n.eg-phillie-element-3:after { \ncontent:\" \";\nwidth: 0px;\nheight: 0px;\nborder-style: solid;\nborder-width: 5px 5px 0 5px;\nborder-color: #000 transparent transparent transparent;\nleft:50%;\nmargin-left:-5px; bottom:-5px; position:absolute; }\n\n/*HOWARD TAFT*/\n.eg-howardtaft-wrapper .esg-media-poster{\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\");\n    -webkit-filter: grayscale(0%);\n}\n\n.eg-howardtaft-wrapper:hover .esg-media-poster{\n    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\"); /* Firefox 10+, Firefox on Android */\n    filter: gray; /* IE6-9 */\n    -webkit-filter: grayscale(100%); /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n\n/* WOOCOMMERCE */\n.myportfolio-container .added_to_cart.wc-forward { font-family: \"Open Sans\"; font-size: 13px; color: #fff; margin-top: 10px; }\n\n/* LIGHTBOX */\n.esgbox-title.esgbox-title-outside-wrap { font-size: 15px; font-weight: 700; text-align: center; }\n.esgbox-title.esgbox-title-inside-wrap { padding-bottom: 10px; font-size: 15px; font-weight: 700; text-align: center; }/* HENRY HARRISON */\r\ra.eg-henryharrison-element-1,\ra.eg-henryharrison-element-2 {\r  -webkit-transition: all .4s linear;  \r    -moz-transition: all .4s linear;  \r    -o-transition: all .4s linear;  \r    -ms-transition: all .4s linear;  \r    transition: all .4s linear; \r}\r\r/* JIMMY CARTER */\r.eg-jimmy-carter-element-11 i:before { margin-left:0px; margin-right:0px;}\r\r\r/* HARDING */\r.eg-harding-element-17 { letter-spacing:1px}\r.eg-harding-wrapper .esg-entry-media { overflow:hidden; \r            box-sizing:border-box;\r            -webkit-box-sizing:border-box;\r            -moz-box-sizing:border-box;\r            padding:30px 30px 0px 30px;\r}\r\r.eg-harding-wrapper .esg-media-poster { overflow:hidden; \r            border-radius:50%;\r            -webkit-border-radius:50%;\r            -moz-border-radius:50%;\r}\r\r/*ULYSSES S GRANT */\r.eg-ulysses-s-grant-wrapper .esg-entry-media { overflow:hidden; \r            box-sizing:border-box;\r            -webkit-box-sizing:border-box;\r            -moz-box-sizing:border-box;\r            padding:30px 30px 0px 30px;\r}\r\r.eg-ulysses-s-grant-wrapper .esg-media-poster { overflow:hidden; \r            border-radius:50%;\r            -webkit-border-radius:50%;\r            -moz-border-radius:50%;\r}\r\r/*RICHARD NIXON */\r.eg-richard-nixon-wrapper .esg-entry-media { overflow:hidden; \r            box-sizing:border-box;\r            -webkit-box-sizing:border-box;\r            -moz-box-sizing:border-box;\r            padding:30px 30px 0px 30px;\r}\r\r.eg-richard-nixon-wrapper .esg-media-poster { overflow:hidden; \r            border-radius:50%;\r            -webkit-border-radius:50%;\r            -moz-border-radius:50%;\r}\r\r\r/* HERBERT HOOVER */\r.eg-herbert-hoover-wrapper .esg-media-poster{\r    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\"); /* Firefox 10+, Firefox on Android */\r    filter: gray; /* IE6-9 */\r    -webkit-filter: grayscale(100%); /* Chrome 19+, Safari 6+, Safari 6+ iOS */\r}\r\r.eg-herbert-hoover-wrapper:hover .esg-media-poster{\r    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\");\r    -webkit-filter: grayscale(0%);}\r\r\r/* JOOHNSON */\r.eg-lyndon-johnson-wrapper .esg-media-poster{\r    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\"); /* Firefox 10+, Firefox on Android */\r    filter: gray; /* IE6-9 */\r    -webkit-filter: grayscale(100%); /* Chrome 19+, Safari 6+, Safari 6+ iOS */\r}\r\r.eg-lyndon-johnson-wrapper:hover .esg-media-poster{\r    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\");\r    -webkit-filter: grayscale(0%);}\r\r\r/*RONALD REAGAN*/\r.esg-overlay.eg-ronald-reagan-container {background: -moz-linear-gradient(top, rgba(0,0,0,0) 50%, rgba(0,0,0,0.83) 99%, rgba(0,0,0,0.85) 100%); /* FF3.6+ */\rbackground: -webkit-gradient(linear, left top, left bottom, color-stop(50%,rgba(0,0,0,0)), color-stop(99%,rgba(0,0,0,0.83)), color-stop(100%,rgba(0,0,0,0.85))); /* Chrome,Safari4+ */\rbackground: -webkit-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* Chrome10+,Safari5.1+ */\rbackground: -o-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* Opera 11.10+ */\rbackground: -ms-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* IE10+ */\rbackground: linear-gradient(to bottom, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* W3C */\rfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#00000000\', endColorstr=\'#d9000000\',GradientType=0 ); /* IE6-9 */}\r\r/*GEORGE BUSH*/\r.eg-georgebush-wrapper .esg-entry-cover {background: -moz-linear-gradient(top, rgba(0,0,0,0) 50%, rgba(0,0,0,0.83) 99%, rgba(0,0,0,0.85) 100%); /* FF3.6+ */\rbackground: -webkit-gradient(linear, left top, left bottom, color-stop(50%,rgba(0,0,0,0)), color-stop(99%,rgba(0,0,0,0.83)), color-stop(100%,rgba(0,0,0,0.85))); /* Chrome,Safari4+ */\rbackground: -webkit-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* Chrome10+,Safari5.1+ */\rbackground: -o-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* Opera 11.10+ */\rbackground: -ms-linear-gradient(top, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* IE10+ */\rbackground: linear-gradient(to bottom, rgba(0,0,0,0) 50%,rgba(0,0,0,0.83) 99%,rgba(0,0,0,0.85) 100%); /* W3C */\rfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#00000000\', endColorstr=\'#d9000000\',GradientType=0 ); /* IE6-9 */}\r\r/*GEORGE BUSH\r.eg-georgebush-wrapper .esg-entry-cover { background: rgba(0,0,0,0.5);}*/\r\r/*JEFFERSON*/\r.eg-jefferson-wrapper { -webkit-border-radius: 5px !important; -moz-border-radius: 5px !important; border-radius: 5px !important; -webkit-mask-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAA5JREFUeNpiYGBgAAgwAAAEAAGbA+oJAAAAAElFTkSuQmCC) !important; }\r\r/*MONROE*/\r.eg-monroe-element-1 { text-shadow: 0px 1px 3px rgba(0, 0, 0, 0.1); }\r\r/*LYNDON JOHNSON*/\r.eg-lyndon-johnson-wrapper .esg-entry-cover { background: -moz-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%, rgba(18,18,18,0) 96%, rgba(19,19,19,0) 100%); /* FF3.6+ */\rbackground: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,rgba(0,0,0,0.35)), color-stop(96%,rgba(18,18,18,0)), color-stop(100%,rgba(19,19,19,0))); /* Chrome,Safari4+ */\rbackground: -webkit-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* Chrome10+,Safari5.1+ */\rbackground: -o-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* Opera 12+ */\rbackground: -ms-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* IE10+ */\rbackground: radial-gradient(ellipse at center,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* W3C */\rfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#59000000\', endColorstr=\'#00131313\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r }\r\r/*WILBERT*/\r.eg-wilbert-wrapper .esg-entry-cover { background: -moz-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%, rgba(18,18,18,0) 96%, rgba(19,19,19,0) 100%); /* FF3.6+ */\rbackground: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%,rgba(0,0,0,0.35)), color-stop(96%,rgba(18,18,18,0)), color-stop(100%,rgba(19,19,19,0))); /* Chrome,Safari4+ */\rbackground: -webkit-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* Chrome10+,Safari5.1+ */\rbackground: -o-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* Opera 12+ */\rbackground: -ms-radial-gradient(center, ellipse cover,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* IE10+ */\rbackground: radial-gradient(ellipse at center,  rgba(0,0,0,0.35) 0%,rgba(18,18,18,0) 96%,rgba(19,19,19,0) 100%); /* W3C */\rfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#59000000\', endColorstr=\'#00131313\',GradientType=1 ); /* IE6-9 fallback on horizontal gradient */\r }\r.eg-wilbert-wrapper .esg-media-poster{\r  -webkit-transition: 0.4s ease-in-out;\r    -moz-transition:  0.4s ease-in-out;\r    -o-transition:  0.4s ease-in-out;\r    transition:  0.4s ease-in-out;\r    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\"); /* Firefox 10+, Firefox on Android */\r    filter: gray; /* IE6-9 */\r    -webkit-filter: grayscale(100%); /* Chrome 19+, Safari 6+, Safari 6+ iOS */\r}\r\r.eg-wilbert-wrapper:hover .esg-media-poster{\r    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\");\r    -webkit-filter: grayscale(0%);}\r\r/*PHILLIE*/\r.eg-phillie-element-3:after { \rcontent:\" \";\rwidth: 0px;\rheight: 0px;\rborder-style: solid;\rborder-width: 5px 5px 0 5px;\rborder-color: #000 transparent transparent transparent;\rleft:50%;\rmargin-left:-5px; bottom:-5px; position:absolute; }\r\r/*HOWARD TAFT*/\r.eg-howardtaft-wrapper .esg-media-poster{\r    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\");\r    -webkit-filter: grayscale(0%);\r}\r\r.eg-howardtaft-wrapper:hover .esg-media-poster{\r    filter: url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\"); /* Firefox 10+, Firefox on Android */\r    filter: gray; /* IE6-9 */\r    -webkit-filter: grayscale(100%); /* Chrome 19+, Safari 6+, Safari 6+ iOS */\r}\r\r/* WOOCOMMERCE */\r.myportfolio-container .added_to_cart.wc-forward { font-family: \"Open Sans\"; font-size: 13px; color: #fff; margin-top: 10px; }\r\r/* LIGHTBOX */\r.esgbox-title.esgbox-title-outside-wrap { font-size: 15px; font-weight: 700; text-align: center; }\r.esgbox-title.esgbox-title-inside-wrap { padding-bottom: 10px; font-size: 15px; font-weight: 700; text-align: center; }', 'yes'),
(205, 'tp-google-fonts', 'a:0:{}', 'yes'),
(206, 'galogin', 'a:11:{s:11:\"ga_clientid\";s:72:\"413735144502-tae9aomhusaaebeclm7g2chsgskbiv1c.apps.googleusercontent.com\";s:15:\"ga_clientsecret\";s:24:\"pGEkVU4d9yJ15u5M2TeHebwk\";s:24:\"ga_ms_usesubsitecallback\";b:0;s:20:\"ga_force_permissions\";b:0;s:13:\"ga_auto_login\";b:0;s:12:\"ga_poweredby\";b:0;s:13:\"ga_rememberme\";b:0;s:23:\"btn_google_signin_image\";s:17:\"dark-normal light\";s:18:\"ga_loginbuttontext\";s:0:\"\";s:14:\"ga_domainadmin\";s:0:\"\";s:10:\"ga_version\";s:5:\"3.4.3\";}', 'no'),
(207, 'revslider_servers', 'a:7:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-b.tools\";i:3;s:16:\"themepunch.tools\";i:4;s:22:\"themepunch-ext-a.tools\";i:5;s:22:\"themepunch-ext-a.tools\";i:6;s:22:\"themepunch-ext-a.tools\";}', 'yes'),
(208, 'revslider_server_refresh', '1625775628', 'yes'),
(209, 'revslider-update-check-short', '1626174004', 'yes'),
(210, 'revslider-connection', '1', 'yes'),
(211, 'revslider-update-hash', '6ef5c623c8f57dda06187fd43b17c057', 'yes'),
(212, 'revslider-latest-version', '6.5.4', 'yes'),
(213, 'revslider-stable-version', '4.2.0', 'yes'),
(214, 'revslider-notices', 'a:3:{i:0;O:8:\"stdClass\":8:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:316:\"<div style=\"display: block; background-color: #1C0950; text-align: \ncenter;\"><a \nhref=\"https://mailchi.mp/sliderrevolution/the-update-your-website-deserves\"\n target=\"_blank\"><img alt=\"wow\" src=\"//updates.themepunch-ext-b.tools/banners/6411_banner.jpg\" width=\"960\" height=\"250\" style=\"margin-bottom: -5px;\"></a></div>\";s:4:\"code\";s:12:\"TPRSV6411-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":8:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:485:\"<div style=\"display: block; background: linear-gradient(90deg, rgb(247, 52, 94) 0%, rgb(247, 52, 94) 25%, rgb(0, 206, 171) 75%, rgb(0, 206, 171) 100%); text-align: \ncenter;\"><a \nhref=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=everyone&utm_content=summersale21\"\n target=\"_blank\"><img alt=\"summersale\" src=\"//updates.themepunch-ext-b.tools/banners/summersale.jpg\" width=\"960\" height=\"250\" style=\"margin-bottom: -5px;\"></a></div>\";s:4:\"code\";s:11:\"TPRSV652-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":8:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:551:\"<div style=\"display: block; background: #fff; text-align: center; height: 250px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 960px; height: 250px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"https://www.sliderrevolution.com/wp-content/uploads/2021/07/adminpremiumvid4.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPRSV654-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"additional\";a:0:{}}}', 'yes'),
(215, 'revslider-additions', 'O:8:\"stdClass\":1:{s:7:\"selling\";b:1;}', 'yes'),
(216, 'rs-addons-counter', '31', 'yes');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(217, 'revslider-addons', 'O:8:\"stdClass\":31:{s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"2.1.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.png\";s:6:\"button\";s:0:\"\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.2.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_lottie.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}}}', 'yes'),
(218, 'revslider-library-check', '1625775628', 'yes'),
(219, 'revslider-library-hash', 'dae3de1eb57eeeee008b70e9a23844b5', 'yes');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(220, 'rs-library', 'a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(221, 'revslider-templates-check', '1626174005', 'yes'),
(222, 'revslider-templates-hash', 'e537c10aace40687f65a52b2be613e5b', 'yes'),
(223, 'rs-templates-new', '', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(224, 'rs-templates', 'a:3:{s:4:\"hash\";s:32:\"634c3fde900600c3052d5786a36960a1\";s:6:\"slider\";a:510:{i:0;a:22:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:22:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:22:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:22:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:22:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:22:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:413:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:22:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:22:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:22:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:22:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:22:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:22:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:22:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:22:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:22:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:22:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:22:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:22:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:22:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:22:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:22:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:22:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:22:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:22:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:22:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:22:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:22:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:22:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:22:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:22:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:22:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:22:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:22:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:22:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:22:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:22:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:22:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:22:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:22:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:22:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:495:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:22:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:22:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:22:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:22:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:22:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:22:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:22:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:22:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:22:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:22:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:22:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:22:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:22:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:22:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:22:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:22:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:22:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:22:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:22:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:22:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:22:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:22:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:22:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:22:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:22:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:22:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:22:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:25:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:25:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:25:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:25:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:25:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:25:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:25:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:25:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:25:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:25:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:25:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:25:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:25:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:25:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:25:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:25:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:22:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:22:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:22:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:22:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:25:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:25:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:25:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:25:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:25:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:25:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:25:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:25:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:22:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:22:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:25:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:25:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:25:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:25:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:25:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:22:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:22:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:22:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:25:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:25:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:25:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:25:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:22:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:22:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:25:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:25:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:25:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:25:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:25:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:25:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:25:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:25:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:25:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:120;a:25:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:121;a:25:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:25:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:25:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:25:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:25:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:25:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:127;a:25:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:128;a:25:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:129;a:25:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:130;a:25:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:542:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:131;a:22:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:317:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:22:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:22:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:25:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:135;a:22:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:22:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:442:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:22:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:22:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:22:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:387:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:140;a:22:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:22:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:142;a:22:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"{\"1\":{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}}\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:143;a:22:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-carousel-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:22:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/filmstrip-add-on-slider/ \";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:180:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:145;a:22:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/space-opera-presentation/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:22:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/website-intro-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:22:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/minimal-mask-showcase/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:22:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:22:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:150;a:22:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:151;a:25:{s:2:\"id\";s:3:\"154\";s:5:\"title\";s:26:\"GoodNews One-Pager Package\";s:5:\"alias\";s:26:\"goodnews-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"goodnews-one-pager-package\";s:3:\"img\";s:44:\"packages/templatepack_goodnews_one_pager.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:4:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:4:\"hero\";i:3;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:152;a:25:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:153;a:25:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:154;a:25:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:155;a:25:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:156;a:25:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.4\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:157;a:25:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:158;a:25:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:159;a:25:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:160;a:25:{s:2:\"id\";s:3:\"163\";s:5:\"title\";s:29:\"GoodNews Content Page Package\";s:5:\"alias\";s:29:\"goodnews-content-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"goodnews-content-page-package\";s:3:\"img\";s:55:\"packages/templatepack_goodnews_content_page_package.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:161;a:25:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:162;a:25:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:163;a:25:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:164;a:25:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:165;a:25:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:166;a:22:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/before-after-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:167;a:22:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:22:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/overexposure-transition-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:22:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/parallax-scroll/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:170;a:25:{s:2:\"id\";s:3:\"173\";s:5:\"title\";s:24:\"TechCo One-Pager Package\";s:5:\"alias\";s:24:\"techco-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:24:\"techco-one-pager-package\";s:3:\"img\";s:28:\"packages/techco_overview.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:171;a:25:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:172;a:25:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:173;a:25:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:174;a:25:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:175;a:25:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:176;a:25:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Sli