import getService from "../libs/get-service";
import moment from "moment";

var forkBooking = (function () {

    var getDayOpen = function (idRestaurant) {
        return getService('forkBooking', {
            id_restaurant: idRestaurant,
            method: 'reservation_get_available_date_list'
        });
    };

    var getHourOpen = function (idRestaurant, day) {
        return getService('forkBooking', {
            id_restaurant: idRestaurant,
            date: moment(day).format("YYYY-MM-DD"),
            method: 'reservation_get_available_timeslot_list'
        });
    };

    var getGroupAvailibility = function (idRestaurant, datetime) {
        return getService('forkBooking', {
            id_restaurant: idRestaurant,
            datetime: datetime,
            method: 'reservation_get_available_nb_people_list'
        });
    };

    const getSalesTypes = ({ idRestaurant }) => getService("forkBooking", {
      id_restaurant: idRestaurant,
      method: "restaurant_get_sale_type_list"
    });

    var createCustomer = function (idRestaurant, customer) {
        return getService('forkBookingB2B', {
            id_restaurant: idRestaurant,
            method: 'customer_create_update',
            customer_civility: customer.customer_civility,
            customer_email: customer.customer_email,
            customer_first_name: customer.customer_first_name,
            customer_last_name: customer.customer_last_name,
            customer_mobile_phone: customer.customer_mobile_phone,
            customer_is_newsletter: +!!customer.customer_is_newsletter,//API accept only 0 or 1
            customer_locale: JSONendpointSettings.locale
        });
    };

    var createBooking = function (idRestaurant, datetime, count, id_customer, idsaletype) {
        return getService('forkBookingB2B', {
            id_restaurant: idRestaurant,
            method: 'reservation_create',
            datetime: datetime,
            nb_people: count,
            id_sale_type: idsaletype,
            id_customer: id_customer,
            note: 'FROM LBC website'
        });
    };

    return {
        getDayOpen: getDayOpen,
        getHourOpen: getHourOpen,
        getGroupAvailibility: getGroupAvailibility,
        getSalesTypes,
        createCustomer: createCustomer,
        createBooking: createBooking
    };

})();

export default forkBooking;
