// var endpoint = require("../base/json").jsonendpoint;
var ajax = require("./ajax").default;

var useService = (function () {
    "use strict";

    var getEndpoint = function (endpoint) {
        var _JSONendpoint = JSONendpointSettings.uri[endpoint];
        if (!_JSONendpoint) {
            throw new Error('endpoint doesn\'t exist')
        }
        return _JSONendpoint;
    };


    /**
     *
     * @param endpoint {String}
     * @param lang {String}
     * @param value {Object} to be stringify
     * @param timestamp {Number}
     */
    var setLocalStorage = function (endpoint, lang, value, timestamp) {
        localStorage.setItem('service-storage' + lang + endpoint, JSON.stringify(value));
        localStorage.setItem('service-storage' + lang + endpoint + 'timestamp', timestamp);
    };

    var getLocalstorage = function (endpoint, lang) {
        var item = localStorage.getItem('service-storage' + lang + endpoint);
        var timestamp = localStorage.getItem('service-storage' + lang + endpoint + 'timestamp');
        let servicecached = {};
        if (item) {
            servicecached = {data: JSON.parse(item), timestamp: timestamp};
        }
        return servicecached;
    };

    /**
     *
     * @param API_endpoint {string}
     * @param params {object} data sent to the API
     * @param loader {Boolean} display or not the loader
     * @returns {jQuery} ajax
     */
    var init = function (API_endpoint, params, loader) {
        var currentEndpoint = JSONendpointSettings.uri[API_endpoint];
        if (currentEndpoint) {
            var _cachedService = getLocalstorage(API_endpoint, JSONendpointSettings.lang);
            var cachedService = _cachedService.data;
            var timestamp = _cachedService.timestamp;
            var isvalid = cachedService && currentEndpoint.timestamp == timestamp;
            //if (!isvalid) {
                var options = {
                    url: getEndpoint(API_endpoint).url
                };
                options.method = 'get';
                if (currentEndpoint.param) {
                    Object.assign(params, currentEndpoint.param)
                }
                if (currentEndpoint.urlEncode === false) {
                    //convert to string with no url encode
                    params = decodeURIComponent($.param(params));
                }
                options.data = params || {};
                options.success = function (result) {
                    if (currentEndpoint.timestamp) {
                        setLocalStorage(API_endpoint, JSONendpointSettings.lang, result, currentEndpoint.timestamp)
                    }
                };

                return ajax(options, loader)
            /*}
            else {
                var dfd = $.Deferred();
                dfd.resolve(cachedService);
                return dfd.promise();
            }*/
        }
        else {
            throw new Error(`API Service ${API_endpoint} not defined`)
        }
    };
    return init;

})();

export default useService;