var FORM = require('./FORM').default;
class NEWSLETTER {
    constructor($el) {
        var el;

        this.stickyMenu = $('.navbar-default');

        el = $el.get(0);
        this.el = el;
        this.analyticsCall = $el.data("analyticsCall");
        this.analyticsName = $el.data("analyticsName");
        this.analyticsType = $el.data("analyticsType");
        this.formComponent = new FORM(el.querySelector(".newsletter-form"));
        this._setEvents();
        this._fixSticky();
    }

    _onFormSubmit(e) {
        e.preventDefault();
        if (!this.formComponent.validate())
        {
            return;
        }
        digitalData.clic = { name: this.analyticsName, type: this.analyticsType, url: window.location.href };
        _satellite.track(this.analyticsCall);
        $('.newsletter-form').submit();
    }

    _setEvents() {
        this.formComponent.el.addEventListener("submit", this._onFormSubmit.bind(this));
    }

    _fixSticky() {

        var context = this;

        if (Modernizr.touch) {
            $(document).on('focus', 'input', function () {
                // remove Sticky
                context.stickyMenu.unstick();
            }).on('blur', 'input', function () {
                context.stickyMenu.sticky({topSpacing: 0});
            });
        }
    }
}
export default NEWSLETTER;
