class MEA6 {
    constructor($el) {
        var device;

        device = this.getCurrentDevice();
        this.$el = $el;
        this.$carousel = $(".mea6-content");
        this.isFlickity = false;

        if (device !== "desktop" && $(window).width() <= 1024) {
            this.initCarousel();
        }
        this.setEvents();
    }

    debounce(func, wait, immediate = false) {
        var timeout;

        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }

    destroyCarousel() {
        $(".mea6-item").css('left', '0');

        if (this.isFlickity) {
            $(".mea6-item").css('left', '0');
            this.$carousel.flickity('destroy');
            this.isFlickity = false;
            setTimeout(function () {
                $(".mea6-item").css('left', '0');
            }, 1200);
        }
    }

    getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    initCarousel() {
        this.$carousel.flickity({
            wrapAround: true,
            autoPlay: true,
            pauseAutoPlayOnHover: false,
            pageDots: false,
            prevNextButtons: false
        });
        this.isFlickity = true;

        // resume autoplay
        var flkty = this.$carousel.data('flickity');
        this.$carousel.on('settle', function () {
            if (!flkty.player.isPlaying) {
                flkty.player.play();
            }
        })

        //}
    }

    setEvents() {
        $(window).on("resize.MEA6", this.debounce(this.onWindowResize.bind(this), 150));
    }

    onWindowResize() {
        var device;

        device = this.getCurrentDevice();

        if (device === "desktop" || $(window).width() > 1024) {
            this.destroyCarousel();
        }
        else {
            this.initCarousel();
        }
    }
}
export default MEA6;