"use strict";

class MEA1MOV {


    constructor($el) {

        this.$el = $el;
        this.soundActive = false;
        this.soundControl();
        this.setEvents();
    }

    soundControl() {
        var mea1mov = document.getElementById("mea1-video");

        $('.mea1-icon-sound').click(function (){
            var $t = $(this);

            if (this.soundActive === true) {
                mea1mov.muted = true;
                this.soundActive = false;
                $t.removeClass("is-on");
            }
            else {
                mea1mov.muted = false;
                this.soundActive = true;
                $t.addClass("is-on");
            }
        });
    }


    debounce(func, wait, immediate = false) {
        var timeout;

        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }


    setEvents() {
        $(window).on("resize.MEA1MOV", this.debounce(this.onWindowResize.bind(this), 150));
    }


    onWindowResize() {
        $(window).on("resize", function () {
            ($(window).width() <= 1024) ? $("video").each(function () {
                this.pause()
            })
                : $("video").each(function () {
                this.play()
            });
        });
    }
}
export default MEA1MOV;
