class ESPRITBARRIERE {
    constructor($el) {
        this.$el = $el;
        this.device = this.getCurrentDevice();
        if (this.device === 'desktop') this.scrollListener(this.device);
        this.setEvents();
    }

    scrollListener(device) {
        if (device === "desktop") {
            $(window).scroll(function () {
                var s = $(window).scrollTop();
                $('.esprit-barriere-header-background').find('img').css('top', +-s / 4 + 'px');
                $('.esprit-barriere-header-title').css('padding-top', 280 - s / 3 + 'px')
            });
        }
        else {
            $(window).off("scroll");
            $('.esprit-barriere-header-background').css('background-position', ' center center');
            (device === 'tablet') ? $('.esprit-barriere-header-title').css('padding-top', 110)
                : $('.esprit-barriere-header-title').css('padding-top', 160);
        }
    }

    setEvents() {
        $(window).on("resize.ESPRITBARRIERE", this.debounce(this.onWindowResize.bind(this), 150));
    }

    getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    debounce(func, wait, immediate = false) {
        var timeout;
        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }

    onWindowResize() {
        this.device = this.getCurrentDevice();
        this.scrollListener(this.device);
    }
}
export default ESPRITBARRIERE;