<div class="spectacle-filter-container" data-class="SPECTACLEFILTER">

    <!-- Keyworks list (radio) -->
    <script type="text/template" id="spectaclefilteritem">
        <article class="spectacle-list-item">
            <div class="spectacle-list-item-genre">{{genre}}</div>
            <a href="#">
                <div class="spectacle-list-item-picture">
                    <img src="{{poster}}" alt="">
                </div>
                <div class="spectacle-list-item-title">
                    {{title}}
                </div>
                <div class="spectacle-list-item-price">À PARTIR DE <span>{{price}}€</span></div>
            </a>
            <div class="spectacle-list-item-city">{{city}}</div>
            <div class="spectacle-list-item-date">
                <span class="date-single {{classSingleShow}}">Le {{date_from}}</span>
                <span class="date-from {{classMultipleShow}}">Du {{date_from}}</span>
                <span class="date-to {{classMultipleShow}}">Au {{date_to}}</span>
            </div>
            <div class="spectacle-list-item-cta">
                <a href="{{link}}" class="button button-golden-outline-small">DÉCOUVRIR</a>
            </div>
        </article>
    </script>
    <script type="text/template" id="spectaclefilteritem-free">
        <article class="spectacle-list-item">
            <div class="spectacle-list-item-genre">{{genre}}</div>
            <a href="#">
                <div class="spectacle-list-item-picture">
                    <img src="{{poster}}" alt=""/>
                </div>
                <div class="spectacle-list-item-title">
                    {{title}}
                </div>
                <div class="spectacle-list-item-price">Gratuit</div>
            </a>
            <div class="spectacle-list-item-city">{{city}}</div>
            <div class="spectacle-list-item-date">
                <span class="date-single {{classSingleShow}}">Le {{date_from}}</span>
                <span class="date-from {{classMultipleShow}}">Du {{date_from}}</span>
                <span class="date-to {{classMultipleShow}}">Au {{date_to}}</span>
            </div>
            <div class="spectacle-list-item-cta">
                <a href="{{link}}" class="button button-golden-outline-small">Découvrir</a>
            </div>
        </article>
    </script>

    <script type="text/template" id="spectaclefilteritemcalendar">
        <article class="spectacle-list-item spectacle-list-item-calendar">
            <div class="spectacle-list-item-calendar-wrapper">
                <span class="spectacle-list-item-calendar-label-day">{{day}}</span>
                <span class="spectacle-list-item-calendar-day">{{date}}</span>
                <span class="spectacle-list-item-calendar-month">{{month}}</span>
            </div>
			<span class="calendar-triangle calendar-triangle-desktop">
				<img src="img/skin/triangle-right.png" alt=""/>
			</span>
			<span class="calendar-triangle calendar-triangle-mobile">
				<img src="img/skin/triangle-down.png" alt=""/>
			</span>
        </article>
    </script>
    <script type="text/template" id="spectaclefiltergenre">
        <li class="spectacle-filter-keyword-item">
            <input type="checkbox" id="{{genreId}}" name="genre" class="input" value="{{genreId}}" {{ischecked}}>
            <label for="{{genreId}}">{{genreLabel}}</label>
        </li>
    </script>
    <script type="text/template" id="spectaclefiltercities">
        <li class="spectacle-filter-city-item">
            <input type="checkbox" id="{{city}}" name="genre" class="input" value="{{city}}" {{checked}}>
            <label for="{{city}}">{{city}}</label>
        </li>
    </script>
    <script type="text/template" id="spectaclefilterpagination">
        <li class="pagination-item"><a class="{{active}}" href="#{{index}}">{{index}}</a></li>
    </script>
    <script type="text/template" id="spectaclefilterpaginationbreaker">
        <li class="pagination-item">…</li>
    </script>
    <script type="text/template" id="spectaclefilterselecteddate">
        <div class="spectacle-filter-selected-item-label">
            <span class="label"><span class="light">DATE</span> : ${{min}} - ${{max}}</span>
            <a href="#" class="close js-reset-filter" data-filter="date"></a>
        </div>
    </script>
    <script type="text/template" id="spectaclefilterselectedprice">
        <div class="spectacle-filter-selected-item-label">
            <span class="label"><span class="light">PRICE</span> : {{min}}€ - {{max}}€</span>
            <a href="#" class="close js-reset-filter" data-filter="price"></a>
        </div>
    </script>
    <script type="text/template" id="spectaclefilterselectedprice-free">
        <div class="spectacle-filter-selected-item-label">
            <span class="label"><span class="light">PRICE</span> : {{min}} - {{max}}€</span>
            <a href="#" class="close js-reset-filter" data-filter="price"></a>
        </div>
    </script>
    <script type="text/template" id="spectaclefilterselectedgenre">
        <div class="spectacle-filter-selected-item-label">
            <span class="label"><span class="light">GENRE</span> : {{genre}}</span>
            <a href="#" class="close js-reset-filter" data-filter="genre"></a>
        </div>
    </script>
    <script type="text/template" id="spectaclefilterselectedcities">
        <div class="spectacle-filter-selected-item-label">
            <span class="label"><span class="light">VILLE</span> : {{cities}}</span>
            <a href="#" class="close js-reset-filter" data-filter="cities"></a>
        </div>
    </script>

    <?php if (isset($_GET['prod'])) : // used concatened and minified scripts ?>
        <script>
            currentCity="",showsCurrency="€",showsCountry="FRANCE";
        </script>
    <?php else : ?>
        <script>
            //                currentCity = 'Enghien-les-Bains';
            currentCity = '';
            showsCurrency = "€";
            showsCountry = "FRANCE";
        </script>
    <?php endif ?>

    <section class="spectacle-filter-keywords-list-wrapper">
        <ul class="spectacle-filter-keywords-list" id="spectaclefiltergenrelist">
            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="allgenre" name="genre" class="input" value="allgenre">
                <label for="allgenre">TOUS LES GENRES</label>
                <a href="?genre=allgenre" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="magie" name="genre" class="input" value="magie" >
                <label for="magie">Magie</label>
                <a href="?genre=magie" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="concert" name="genre" class="input" value="concert">
                <label for="concert">concert</label>
                <a href="?genre=concert" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="danse" name="genre" class="input" value="danse">
                <label for="danse">Danse</label>
                <a href="?genre=danse" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="theatre" name="genre" class="input" value="theatre">
                <label for="theatre">Théâtre</label>
                <a href="?genre=theatre" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="humour" name="genre" class="input" value="humour">
                <label for="humour">Humour</label>
                <a href="?genre=humour" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="classique" name="genre" class="input" value="classique">
                <label for="classique">classique / lyrique</label>
                <a href="?genre=classique" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="dinerspectacle" name="genre" class="input" value="dinerspectacle">
                <label for="dinerspectacle">Dîner Spectacle</label>
                <a href="?genre=dinerspectacle" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="animation" name="genre" class="input" value="animation">
                <label for="animation">Animation</label>
                <a href="?genre=animation" class="link-hidden"></a>
            </li>

            <li class="spectacle-filter-keyword-item">
                <input type="checkbox" id="spmusical" name="genre" class="input" value="spmusical">
                <label for="spmusical">Spectacle Musical / revue</label>
                <a href="?genre=spmusical" class="link-hidden"></a>
            </li>
        </ul>
    </section>

    <!-- Search toolbar -->

    <div class="spectacle-filter-search-toolbar spectacle-filter-search-toolbar-national">
        <div class="spectacle-filter-search-toolbar-menu">
            <div class="spectacle-filter-search-toolbar-menu-title">FILTRER PAR :</div>
            <div class="spectacle-filter-search-toolbar-menu-date">
                <a class="date-filter active JS_toggler" data-toggler-id="date" data-toggler-group="display-filter"
                   href="#">DATE</a>
            </div>
            <div class="spectacle-filter-search-toolbar-menu-price">
                <a class="price-filter JS_toggler" data-toggler-id="price" data-toggler-group="display-filter" href="#">PRIX</a>
            </div>
            <div class="spectacle-filter-search-toolbar-menu-city">
                <a class="city-filter JS_toggler" data-toggler-id="city" data-toggler-group="display-filter" href="#">VILLE</a>
            </div>
        </div>
        <div class="spectacle-filter-search-toolbar-input">
            <input class="form-search js-filter-search" type="text" name="search" placeholder="RECHERCHE"/>
			<span class="icon-svg icon-search">
				<svg>
                    <use xmlns:xlink="http://www.w3.org/1999/xlink"
                         xlink:href="img/sprites/sprite.svg#icon-search"></use>
                </svg>
			</span>
        </div>
    </div>


    <!-- range container -->

    <!--<div class="spectacle-filter-range">


    </div>-->
    <div class="spectacle-filter-city-list-wrapper">

        <div class="spectacle-filter-date-range active JS_item_toggler" data-toggler-group-no-close="true"
             data-toggler-group="display-filter"
             data-toggler-itemid="date">
            <span id="date-range" data-date-min="2017/03" data-date-max="2018/02"></span>
            <input type="hidden" name="datefrom" value="2017/04"/>
            <input type="hidden" name="dateto" value="2018/01"/>
        </div>

        <div class="spectacle-filter-price-range JS_item_toggler" data-toggler-group-no-close="true"
             data-toggler-group="display-filter"
             data-toggler-itemid="price">
            <span id="price-range" data-price-min="0" data-price-max="179" data-price-currency="€"></span>
            <input type="hidden" name="pricefrom" value="0"/>
            <input type="hidden" name="priceto" value="170"/>
        </div>
        <ul class="spectacle-filter-city-list JS_item_toggler" data-toggler-group="display-filter" data-toggler-group-no-close="true" data-toggler-itemid="city" id="spectaclefiltercitieslist">
            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Le Touquet Paris Plage" name="cities" class="input" value="Le Touquet Paris Plage">
                <label for="Le Touquet Paris Plage">Le Touquet Paris Plage</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Deauville" name="cities" class="input" value="Deauville" >
                <label for="Deauville">Deauville</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Cap d'Agde" name="cities" class="input" value="Cap d'Agde">
                <label for="Cap d'Agde">Cap d'Agde</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Ribeauvillé" name="cities" class="input" value="Ribeauvillé">
                <label for="Ribeauvillé">Ribeauvillé</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Niederbronn-les-Bains" name="cities" class="input" value="Niederbronn-les-Bains">
                <label for="Niederbronn-les-Bains">Niederbronn-les-Bains</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Blotzheim" name="cities" class="input" value="Blotzheim">
                <label for="Blotzheim">Blotzheim</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Menton" name="cities" class="input" value="Menton">
                <label for="Menton">Menton</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Royan" name="cities" class="input" value="Royan">
                <label for="Royan">Royan</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Lille" name="cities" class="input" value="Lille">
                <label for="Lille">Lille</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Bénodet" name="cities" class="input" value="Bénodet">
                <label for="Bénodet">Bénodet</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Nice" name="cities" class="input" value="Nice">
                <label for="Nice">Nice</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Enghien-les-Bains" name="cities" class="input" value="Enghien-les-Bains">
                <label for="Enghien-les-Bains">Enghien-les-Bains</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Carry-le-Rouet" name="cities" class="input" value="Carry-le-Rouet">
                <label for="Carry-le-Rouet">Carry-le-Rouet</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Cassis" name="cities" class="input" value="Cassis">
                <label for="Cassis">Cassis</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Trouville-sur-mer" name="cities" class="input" value="Trouville-sur-mer">
                <label for="Trouville-sur-mer">Trouville-sur-mer</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="La Rochelle" name="cities" class="input" value="La Rochelle">
                <label for="La Rochelle">La Rochelle</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Bordeaux" name="cities" class="input" value="Bordeaux">
                <label for="Bordeaux">Bordeaux</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="La Baule" name="cities" class="input" value="La Baule">
                <label for="La Baule">La Baule</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Ouistreham" name="cities" class="input" value="Ouistreham">
                <label for="Ouistreham">Ouistreham</label>
            </li>

            <li class="spectacle-filter-city-item">
                <input type="checkbox" id="Toulouse" name="cities" class="input" value="Toulouse">
                <label for="Toulouse">Toulouse</label>
            </li>
        </ul>
    </div>

    <!-- filter selected -->

    <ul class="spectacle-filter-selected-list">
        <li class="spectacle-filter-selected-item js-filter-selected js-filter-date">
            <div class="spectacle-filter-selected-item-label">
                <span class="label"><span class="light">DATE</span> : {{min}} - {{max}}</span>
                <a href="#" class="close"></a>
            </div>
        </li>
        <li class="spectacle-filter-selected-item js-filter-selected js-filter-price">
            <div class="spectacle-filter-selected-item-label">
                <span class="label"><span class="light">PRIX</span> : {{min}} - {{max}}</span>
                <a href="#" class="close"></a>
            </div>
        </li>
        <li class="spectacle-filter-selected-item js-filter-selected js-filter-genre">
            <div class="spectacle-filter-selected-item-label">
                <span class="label"><span class="light">GENRE</span> : {{genre}}</span>
                <a href="#" class="close"></a>
            </div>
        </li>
        <li class="spectacle-filter-selected-item js-filter-selected js-filter-cities">
            <div class="spectacle-filter-selected-item-label">
                <span class="label"><span class="light">VILLE</span> : {{city}}</span>
                <a href="#" class="close"></a>
            </div>
        </li>
    </ul>

</div>
