<section class="c-tournaments-filter" data-component="tournamentsFilter">
    <form class="c-tournaments-filter-minimized">
        <div class="c-tournaments-filter-minimized-container">
            <div class="c-tournaments-filter-minimized-title">FILTRER PAR</div>
            <div class="c-tournaments-filter-minimized-content" v-bind:class="{'is-expanded': isExpanded}">
                <section class="c-tournaments-filter-minimized-section">
                    <div class="c-tournaments-filter-minimized-section-title">
                        <div class="c-tournaments-filter-minimized-section-title-text">BUY IN</div>
                    </div>
                    <div class="c-tournaments-filter-minimized-section-content">
                        <div class="c-tournaments-filter-grid">
                            <label class="c-tournaments-filter-grid-item c-tournaments-filter-checkbox">
                                <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                <span class="c-tournaments-filter-checkbox-ui">
                                    <span class="c-tournaments-filter-checkbox-ui-label">- DE <strong>100 €</strong></span>
                                </span>
                            </label>
                            <label class="c-tournaments-filter-grid-item c-tournaments-filter-checkbox">
                                <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                <span class="c-tournaments-filter-checkbox-ui">
                                    <span class="c-tournaments-filter-checkbox-ui-label"><strong>100 €</strong> À <strong>500 €</strong></span>
                                </span>
                            </label>
                            <label class="c-tournaments-filter-grid-item c-tournaments-filter-checkbox">
                                <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                <span class="c-tournaments-filter-checkbox-ui">
                                    <span class="c-tournaments-filter-checkbox-ui-label"><strong>500 €</strong> À <strong>1 000 €</strong></span>
                                </span>
                            </label>
                            <label class="c-tournaments-filter-grid-item c-tournaments-filter-checkbox">
                                <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                <span class="c-tournaments-filter-checkbox-ui">
                                    <span class="c-tournaments-filter-checkbox-ui-label">+ DE <strong>1 000 €</strong></span>
                                </span>
                            </label>
                        </div>
                    </div>
                </section>
                <section class="c-tournaments-filter-minimized-section">
                    <div class="c-tournaments-filter-minimized-section-title">
                        <div class="c-tournaments-filter-minimized-section-title-text">DATE</div>
                    </div>
                    <div class="c-tournaments-filter-minimized-section-content">
                        <div class="c-tournaments-filter-grid">
                            <div class="c-tournaments-filter-grid-item">
                                <div class="c-tournaments-filter-date" v-bind:class="{'is-selected': isStartDateSelected}">
                                    <div class="c-tournaments-filter-date-label">À PARTIR DU :</div>
                                    <label class="c-tournaments-filter-date-button">
                                        <input class="c-tournaments-filter-date-button-input" name="startDate" type="date" v-model="startDate">
                                        <span class="c-tournaments-filter-date-button-ui">
                                            <span class="c-tournaments-filter-date-button-ui-icon">
                                                <svg>
                                                    <use xlink:href="img/sprites/sprite.svg#icon-calendar"/>
                                                </svg>
                                            </span>
                                            <span class="c-tournaments-filter-date-button-ui-label" v-if="isStartDateSelected">
                                                <span class="c-tournaments-filter-date-button-ui-label-day">{{ startDate | getDayOfWeek }}</span><br>
                                                <span class="c-tournaments-filter-date-button-ui-label-date">{{ startDate | getFormattedDate }}</span>
                                            </span>
                                            <span class="c-tournaments-filter-date-button-ui-label" v-if="!isStartDateSelected">
                                                <span class="c-tournaments-filter-date-button-ui-label-day">-</span>
                                            </span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                            <div class="c-tournaments-filter-grid-item">
                                <div class="c-tournaments-filter-date" v-bind:class="{'is-selected': isEndDateSelected}">
                                    <div class="c-tournaments-filter-date-label">JUSQU'AU :</div>
                                    <label class="c-tournaments-filter-date-button">
                                        <input class="c-tournaments-filter-date-button-input" name="endDate" type="date" v-model="endDate">
                                        <span class="c-tournaments-filter-date-button-ui">
                                            <span class="c-tournaments-filter-date-button-ui-icon">
                                                <svg>
                                                    <use xlink:href="img/sprites/sprite.svg#icon-calendar"/>
                                                </svg>
                                            </span>
                                            <span class="c-tournaments-filter-date-button-ui-label" v-if="isEndDateSelected">
                                                <span class="c-tournaments-filter-date-button-ui-label-day">{{ endDate | getDayOfWeek }}</span><br>
                                                <span class="c-tournaments-filter-date-button-ui-label-date">{{ endDate | getFormattedDate }}</span>
                                            </span>
                                            <span class="c-tournaments-filter-date-button-ui-label" v-if="!isEndDateSelected">
                                                <span class="c-tournaments-filter-date-button-ui-label-day">-</span>
                                            </span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <section class="c-tournaments-filter-minimized-section">
                    <div class="c-tournaments-filter-minimized-section-title">
                        <div class="c-tournaments-filter-minimized-section-title-text">TYPES</div>
                    </div>
                    <div class="c-tournaments-filter-minimized-section-content">
                        <div class="c-tournaments-filter-grid">
                            <div class="c-tournaments-filter-grid-item">
                                <label class="c-tournaments-filter-checkbox">
                                    <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                    <span class="c-tournaments-filter-checkbox-ui">
                                        <span class="c-tournaments-filter-checkbox-ui-label">
                                            <strong>CASH</strong>
                                        </span>
                                    </span>
                                </label>
                            </div>
                            <div class="c-tournaments-filter-grid-item">
                                <label class="c-tournaments-filter-checkbox">
                                    <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                    <span class="c-tournaments-filter-checkbox-ui">
                                        <span class="c-tournaments-filter-checkbox-ui-label">
                                            <strong>SATELLITE</strong>
                                        </span>
                                    </span>
                                </label>
                            </div>
                            <div class="c-tournaments-filter-grid-item">
                                <label class="c-tournaments-filter-checkbox">
                                    <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                    <span class="c-tournaments-filter-checkbox-ui">
                                        <span class="c-tournaments-filter-checkbox-ui-label">
                                            <strong>SINGLE RE ENTRY</strong>
                                        </span>
                                    </span>
                                </label>
                            </div>
                            <div class="c-tournaments-filter-grid-item">
                                <label class="c-tournaments-filter-checkbox">
                                    <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                    <span class="c-tournaments-filter-checkbox-ui">
                                        <span class="c-tournaments-filter-checkbox-ui-label">
                                            <strong>KNOCKOUT</strong>
                                        </span>
                                    </span>
                                </label>
                            </div>
                            <div class="c-tournaments-filter-grid-item">
                                <label class="c-tournaments-filter-checkbox">
                                    <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                    <span class="c-tournaments-filter-checkbox-ui">
                                        <span class="c-tournaments-filter-checkbox-ui-label">
                                            <strong>SURVIVOR</strong>
                                        </span>
                                    </span>
                                </label>
                            </div>
                            <div class="c-tournaments-filter-grid-item">
                                <label class="c-tournaments-filter-checkbox">
                                    <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                    <span class="c-tournaments-filter-checkbox-ui">
                                        <span class="c-tournaments-filter-checkbox-ui-label">
                                            <strong>HIGHROLLER</strong>
                                        </span>
                                    </span>
                                </label>
                            </div>
                            <div class="c-tournaments-filter-grid-item">
                                <label class="c-tournaments-filter-checkbox">
                                    <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                    <span class="c-tournaments-filter-checkbox-ui">
                                        <span class="c-tournaments-filter-checkbox-ui-label">
                                            <strong>BIG BLIND ANTE</strong>
                                        </span>
                                    </span>
                                </label>
                            </div>
                            <div class="c-tournaments-filter-grid-item">
                                <label class="c-tournaments-filter-checkbox">
                                    <input class="c-tournaments-filter-checkbox-input" type="checkbox">
                                    <span class="c-tournaments-filter-checkbox-ui">
                                        <span class="c-tournaments-filter-checkbox-ui-label">
                                            <strong>SIT N GO</strong>
                                        </span>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>
                </section>
                <section class="c-tournaments-filter-minimized-section">
                    <button class="c-tournaments-filter-minimized-submit" type="submit">VALIDER</button>
                </section>
            </div>
            <button class="c-tournaments-filter-minimized-button" type="button" v-bind:class="{'is-expanded': isExpanded}" v-on:click="toggle">
                <span class="c-tournaments-filter-minimized-button-icon">
                    <svg>
                        <use xlink:href="img/sprites/sprite.svg#arrow-bottom"/>
                    </svg>
                </span>
            </button>
        </div>
    </form>
    <form class="c-tournaments-filter-extended">
        <nav class="c-tournaments-filter-extended-nav">
            <div
                class="c-tournaments-filter-extended-nav-item c-tournaments-filter-extended-nav-item--label">FILTER PAR :
            </div>
            <button class="c-tournaments-filter-extended-nav-item c-tournaments-filter-extended-nav-button" type="button" v-bind:class="{'is-active': isMenuSelected('buy-in')}" v-on:click="selectMenu('buy-in')">BUY IN</button>
            <button class="c-tournaments-filter-extended-nav-item c-tournaments-filter-extended-nav-button" type="button" v-bind:class="{'is-active': isMenuSelected('dates')}" v-on:click="selectMenu('dates')">DATES</button>
            <button class="c-tournaments-filter-extended-nav-item c-tournaments-filter-extended-nav-button" type="button" v-bind:class="{'is-active': isMenuSelected('types')}" v-on:click="selectMenu('types')">GENRES</button>
        </nav>
        <section class="c-tournaments-filter-extended-menu" v-bind:class="{'is-expanded': isMenuExpanded}">
            <div class="c-tournaments-filter-extended-menu-content">
                <section class="c-tournaments-filter-grid c-tournaments-filter-grid--buy-in" v-show="isMenuSelected('buy-in')">
                    <label class="c-tournaments-filter-grid-item c-tournaments-filter-checkbox">
                        <input class="c-tournaments-filter-checkbox-input" name="buyIns" value="1" type="checkbox" v-model="selectedBuyIns">
                        <span class="c-tournaments-filter-checkbox-ui">
                            <span class="c-tournaments-filter-checkbox-ui-label" data-type="buyIn" data-value="1">- DE <strong>100 €</strong></span>
                        </span>
                    </label>
                    <label class="c-tournaments-filter-grid-item c-tournaments-filter-checkbox">
                        <input class="c-tournaments-filter-checkbox-input" name="buyIns" value="2" type="checkbox" v-model="selectedBuyIns">
                        <span class="c-tournaments-filter-checkbox-ui">
                            <span class="c-tournaments-filter-checkbox-ui-label" data-type="buyIn" data-value="2"><strong>100 €</strong> À <strong>500 €</strong></span>
                        </span>
                    </label>
                    <label class="c-tournaments-filter-grid-item c-tournaments-filter-checkbox">
                        <input class="c-tournaments-filter-checkbox-input" name="buyIns" value="3" type="checkbox" v-model="selectedBuyIns">
                        <span class="c-tournaments-filter-checkbox-ui">
                            <span class="c-tournaments-filter-checkbox-ui-label" data-type="buyIn" data-value="3"><strong>500 €</strong> À <strong>1 000 €</strong></span>
                        </span>
                    </label>
                    <label class="c-tournaments-filter-grid-item c-tournaments-filter-checkbox">
                        <input class="c-tournaments-filter-checkbox-input" name="buyIns" value="4" type="checkbox" v-model="selectedBuyIns">
                        <span class="c-tournaments-filter-checkbox-ui">
                            <span class="c-tournaments-filter-checkbox-ui-label" data-type="buyIn" data-value="4">+ DE <strong>1 000 €</strong></span>
                        </span>
                    </label>
                </section>
                <section class="c-tournaments-filter-grid c-tournaments-filter-grid--dates" v-show="isMenuSelected('dates')">
                    <div class="c-tournaments-filter-grid-item">
                        <div class="c-tournaments-filter-date-label">À PARTIR DU :</div>
                    </div>
                    <div class="c-tournaments-filter-grid-item c-tournaments-filter-date" v-bind:class="{'is-selected': isStartDateSelected}">
                        <label class="c-tournaments-filter-date-button">
                            <input class="c-tournaments-filter-date-button-input" name="startDate" type="date" v-model="startDate" ref="startDatePickerInput">
                            <span class="c-tournaments-filter-date-button-ui">
                                <span class="c-tournaments-filter-date-button-ui-icon">
                                    <svg>
                                        <use xlink:href="img/sprites/sprite.svg#icon-calendar"/>
                                    </svg>
                                </span>
                                <span class="c-tournaments-filter-date-button-ui-label" v-if="isStartDateSelected">
                                    <span class="c-tournaments-filter-date-button-ui-label-day">{{ startDate | getDayOfWeek }}</span><br>
                                    <span class="c-tournaments-filter-date-button-ui-label-date">{{ startDate | getFormattedDate }}</span>
                                </span>
                                <span class="c-tournaments-filter-date-button-ui-label" v-if="!isStartDateSelected">
                                    <span class="c-tournaments-filter-date-button-ui-label-day">-</span>
                                </span>
                            </span>
                        </label>
                        <div class="c-tournaments-filter-date-picker" ref="startDatePicker"></div>
                    </div>
                    <div class="c-tournaments-filter-grid-item">
                        <div class="c-tournaments-filter-date-label">JUSQU'AU :</div>
                    </div>
                    <div class="c-tournaments-filter-grid-item c-tournaments-filter-date" v-bind:class="{'is-selected': isEndDateSelected}">
                        <label class="c-tournaments-filter-date-button">
                            <input class="c-tournaments-filter-date-button-input" name="endDate" type="date" v-model="endDate" ref="endDatePickerInput">
                            <span class="c-tournaments-filter-date-button-ui">
                                <span class="c-tournaments-filter-date-button-ui-icon">
                                    <svg>
                                        <use xlink:href="img/sprites/sprite.svg#icon-calendar"/>
                                    </svg>
                                </span>
                                <span class="c-tournaments-filter-date-button-ui-label" v-if="isEndDateSelected">
                                    <span class="c-tournaments-filter-date-button-ui-label-day">{{ endDate | getDayOfWeek }}</span><br>
                                    <span class="c-tournaments-filter-date-button-ui-label-date">{{ endDate | getFormattedDate }}</span>
                                </span>
                                <span class="c-tournaments-filter-date-button-ui-label" v-if="!isEndDateSelected">
                                    <span class="c-tournaments-filter-date-button-ui-label-day">-</span>
                                </span>
                            </span>
                        </label>
                        <div class="c-tournaments-filter-date-picker" ref="endDatePicker"></div>
                    </div>
                </section>
                <section class="c-tournaments-filter-grid" v-show="isMenuSelected('types')">
                    <div class="c-tournaments-filter-grid-item">
                        <label class="c-tournaments-filter-checkbox">
                            <input class="c-tournaments-filter-checkbox-input" type="checkbox" name="types" value="1" v-model="selectedTypes">
                            <span class="c-tournaments-filter-checkbox-ui">
                                <span class="c-tournaments-filter-checkbox-ui-label" data-type="type" data-value="1">
                                    <strong>CASH</strong>
                                </span>
                            </span>
                        </label>
                    </div>
                    <div class="c-tournaments-filter-grid-item">
                        <label class="c-tournaments-filter-checkbox">
                            <input class="c-tournaments-filter-checkbox-input" type="checkbox" name="types" value="2" v-model="selectedTypes">
                            <span class="c-tournaments-filter-checkbox-ui">
                                <span class="c-tournaments-filter-checkbox-ui-label" data-type="type" data-value="2">
                                    <strong>SATELLITE</strong>
                                </span>
                            </span>
                        </label>
                    </div>
                    <div class="c-tournaments-filter-grid-item">
                        <label class="c-tournaments-filter-checkbox">
                            <input class="c-tournaments-filter-checkbox-input" type="checkbox" name="types" value="3" v-model="selectedTypes">
                            <span class="c-tournaments-filter-checkbox-ui">
                                <span class="c-tournaments-filter-checkbox-ui-label" data-type="type" data-value="3">
                                    <strong>SINGLE RE ENTRY</strong>
                                </span>
                            </span>
                        </label>
                    </div>
                    <div class="c-tournaments-filter-grid-item">
                        <label class="c-tournaments-filter-checkbox">
                            <input class="c-tournaments-filter-checkbox-input" type="checkbox" name="types" value="4" v-model="selectedTypes">
                            <span class="c-tournaments-filter-checkbox-ui">
                                <span class="c-tournaments-filter-checkbox-ui-label" data-type="type" data-value="4">
                                    <strong>KNOCKOUT</strong>
                                </span>
                            </span>
                        </label>
                    </div>
                    <div class="c-tournaments-filter-grid-item">
                        <label class="c-tournaments-filter-checkbox">
                            <input class="c-tournaments-filter-checkbox-input" type="checkbox" name="types" value="5" v-model="selectedTypes">
                            <span class="c-tournaments-filter-checkbox-ui">
                                <span class="c-tournaments-filter-checkbox-ui-label" data-type="type" data-value="5">
                                    <strong>SURVIVOR</strong>
                                </span>
                            </span>
                        </label>
                    </div>
                    <div class="c-tournaments-filter-grid-item">
                        <label class="c-tournaments-filter-checkbox">
                            <input class="c-tournaments-filter-checkbox-input" type="checkbox" name="types" value="6" v-model="selectedTypes">
                            <span class="c-tournaments-filter-checkbox-ui">
                                <span class="c-tournaments-filter-checkbox-ui-label" data-type="type" data-value="6">
                                    <strong>HIGHROLLER</strong>
                                </span>
                            </span>
                        </label>
                    </div>
                    <div class="c-tournaments-filter-grid-item">
                        <label class="c-tournaments-filter-checkbox">
                            <input class="c-tournaments-filter-checkbox-input" type="checkbox" name="types" value="7" v-model="selectedTypes">
                            <span class="c-tournaments-filter-checkbox-ui">
                                <span class="c-tournaments-filter-checkbox-ui-label" data-type="type" data-value="7">
                                    <strong>BIG BLIND ANTE</strong>
                                </span>
                            </span>
                        </label>
                    </div>
                    <div class="c-tournaments-filter-grid-item">
                        <label class="c-tournaments-filter-checkbox">
                            <input class="c-tournaments-filter-checkbox-input" type="checkbox" name="types" value="8" v-model="selectedTypes">
                            <span class="c-tournaments-filter-checkbox-ui">
                                <span class="c-tournaments-filter-checkbox-ui-label" data-type="type" data-value="8">
                                    <strong>SIT N GO</strong>
                                </span>
                            </span>
                        </label>
                    </div>
                </section>
            </div>
        </section>
        <section class="c-tournaments-filter-extended-choices">
            <div class="c-tournaments-filter-extended-choice" v-for="buyIn in selectedBuyInsData">
                <div class="c-tournaments-filter-extended-choice-label">BUY IN :</div>
                <div class="c-tournaments-filter-extended-choice-value">{{ buyIn.label }}</div>
                <button class="c-tournaments-filter-extended-choice-button" type="button" v-on:click="unSelectBuyIn(buyIn)">╳</button>
            </div>
            <div class="c-tournaments-filter-extended-choice" v-if="startDate">
                <div class="c-tournaments-filter-extended-choice-label">À PARTIR DE :</div>
                <div class="c-tournaments-filter-extended-choice-value"><span style="text-transform: uppercase">{{ startDate | getDayOfWeek }}</span> {{ startDate | getFormattedDate }}</div>
                <button class="c-tournaments-filter-extended-choice-button" type="button" v-on:click="unSelectStartDate">╳</button>
            </div>
            <div class="c-tournaments-filter-extended-choice" v-if="endDate">
                <div class="c-tournaments-filter-extended-choice-label">JUSQU'AU :</div>
                <div class="c-tournaments-filter-extended-choice-value"><span style="text-transform: uppercase">{{ endDate | getDayOfWeek }}</span> {{ endDate | getFormattedDate }}</div>
                <button class="c-tournaments-filter-extended-choice-button" type="button" v-on:click="unSelectEndDate">╳</button>
            </div>
            <div class="c-tournaments-filter-extended-choice" v-for="type in selectedTypesData">
                <div class="c-tournaments-filter-extended-choice-label">GENRE :</div>
                <div class="c-tournaments-filter-extended-choice-value">{{ type.label }}</div>
                <button class="c-tournaments-filter-extended-choice-button" type="button" v-on:click="unSelectType(type)">╳</button>
            </div>
        </section>
    </form>
</section>
