<?php require 'inc/html.php'; ?>
<head>
  <?php require 'inc/head.php'; ?>
</head>
<body>
  <?php
    $components = getComponentsList(realpath('inc/components'));
    $selectedComponent = null;
    if (isset($_GET['component']))
    {
      foreach ($components as $component)
      {
        if ($component['name'] === $_GET['component'])
        {
          $selectedComponent = $component;
          break;
        }
      }
    }
  ?>
  <div class="wrapper">
    <div class="row-fluid">
      <h1>CASINOS BARRIERE</h1>
      <div>
        <label>
          <span>Composant : </span>
          <select id="selector">
            <option disabled <?= (!isset($_GET['module'])) ? 'selected' : ''?>>Sélectionnez un composant</option>
            <?php foreach ($components as $c) : ?>
              <option <?= (isset($selectedComponent['name']) && $selectedComponent['name'] === $c['name']) ? 'selected' : ''?> value="<?= $_SERVER['PHP_SELF'] ?>?component=<?= $c['name'] ?>&title=<?= urlencode("#{$c['name']}") ?>"><?= $c['name'] ?></option>
            <?php endforeach; ?>
          </select>
        </label>
      </div>
    </div>
    <?php if (isset($selectedComponent)) : ?>
    <div class="row-fluid">
        <?= generateAllBlocksTitle(urldecode($selectedComponent['name']), "Composant {$selectedComponent['name']}") ?>
        <?php require $selectedComponent['path']; ?>
    </div>
    <?php endif; ?>
  </div>
  <script>
    var selector = document.querySelector("#selector");

    selector.addEventListener("change", function() {
       location.assign(selector.value);
    });
  </script>
<?php
require 'inc/scripts.php';
?>
</body>
</html>
