var getService = require("../libs/get-service").default;
var gettpl = require("../libs/gettpl");
var pagin = require("../modules/pagination").default;

var pager = pagin('casino-ranking-pagination', 'casino-ranking-pagination-skip', 2);
var previousState = false;
var currentpage = 1;
var currentTotalPage = 0;
const PAGESIZE = 10;

var progress = {
    '-1': 'down',
    '0': 'none',
    '1': 'up'
};

var buildNav = function (context, total, current) {
    let html = pager(current, total);

    context.$el.find('.js-pagination-wrapper').html(html);
    currentpage = current;
    currentTotalPage = total;

    //affichage precedent suivant
    var prev = context.$el.find('.component-LB-grid-pagination-button--prev');
    var next = context.$el.find('.component-LB-grid-pagination-button--next');

    prev.removeClass('hidden');
    next.removeClass('hidden');

    if (currentpage == 1) {
        prev.addClass('hidden');
    }
    if (currentTotalPage == currentpage) {
        next.addClass('hidden');
    }
};

var buildResult = function (endpoint, context, data) {
    getService(endpoint, data).done(function (response) {
        var html = '';

        for (var i = 0; i < response.data.length; i++) {
            var obj = response.data[i];
            obj.progression = progress[obj.progression];
            html += gettpl(obj, 'casino-ranking-result')
        }

        buildNav(context, response.pagination.totalPages, response.pagination.currentPage);
        context.$el.find('.js-ranking-result').html(html);
    });
};

var showDates = function(context) {
    var apiCurrentDate = previousState ? 'previousWeekDate' : 'currentWeekDates';

    getService(apiCurrentDate, {}).done(function (response) {
        context.$startPeriod.html(new Date(response.data.debut).toLocaleDateString());
        context.$endPeriod.html(new Date(response.data.fin).toLocaleDateString());
    });
};

var showRanking = function (context, page = 1) {
    var apiEndpoint = 'casinoRanking' + (previousState ? 'Previous' : 'Current');
    var data = {page: page, size: PAGESIZE};

    // on vide le champ de recherche
    context.$el.find('.js-input-search').val('');

    buildResult(apiEndpoint, context, data);
};

var showSearch = function(context, search) {
    var apiEndpoint = 'casinoRankingSearch' + (previousState ? 'Previous' : 'Current');
    var data = {pseudo: search};

    buildResult(apiEndpoint, context, data);
};

export default class {

    constructor($el) {
        let context = this;
        context.$el = $el;
        context.$startPeriod = $el.find('.start-period');
        context.$endPeriod = $el.find('.end-period');

        // Appel à l'API pour récupérer les dates de debut et de fin
        showDates(context);

        // Appel à l'API pour récupérer le classement
        showRanking(context, 1, null);

        // Comportement au clic sur un item de la pagination
        $el.find('.js-pagination').on('click', '.js-pagination-item', function () {
            var page = $(this).data('index');
            page = page === 'prev' ? currentpage-1 : page === 'next' ? currentpage+1 : page;
            console.log('current : ',currentpage);
            console.log('page:'+page);

            if (page >= 1 && page <= currentTotalPage) {
                showRanking(context, page);
            }

            return false;
        });

        // Comportement du formulaire de recherche
        $el.find('.js-form').on('submit', function (e) {
            e.preventDefault();
            let input = $(this).find('.js-input-search');

            // Appel de l'api pour afficher le résultat de recherche
            showSearch(context, input.val());
        });

        // Comportement du bouton "semaine suivante"
        $el.find('.js-current').on('click', function () {
            previousState = false;
            showDates(context);
            showRanking(context, 1, null);
        });

        // Comportement du bouton "semaine précédente"
        $el.find('.js-prev').on('click', function () {
            previousState = true;
            showDates(context);
            showRanking(context, 1, null);
        });

        var arrow = $el.find('.component-LB-header-controls-arrow');
        arrow.on('click', function () {
            arrow.removeClass('inactif');
            $(this).addClass('inactif');
        });
    }
};
