var FORM = require('./FORM').default;
class CONTACT {
    constructor($el) {
        var el;

        this.stickyMenu = $('.navbar-default');

        el = $el.get(0);
        this.el = el;
        this.formComponent = new FORM(el.querySelector(".contact-form"));
        this.analyticsCall = $el.data("analyticsCall");
        this.analyticsName = $el.data("analyticsName");
        this.analyticsType = $el.data("analyticsType");
        this._disableOptionalFields(this.formComponent.getFields(false));
        this._setEvents();
        this._fixSticky();
    }

    _disableOptionalFields(fields) {
        fields.card.el.disabled = true;
        fields.casino.el.disabled = true;
        fields.optoutReason.el.disabled = true;
        fields.message.el.disabled = false;
        return fields;
    }

    _onFormSubmit(e) {
        e.preventDefault();
        if (!this.formComponent.validate())
        {
            return;
        }
        digitalData.clic = { name: this.analyticsName, type: this.analyticsType, url: window.location.href };
        _satellite.track(this.analyticsCall);
        $('.contact-form').submit();
    }

    _onObjectChange(e) {
        var fields, value;

        value = e.target.value;
        this.el.querySelector(".contact-form").setAttribute("data-object", value);
        fields = this._disableOptionalFields(this.formComponent.getFields(false));

        switch (value) {
            case "information":
                fields.card.el.disabled = true;
                fields.casino.el.disabled = false;
                fields.optoutReason.el.disabled = true;
                $('*[data-id="message"]').show();
                break;
            case "request":
                fields.casino.el.disabled = false;
                fields.card.el.disabled = true;
                fields.optoutReason.el.disabled = true;
                $('*[data-id="message"]').show();
                break;
            case "premium":
                fields.card.el.disabled = false;
                fields.casino.el.disabled = false;
                fields.optoutReason.el.disabled = true;
                $('*[data-id="message"]').show();
                break;
            case "artist":
                fields.casino.el.disabled = true;
                fields.optoutReason.el.disabled = true;
                fields.card.el.disabled = true;
                $('*[data-id="message"]').show();
                break;
            case "newsletterOptout":
                fields.casino.el.disabled = true;
                fields.optoutReason.el.disabled = false;
                fields.card.el.disabled = true;
                $('*[data-id="message"]').show();
                break;
            default:
                break;
        }
    }

    _setEvents() {
        this.formComponent.el.addEventListener("submit", this._onFormSubmit.bind(this));
        this.el.querySelector('select[name="objet"]').addEventListener("change", this._onObjectChange.bind(this));
    }

    _fixSticky() {

        var context = this;

        if (Modernizr.touch) {
            $(document).on('focus', 'input', function () {
                // remove Sticky
                context.stickyMenu.unstick();
            }).on('blur', 'input', function () {
                context.stickyMenu.sticky({topSpacing: 0});
            });
        }
    }
}
export default CONTACT;
