"use strict";

class CARVIP {

    constructor(el) {
        this.el = $(el);
        this.carousel = this.el.find('.js-carousel');
        this.initFlickity();
        this.toogleNotices();
        this.setEvents();
    }

    initFlickity() {
        this.carousel.flickity({
            cellAlign: 'left',
            imagesLoaded: true,
            wrapAround: true,
            contain: true,
            autoPlay: 5000,
            pauseAutoPlayOnHover: true,
            pageDots: false,
            arrowShape: {
                x0: 10,
                x1: 60, y1: 50,
                x2: 65, y2: 50,
                x3: 15
            }
        });
        this.carousel.flickity('resize');
    }

    toogleNotices() {
        var $btn = this.el.find('.carre-vip-notice-btn');
        $btn.click(function (el) {
            $(this).parent().toggleClass("large");
        });
    }

    debounce(func, wait, immediate = false) {
        var timeout;
        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }

    setEvents() {
        $(window).on("resize.CARVIP", this.debounce(this.onWindowResize.bind(this), 150));
    }

    onWindowResize() {
        this.el.find('.carre-vip-notice').removeClass('large');
    }
}
export default CARVIP;