<?php require 'inc/html.php'; ?>
<head>
  <?php require 'inc/head.php'; ?>
</head>
<body>
<?php
$modules = getModulesList(realpath('inc/modules'));
$selectedModule = null;
if (isset($_GET['module']))
{
  foreach ($modules as $module)
  {
    if ($module['name'] === $_GET['module'])
    {
      $selectedModule = $module;
      break;
    }
  }
}
?>
<div class="wrapper">
  <div class="row-fluid">
    <h1>CASINOS BARRIERE</h1>
    <div>
      <label>
        <span>Module : </span>
        <select id="selector">
          <option disabled <?= (!isset($_GET['module'])) ? 'selected' : ''?>>Sélectionnez un module</option>
          <?php foreach ($modules as $c) : ?>
            <option <?= (isset($selectedModule['name']) && $selectedModule['name'] === $c['name']) ? 'selected' : ''?> value="<?= $_SERVER['PHP_SELF'] ?>?module=<?= $c['name'] ?>&title=<?= urlencode("#{$c['name']}") ?>"><?= $c['name'] ?></option>
          <?php endforeach; ?>
        </select>
      </label>
    </div>
  </div>
  <?php if (isset($selectedModule)) : ?>
    <div class="row-fluid">
      <?= generateAllBlocksTitle(urldecode($selectedModule['name']), "Module {$selectedModule['name']}") ?>
      <?php require $selectedModule['path']; ?>
    </div>
  <?php endif; ?>
</div>
<script>
    var selector = document.querySelector("#selector");

    selector.addEventListener("change", function() {
        location.assign(selector.value);
    });
</script>
<?php
require 'inc/debug.inc.php';
require 'inc/scripts.php';
?>
</body>
</html>
