var getService = require("../libs/get-service").default;

export default class {

    constructor($el) {
        let context = this;
        context.date = new Date($el.data('iso-datetime'));
        context.daysEl = $el.find('.js-days').get(0);
        context.hoursEl = $el.find('.js-hours').get(0);
        context.minutesEl = $el.find('.js-minutes').get(0);
        
        //call json
        //countdown
        getService('nextRankingDate', {}).done(function (response) {
            context.start(response.data);
        });
    }

    start(dateEnd) {
        let intervalId;

        this.updateDOM(null, dateEnd);
        intervalId = setInterval(() => this.updateDOM(intervalId, dateEnd), 1000);
    }

    updateDOM(intervalId = null, dateEnd) {

        let count = countdown(new Date(dateEnd));
        let value = new Date(dateEnd);
        let days = count.days;
        let hours = count.hours;
        let minutes = count.minutes;

        if (value <= 0) {
            if (intervalId) {
                clearInterval(intervalId);
            }
            return;
        }
        this.daysEl.innerText = days;
        this.hoursEl.innerText = hours;
        this.minutesEl.innerText = minutes;
    }
};