import Form from "../modules/form.js";

class FORM {
    constructor(el) {
        if (el instanceof jQuery) {
            el = el.get(0);
        }
        this.el = el;
        this.form = new Form(el);
        this.regExps = {
            email: /^.*@.*$/,
            nospecialchars: /^[^\!\"\#\$\%\&\(\)\*\+\,\.\/\:\;\<\=\>\?\@\[\]\^\_\`\{\|\}\~\\]*$/,
            phone: /^\d{10,15}$/
        };
    }

    getFields(enabledOnly = true) {
        var elements,
            elementNames,
            fields,
            formData;

        elements = this.form.getFields(false);
        elementNames = Object.keys(elements);
        fields = {};
        formData = this.form.getData();
        elementNames.forEach((name) => {
            
            var el,
                fData,
                format;

            // NOTE: should be RadioNodeList, but it doesn't work on iOS Safari and IE11 only supports HTMLCollection
            if (elements[name] instanceof NodeList || elements[name] instanceof HTMLCollection)
            {
                el = elements[name][0];
            }
            else
            {
                el = elements[name];
            }
            if (enabledOnly === true && el.disabled)
            {
                return;
            }
            fData = {
                el: el,
                isValid: true,
                value: formData[name]
            };
            fData.isRequired = el.hasAttribute("data-required");
            fData.isFormatted = el.hasAttribute("data-format");
            fData.errorMessage = el.hasAttribute("data-errormsg");
            if (fData.isFormatted)
            {
                format = el.getAttribute("data-format");
                fData.format = (typeof this.regExps[format] !== "undefined") ? this.regExps[format] : new RegExp(format);
            }
            fields[el.name] = fData;
        });

        $('.error-message').remove();

        return fields;
    }

    validate(showUIFeedback = true) {
        var $f,
            f,
            fields,
            form,
            isValid,
            prop,
            value;

        form = this.el;
        fields = this.getFields();
        isValid = true;

        //$('.error-message').remove();

        for (prop in fields) {
            if (fields.hasOwnProperty(prop)) {
                f = fields[prop];
                value = f.value;

                // Required field not filled
                if (f.isRequired && !value) {
                    f.isValid = false;
                    isValid = false;
                }

                // Invalid value format
                else if (f.isFormatted && f.format.test(f.value) === false) {
                    f.isValid = false;
                    isValid = false;
                }

                // User interface feedbacks
                if (showUIFeedback) {
                    $f = $(f.el);

                    if (f.isValid) {
                        $f.closest(".form-group").removeClass("is-invalid");
                    }
                    else {
                        var $errormsg = '<span class="error-message">' + $f.attr('data-errormsg') + '</span>';
                        $f.closest(".form-group").addClass("is-invalid");

                        if ($f.attr('name') == "civilite") {
                            $f.parent().parent().append('<br />' + $errormsg);
                        }
                        else {
                            $f.parent().append($errormsg);
                        }

                    }
                }

            }
        }
        return isValid;
    }
}
export default FORM;