var storeSearch = function (e) {
    e.preventDefault();

    // store search to retrieve it next page
    localStorage.findCasinoNear = $(this).find('.js-find-nearest-casino-input').val();

    // unbind to avoid infinite loop
    $(this).off('submit', storeSearch);
    $(this).submit();
};

var findNearestCasinoForm = (function () {
    var init = function () {

        // "find nearest casino" form
        var $find_nearest_casino_form = $('.js-find-nearest-casino-form');
        if ($find_nearest_casino_form.length > 0) {
            $find_nearest_casino_form.on('submit', storeSearch);
        }

        // map input search
        var $search_inputs = $('.casino-locator-panel-form-search-input');
        if ($search_inputs.length > 0) {
            if (localStorage.findCasinoNear && localStorage.findCasinoNear != '') {
                $search_inputs.val(localStorage.findCasinoNear).trigger('keyup').trigger('focus');

                var position = $search_inputs.parents('form').first().offset().top - 250;
                $(window).scrollTop(position);

                localStorage.findCasinoNear = '';
            }
        }
    };

    return {
        init: init
    };

})();

export default findNearestCasinoForm;
