var closestMarker = (function () {
    "use strict";

    function rad(x) {
        return x * Math.PI / 180;
    }

    function findClosestMarker(home, markers) {
        var lat = home.lat;
        var lng = home.lng;
        var R = 6371; // radius of earth in km
        var distances = [];
        var closest = -1;

        for (var i = 0; i < markers.length; i++) {
            var mlat = markers[i].lat;
            var mlng = markers[i].lng;
            var dLat = rad(mlat - lat);
            var dLong = rad(mlng - lng);
            var a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
                Math.cos(rad(lat)) * Math.cos(rad(lat)) * Math.sin(dLong / 2) * Math.sin(dLong / 2);
            var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
            var d = R * c;

            distances[i] = d;

            if (closest == -1 || d < distances[closest]) {
                closest = i;
            }
        }

        return markers[closest];
    }
    return findClosestMarker;

})();
export default closestMarker;