"use strict";

class VGI {

    constructor(el) {
        this.el = $(el);

        this.isPlaying = false;

        this.playButton = this.el.find('.video-control');
        this.video = this.el.find('.video-player')[0];
        this.video.pause();

        this.el.mouseover(this.onRollOver.bind(this));
        this.el.mouseout(this.onRollOut.bind(this));

        this.playButton.click(this.playVideo.bind(this));

    }

    onRollOver() {

        if (this.isPlaying) {
            this.playButton.addClass('hide');
        } else {
            this.playButton.removeClass('hide');
        }

    }

    onRollOut() {

        if (this.isPlaying) {
            this.playButton.addClass('hide');
        }

    }

    playVideo(e) {

        e.preventDefault();

        if (this.video.paused) {
            this.playButton.addClass('play');
            this.video.play();
            this.isPlaying = true;
        } else {
            !this.video.pause();
            this.playButton.removeClass('play');
            this.isPlaying = false;
        }

    }

}
export default VGI;