"use strict";

class INFORMATIONMAP {

    constructor(el) {

        this.el = $(el);
        this.assetsDir = this.el.data("assetsDir");
        this.loadMap();
    }

    loadMap() {
        var dot_marker = {
            url: `${this.assetsDir}/img/skin/marker-dot.png`,
            scaledSize: new google.maps.Size(28, 40),
            origin: new google.maps.Point(0, 0),
            anchor: new google.maps.Point(14, 40)
        };

        var gmap_container = this.el.find('#practical-information-map');
        var longitude = gmap_container.attr('data-longitude');
        var latitude = gmap_container.attr('data-latitude');
        var casino_position = new google.maps.LatLng(Number(latitude), Number(longitude));

        var map = new google.maps.Map(gmap_container.get(0), {
            mapTypeControl: false,
            zoom: 14,
            center: casino_position
        });

        new google.maps.Marker({
            position: casino_position,
            icon: dot_marker,
            map: map
        });
    }


}
export default INFORMATIONMAP;
