class FICHESPECTACLE {

    constructor($el) {

        this.el = $el;
        this.$options = $el.find('.js-show-option');
        this.$price = $el.find('.js-show-price');
        this.$reservationBtn = $el.find('.js-show-reservation-btn');
        this.updateItem();
        this.moveGallery();
        this.setEvents();
    }

    updateItem() {
        var $video = $('.spectacle-fiche-left-video');
        var $image = $('.spectacle-fiche-left-image');
        var $listitem = $('.spectacle-gallery-list-item');
        $listitem.on("click", function (e) {
            e.preventDefault();
            var url = $(this).attr('data-src');
            if ($(this).attr('data-type') === 'video') {
                /*$("video").each(function () { 
                 this.currentTime = 0;
                 this.play(); 
                 } );*/
                $video.show();
                $image.hide();
                $('#spectaclevideo').attr('src', url);

            }
            else {
                //$("video").each(function () { this.pause(); } );
                $('#spectaclevideo').attr('src', 'about:blank');
                $image.show();
                $video.hide();
                $image.find('img').attr('src', url);
            }
            $listitem.removeClass('active');
            $(this).addClass('active');
            //player.stopVideo();
        });
    }

    debounce(func, wait, immediate = false) {
        var timeout;
        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }

    getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    setEvents() {
        this.$options.on('change', (e) => {

            const el = e.target;

            this.setPrice(el.getAttribute('data-show-price'));
            this.setReservationLink(el.getAttribute('data-show-reservation-link'));
        });
        $(window).on("resize.SPECTACLEFICHE", this.debounce(this.onWindowResize.bind(this), 150));
        $('.icon-social-spectacle-print').on('click', function () {
            window.print();
        });
    }

    setPrice(price) {

        this.$price.text(price);
    }

    setReservationLink(link) {

        this.$reservationBtn.attr('href', link);
    }

    onWindowResize() {
        this.moveGallery()
    }

    moveGallery() {
        var device = this.getCurrentDevice();
        var $wrapper = $('.spectacle-gallery-wrapper');
        if (device === "desktop" || $(window).width() > 1024) {
            $wrapper.appendTo('.spectacle-gallery');
            $wrapper.css({'width': '83.125%', 'margin-left': '8.4375%'});
        }
        else {
            $wrapper.appendTo('.spectacle-fiche-left');
            $wrapper.css({'width': '100%', 'margin-left': 0, 'margin-top': 40});
        }
    }

}
export default FICHESPECTACLE;