class ESPRITHISTORY {
    constructor($el) {
        this.$el = $el;
        this.device = this.getCurrentDevice();
        if (this.device === 'desktop') this.scrollListener(this.device);
        this.setEvents();

        // We have to wait the page to be fully loaded before reveal elements
        $(window).load(function () {
            window.sr = ScrollReveal({scale: 1, mobile: false});

            sr.reveal('.portrait-1', {delay: 200});
            sr.reveal('.portrait-2', {delay: 300});
            sr.reveal('.portrait-3', {delay: 400});
        });
    }

    scrollListener(device) {
        if (device === "desktop") {
            $(window).scroll(function () {
                var s = $(window).scrollTop();
                $('.esprit-barriere-history-header-background').find('img').css('top', (300 - s / 4) + 'px');
            });
        }
        else {
            $(window).off("scroll");
            $('.esprit-barriere-history-header-background').css('background-position', ' center center');
        }
    }

    getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    setEvents() {
        $(window).on("resize.ESPRITHISTORY", this.debounce(this.onWindowResize.bind(this), 150));
    }

    getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    debounce(func, wait, immediate = false) {
        var timeout;
        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }

    onWindowResize() {
        this.device = this.getCurrentDevice();
        this.scrollListener(this.device);
    }
}
export default ESPRITHISTORY;