var FORM = require('./FORM').default;
class DEVIS {
    constructor($el) {
        var el;

        this.inputDepart = $el.find('#depart');
        this.inputArrivee = $el.find('#arrivee');
        this.nbpersonnes = $el.find('#nbpersonnes');
        this.analyticsCall = $el.data("analyticsCall");
        this.analyticsName = $el.data("analyticsName");
        this.analyticsType = $el.data("analyticsType");
        this.datePickers();
        this.numberField();

        el = $el.get(0);
        this.el = el;
        this.formComponent = new FORM(el.querySelector(".devis-form"));
        this._setEvents();
    }

    datePickers() {
        var device = this.getCurrentDevice();
        var self = this;

        if (device === 'desktop') {
            this.inputDepart.attr('type', 'text');
            this.inputArrivee.attr('type', 'text');
            var frenchConf = {
                days: ["Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi", "Dimanche"],
                daysShort: ["Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam", "Dim"],
                daysMin: ["Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa", "Di"],
                months: ["Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Decembre"],
                monthsShort: ["Jan", "Fev", "Mar", "Avr", "Mai", "Jun", "Jul", "Auo", "Sep", "Oct", "Nov", "Dec"]
            };

            this.inputDepart.pickmeup(
                {
                    locale: frenchConf,
                    min: new Date(),
                    hide_on_select: true
                }
            );

            this.inputArrivee.pickmeup(
                {
                    change: function() {

                        var endDate,
                            startDate;

                        startDate = self.inputArrivee.pickmeup("get_date", false);
                        endDate = self.inputDepart.pickmeup("get_date", false);
                        self.inputDepart.pickmeup("destroy");
                        self.inputDepart.pickmeup({
                            locale: frenchConf,
                            min: startDate,
                            hide_on_select: true
                        });
                        if (endDate < startDate)
                        {
                            self.inputDepart.pickmeup('set_date', startDate);
                        }
                    },
                    locale: frenchConf,
                    min: new Date(),
                    hide_on_select: true
                }
            );
        }
        else {
            this.inputDepart.attr('type', 'date').pickmeup('destroy');
            this.inputArrivee.attr('type', 'date').pickmeup('destroy');
        }
    }

    numberField() {
        var device = this.getCurrentDevice();

        if (device === 'desktop') {
            this.nbpersonnes.attr('type', 'number');
        }
        else {
            this.nbpersonnes.attr('type', 'tel');
        }
    }

    _disableOptionalFields(fields) {
        fields.card.el.disabled = true;
        fields.casino.el.disabled = true;
        fields.optoutReason.el.disabled = true;
        return fields;
    }

    _onFormSubmit(e) {
        if (!this.formComponent.validate()) {
            e.preventDefault();
        }
        digitalData.clic = { name: this.analyticsName, type: this.analyticsType, url: window.location.href };
        _satellite.track(this.analyticsCall);
    }

    _onObjectChange(e) {
        var fields,
            value;

        value = e.target.value;
        this.el.querySelector(".contact-form").setAttribute("data-object", value);
        fields = this._disableOptionalFields(this.formComponent.getFields(false));
        switch (value) {
            case "information":
                fields.casino.el.disabled = false;
                break;
            case "request":
                fields.casino.el.disabled = false;
                break;
            case "premium":
                fields.card.el.disabled = false;
                fields.casino.el.disabled = false;
                break;
            case "newsletterOptout":
                fields.casino.el.disabled = false;
                fields.optoutReason.el.disabled = false;
                break;
            default:
                break;
        }
    }

    onWindowResize() {
        this.datePickers();
        this.numberField();
    }

    _setEvents() {
        this.formComponent.el.addEventListener("submit", this._onFormSubmit.bind(this));
        $(window).on("resize.DEVIS", this.debounce(this.onWindowResize.bind(this), 150));
    }

    getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    debounce(func, wait, immediate = false) {
        var timeout;
        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }
}
export default DEVIS;
