<?php
function findFilesByPattern($directory, $pattern, &$occurrences = array(), $isRecursive = true)
{
  $directoryItems = scandir($directory);
  $regExpMatches = array();
  if (is_array($directoryItems))
  {
    foreach ($directoryItems as $item)
    {
      $basename = $item;
      $item = realpath($directory . DIRECTORY_SEPARATOR . $item);
      if ($isRecursive && is_dir($item) && $basename !== '.' && $basename !== '..')
      {
        findFilesByPattern($item, $pattern, $occurrences);
      }
      else if (is_file($item))
      {
        preg_match($pattern, $item, $regExpMatches);
        if (is_array($regExpMatches) && !empty($regExpMatches))
        {
          $occurrences[] = array(
            'path' => $item,
            'matches' => $regExpMatches
          );
        }
      }
    }
  }
}

function getSvgIconsList($svgDirectory)
{
  $occurences = array();
  $svgIcons = array();
  findFilesByPattern($svgDirectory, '/([\w-]+).svg$/', $occurences);
  foreach ($occurences as $occurence)
  {
    $svgIcons[] = array(
      'name' => $occurence['matches'][1]
    );
  }
  return $svgIcons;
}

function getModulesList($modulesDirectory)
{
  $occurences = array();
  $modules = array();
  findFilesByPattern($modulesDirectory, '/module-([\w-]+).php$/', $occurences);
  foreach ($occurences as $occurence)
  {
    $modules[] = array(
      'name' => $occurence['matches'][1],
      'path' => $occurence['path']
    );
  }
  return $modules;
}

function getComponentsList($componentsDirectory)
{
  $occurences = array();
  $components = array();
  findFilesByPattern($componentsDirectory, '/component-([\w-]+).php$/', $occurences);
  foreach ($occurences as $occurence)
  {
    $components[] = array(
      'name' => $occurence['matches'][1],
      'path' => $occurence['path']
    );
  }
  return $components;
}

function getCurrentLocale($defaultLocale = 'fr_FR')
{
  return isset($_GET['locale']) ? $_GET['locale'] : $defaultLocale;
}

function generateAllBlocksTitle($title, $index = "")
{
    $id = urlencode($title);
    $blockIndex = isset($index) ? '<span style="border-radius: 100%;padding: 0 10px;">' . $index . '</span>' : '';

    return '<!--documentation-->
    <div class="title-main-debug">
    <a href="#' . $index . $id . '">' . $blockIndex . ' ' . $title . '</a></div><!--/documentation-->';
}


/**
 * @param string $toggleid set the id of toggle
 * @param string $togglegroup set the group of toggle
 * @param string $title display the popin title
 * @param string $inculde include file on folder inc/popins without the .php extension
 *
 * @return mixed
 */
function popin($toggleid, $togglegroup = 'popin', $title, $inculde)
{

    ob_start();
    include "popins/popin-master.php";
    $template = ob_get_contents();
    ob_end_clean();
    ob_start();
    include "popins/" . $inculde . ".php";
    $content = ob_get_contents();
    ob_end_clean();

    $search = array("#toggleid", "#togglegroup", "#title", "#content");
    $replace = array($toggleid, $togglegroup, $title, $content);
    $html = str_replace($search, $replace, $template);

    return $html;
}


function hotelmap($country = 'france', $city = 'paris', $mapIdentifier = '', $svg = false)
{
    $jsDestClass = $mapIdentifier ? ' JS_map_trigger' : '';
    $dataMapIdentifier = $mapIdentifier ? ' data-map-identifier="' . $mapIdentifier . '"' : '';
    $dataCityIdentifier = $mapIdentifier ? ' data-map-selector="' . $mapIdentifier . '" data-map-activation="dest-' . $city . '"' : '';
    $jsClass = $mapIdentifier ? ' JS_map' : '';
    $citytpl = '<span class="dest-' . $city . $jsDestClass . '" ' . $dataCityIdentifier . '></span>';

    if ($city === 'all') {
        $allcities = array('dest-paris', 'dest-engiens', 'dest-cannes', 'dest-niederbronn', 'dest-ribeauville', 'dest-deauville', 'dest-dinard', 'dest-baule', 'dest-lille', 'dest-marrakech ');
        $citytpl = '';
        foreach ($allcities as $cityname) {
            $dataCityIdentifier = $mapIdentifier ? ' data-map-selector="' . $mapIdentifier . '" data-map-activation="' . $cityname . '"' : '';
            $citytpl .= '<span class="' . $cityname . $jsDestClass . '" ' . $dataCityIdentifier . '></span>';
        }
    }
    if($svg){
        $template = '<span class="JS_map block-icon-map mapicon-' . $country . $jsClass . '"' . $dataMapIdentifier . '>' . file_get_contents('img/svg/' . $country . '.svg') . $citytpl . '</span>';
    }
    else{
        $template = '<i class="JS_map block-icon-map icon icon-' . $country . $jsClass . '" ' . $dataMapIdentifier . '>' . $citytpl . '</span></i>';
    }


    return $template;
}


function carditem($city = 'Cannes', $area = "Côte d'Azur")
{

    $template2 = '<div class="card-hotel-item"><h3 class="chi-hotel-city">' . $city . '</h3><p class="chi-hotel-region">' . $area . '</p></div>';

    return $template2;
}

/**
 * generate a fake select CSS dropdown form compatible
 * @param string $initial
 * @param string $id
 * @param string $type
 * @param string $labels ...
 * @return string HTML template
 */
function dropdown_select($initial = '0', $id, $type, $labels)
{

    $innerTemplate = '';
    if (func_num_args() > 4) {
        for ($i = 3; $i < func_num_args(); $i++) {
            $a = func_get_arg($i);
            $innerTemplate .= <<<"INNERCONTENT"
                                    <option value="$a">$a</option>
INNERCONTENT;
        }
    }
    $template2 = <<<"CONTENT"
                            <select name="adult" id="$id" class="JS_resa-select JS_select_people" data-type="$type">
                                <option value="$initial">$initial</option>
                                $innerTemplate
                            </select>
CONTENT;
    return $template2;
}
