export default {

  patterns: {

    "common": [
      {
        match: "CACHE_BUST",
        replacement: Date.now()
      },
      {
        match: "MQ_DESKTOP",
        replacement: "(min-width: 1280px)"
      },
      {
        match: "MQ_TABLET",
        replacement: "(min-width: 768px)"
      },
      {
        match: "MQ_MOBILE_LANDSCAPE",
        replacement: "(min-width: 480px) and (orientation: landscape)"
      },
      {
        match: "MQ_MOBILE",
        replacement: "(min-width: 320px)"
      }
    ],
    "development": [
      {
        match: "ENV",
        replacement: "DEV"
      },
      {
        match: "FS_SVG_ICONS_DIRECTORY",
        replacement: "../src/img/svg"
      },
      {
        match: "HTTP_ROOT_DIR",
        replacement: "."
      },
      {
        match: "HTTP_JSON_STUBS_ROOT",
        replacement: "http://api.barriere.local"
      }
    ],
    "production": [
      {
        match: "ENV",
        replacement: "PRODUCTION"
      },
      {
        match: "FS_SVG_ICONS_DIRECTORY",
        replacement: "./img/svg"
      },
      {
        match: "HTTP_ROOT_DIR",
        replacement: "http://site-test.barriere-pocketcasino.fr/dev"
      },
      {
        match: "HTTP_JSON_STUBS_ROOT",
        replacement: "json"
      }
    ]
  }
};
