import "core/polyfills";
import * as components from "components/components";
import moment from "moment";
import forEach from "lodash/forEach";

window.pm = {};

var lbc = {};
lbc.class = {};

lbc.class.ACTUMAS = require('./classes/ACTUMAS').default;
lbc.class.CARMAS = require('./classes/CARMAS').default;
lbc.class.CARVIP = require('./classes/CARVIP').default;
lbc.class.CASINOLOCATORJEU = require('./classes/CASINOLOCATORJEU').default;
lbc.class.CASINOPASS = require('./classes/CASINOPASS').default;
lbc.class.CONTACT = require('./classes/CONTACT').default;
lbc.class.CONTESTS = require('./classes/CONTESTS').default;
lbc.class.COOKIE = require('./classes/COOKIE').default;
lbc.class.DEVIS = require('./classes/DEVIS').default;
lbc.class.ESPRITBARRIERE = require('./classes/ESPRITBARRIERE').default;
lbc.class.ESPRITHISTORY = require('./classes/ESPRITHISTORY').default;
lbc.class.FICHESPECTACLE = require('./classes/FICHESPECTACLE').default;
lbc.class.FORM = require('./classes/FORM').default;
lbc.class.INFORMATIONMAP = require('./classes/INFORMATIONMAP').default;
lbc.class.JEU2 = require('./classes/JEU2').default;
lbc.class.JEUPOKER1 = require('./classes/JEUPOKER1').default;
lbc.class.JEURULESDETAILS = require('./classes/JEURULESDETAILS').default;
lbc.class.MEA1LOCAL = require('./classes/MEA1LOCAL').default;
lbc.class.MEA1MOV = require('./classes/MEA1MOV').default;
lbc.class.MEA3 = require('./classes/MEA3').default;
lbc.class['MEA3-2'] = require('./classes/MEA3-2').default;
lbc.class['MEA3-3'] = require('./classes/MEA3-3').default;
lbc.class.MEA6 = require('./classes/MEA6').default;
lbc.class.NAV = require('./classes/NAV').default;
lbc.class.NEWSLETTER = require('./classes/NEWSLETTER').default;
lbc.class.PGI = require('./classes/PGI').default;
lbc.class.REST1 = require('./classes/REST1').default;
lbc.class.SPECTACLEFILTER = require('./classes/SPECTACLEFILTER').default;
lbc.class.SRI = require('./classes/SRI').default;
lbc.class.TABS = require('./classes/TABS').default;
lbc.class.VGI = require('./classes/VGI').default;
lbc.class.HOTEL = require('./classes/HOTEL').default;
lbc.class.LAFOURCHETTEHOME = require('./classes/LAFOURCHETTEHOME').default;
lbc.class.LEADERBOARD_COUNTDOWN = require('./classes/LEADERBOARD_COUNTDOWN').default;
lbc.class.RANKING = require('./classes/RANKING').default;
lbc.class.NEAREST_CASINO = require("./classes/NEAREST_CASINO").default;
lbc.class.TOURNOIFILTERCLUB = require("./classes/TOURNOIFILTERCLUB").default;

const accordion = require("./libs/accordions").default;

$(document).on('ready', init);

function initMomentJs()
{
  switch (JSONendpointSettings.locale)
  {
    case "en_GB":
      moment.locale("en");
      break;
    default:
      moment.locale("fr");
      break;
  }
}

function initComponents()
{
  forEach(document.querySelectorAll("*[data-component]"), (el) => {

    const name = el.dataset.component;

    if (name && components[name])
    {
      new components[name]().$mount(el);
    }
  });
}

function init()
{
    document.body.addEventListener("scroll-disabled", e => e.target.classList.add("noscroll"), false);
    document.body.addEventListener("scroll-enabled", e => e.target.classList.remove("noscroll"), false);

    initMomentJs();
    initComponents();
    accordion();

    $('*[data-class]').each(function () {
        var _self = $(this);
        var _class = _self.attr('data-class');

        new lbc.class[_class](_self);
    });

    var isHome = $('body').hasClass('home');
    var sr = ScrollReveal({opacity: 0, distance: '20px', scale: 1, mobile: false});

    if (isHome) {

        //********************************//
        // Scroll Reveal only on Homepage

        // MEA 9
        sr.reveal('.home .mea9', {delay: 100});

        // MEA5
        sr.reveal('.home .mea5-header-title', {delay: 50});
        sr.reveal('.home .mea5-header-subtitle', {delay: 50});
        sr.reveal('.home .mea5-push-1', {delay: 50});
        sr.reveal('.home .mea5-push-2', {delay: 50});
        sr.reveal('.home .mea5-push-3', {delay: 50});
        sr.reveal('.home .mea5-push-4', {delay: 50});

        // MEA6
        sr.reveal('.home .mea6', {delay: 50, distance: '20px'});

        // MEA3 (generique)
        sr.reveal('.home .mea3-banner', {delay: 100});
        sr.reveal('.home .mea3-banner-title', {delay: 100});
        sr.reveal('.home .mea3-banner-subtitle', {delay: 100});
        sr.reveal('.home .mea3-banner-button', {delay: 100});

        // MEA2
        sr.reveal('.home .homemea2', {delay: 150});

        // LOCAL
        sr.reveal('.home .casino-events-container', {delay: 150});
        sr.reveal('.home .fidelity-container', {delay: 150});
        sr.reveal('.home .home-local-api', {delay: 150});
        sr.reveal('.home .home-local-api-events-meetings', {delay: 150});
        sr.reveal('.home .home-local-api-facebook', {delay: 150});
        sr.reveal('.home .home-local-nofourches', {delay: 150});
        sr.reveal('.home .home-local-nohotel', {delay: 150});
        sr.reveal('.home .mea1-local-first-visit-tokens', {delay: 150, origin: 'top'});
    }
    else
    {
        sr.reveal('.js-scroll-reveal');
    }

    $('.js-scrollto').on('click', (e) => {

        e.preventDefault();

        const selector = e.currentTarget.getAttribute('data-target');

        // TODO: uncomment this line when the presentation
        //const navHeight = $('.nav').height();

        const navHeight = 0;

        const target = document.querySelector(selector);

        if (!target)
        {
            console.error(`no element found for selector "${selector}"`);
            return;
        }
        $('html, body').animate({ scrollTop: target.offsetTop - navHeight }, 1000);
    });
}
