<?php
  $lafourchetteBookingComponent = array_merge(
    [
      'restaurantId'    => '303043',
      'menuOfferLabel'  => 'Offre'
    ],
    (isset($lafourchetteBookingComponent) && is_array($lafourchetteBookingComponent)) ? $lafourchetteBookingComponent : []
  );
?>
<form
    class="c-lafourchettebooking"
    novalidate="novalidate"
    data-component="laFourchetteBooking"
    data-restaurant-id="<?= $lafourchetteBookingComponent['restaurantId'] ?>"
    data-menu-offer-label="<?= $lafourchetteBookingComponent['menuOfferLabel'] ?>"
    data-analytics-type="Nous contacter"
    data-analytics-name="Page Restaurant"
    data-analytics-call="validation_formulaire">
  <div class="c-lafourchettebooking-title">RÉSERVER UNE TABLE</div>
  <nav class="c-lafourchettebooking-nav">
    <ul class="c-lafourchettebooking-nav-items">
      <li class="c-lafourchettebooking-nav-item" :class="{'is-active': step === 0}" v-if="minStep === 0">
        <button class="c-lafourchettebooking-nav-item-button" type="button" v-on:click="goToStep(0)">
          <span class="c-lafourchettebooking-nav-item-icon">
            <svg>
              <use v-bind="{ 'xlink:href': 'img/sprites/sprite.svg#icon-promotion' }"></use>
            </svg>
          </span>
          <span class="c-lafourchettebooking-nav-item-label">RÉSERVATION</span>
        </button>
      </li>
      <li class="c-lafourchettebooking-nav-item" v-bind:class="{'is-active': step === 1}">
        <button class="c-lafourchettebooking-nav-item-button" type="button" :disabled="step < 1" v-on:click="goToStep(1)">
          <span class="c-lafourchettebooking-nav-item-icon">
            <svg>
              <use v-bind="{ 'xlink:href': 'img/sprites/sprite.svg#icon-calendar' }"></use>
            </svg>
          </span>
          <span class="c-lafourchettebooking-nav-item-label" v-if="!choices.date">DATE</span>
          <span class="c-lafourchettebooking-nav-item-label" v-if="choices.date">{{ choices.date | formatDate(culture) }}</span>
        </button>
      </li>
      <li class="c-lafourchettebooking-nav-item" v-bind:class="{'is-active': step === 2}">
        <button class="c-lafourchettebooking-nav-item-button" type="button" :disabled="step < 2" v-on:click="goToStep(2)">
          <span class="c-lafourchettebooking-nav-item-icon">
            <svg>
              <use v-bind="{ 'xlink:href': 'img/sprites/sprite.svg#icon-hour' }"></use>
            </svg>
          </span>
          <span class="c-lafourchettebooking-nav-item-label" v-if="!choices.hour">HEURE</span>
          <span class="c-lafourchettebooking-nav-item-label" v-if="choices.hour">{{ choices.hour.datetime | formatHour }}</span>
        </button>
      </li>
      <li class="c-lafourchettebooking-nav-item" v-bind:class="{'is-active': step === 3}">
        <button class="c-lafourchettebooking-nav-item-button" type="button" :disabled="step < 3" v-on:click="goToStep(3)">
          <span class="c-lafourchettebooking-nav-item-icon">
            <svg>
              <use v-bind="{ 'xlink:href': 'img/sprites/sprite.svg#icon-peoples' }"></use>
            </svg>
          </span>
          <span class="c-lafourchettebooking-nav-item-label" v-if="!choices.people">NOMBRE DE PERSONNES</span>
          <span class="c-lafourchettebooking-nav-item-label" v-if="choices.people">{{ choices.people.nb_people }}</span>
        </button>
      </li>
      <li class="c-lafourchettebooking-nav-item" v-bind:class="{'is-active': step === 4}">
        <button class="c-lafourchettebooking-nav-item-button" type="button" :disabled="step < 4">
          <span class="c-lafourchettebooking-nav-item-icon">
            <svg>
              <use v-bind="{ 'xlink:href': 'img/sprites/sprite.svg#icon-coordonnees' }"></use>
            </svg>
          </span>
          <span class="c-lafourchettebooking-nav-item-label">COORDONNÉES</span>
        </button>
      </li>
    </ul>
  </nav>
  <nav class="c-lafourchettebooking-mobilenav" v-if="step < 5">
    <button class="c-lafourchettebooking-mobilenav-back" type="button" v-if="step > minStep" v-on:click="prev">
      <span class="c-lafourchettebooking-mobilenav-back-icon">
        <svg>
          <use v-bind="{ 'xlink:href': 'img/sprites/sprite.svg#arrow-left-white' }"></use>
        </svg>
      </span>
    </button>
    <div class="c-lafourchettebooking-mobilenav-text">
      <span v-if="step === 0">CHOISISSEZ UNE OFFRE</span>
      <span v-if="step === 1">CHOISISSEZ VOTRE DATE</span>
      <span v-if="step === 2">CHOISISSEZ UNE HEURE</span>
      <span v-if="step === 3">POUR COMBIEN DE PERSONNES ?</span>
      <span v-if="step === 4">TERMINEZ VOTRE RÉSERVATION</span>
    </div>
  </nav>
  <div class="c-lafourchettebooking-loader" v-show="isLoading">
    <div class="ui-loader ui-loader--golden">
      <div class="ui-loader-widget"></div>
    </div>
  </div>
  <div class="c-lafourchettebooking-steps" v-show="!isLoading" v-cloak>
    <div class="c-lafourchettebooking-step c-lafourchettebooking-step--saletype" v-if="step === 0">
      <div class="c-lafourchettebooking-step-title">SÉLECTIONNER UN TYPE DE RÉSERVATION</div>
      <ul class="c-lafourchettebooking-radiolist">
        <li class="c-lafourchettebooking-radiolist-item" v-for="type in salesTypes">
          <label class="c-lafourchettebooking-radiolist-item-container">
            <input class="c-lafourchettebooking-radiolist-item-input" type="radio" name="saleType" :checked="choices.saleType && choices.saleType.id_sale_type === type.id_sale_type" :value="type.id_sale_type" v-on:change="onSaleTypeSelect(type, $event)">
            <span class="c-lafourchettebooking-radiolist-item-radio"></span>
            <span class="c-lafourchettebooking-radiolist-item-label">{{ type.title }}</span>
          </label>
        </li>
      </ul>
      <footer class="c-lafourchettebooking-step-footer">
        <button class="c-lafourchettebooking-step-footer-button button button-golden" type="button" :disabled="choices.saleType === undefined" v-on:click="next">CONFIRMER</button>
      </footer>
    </div>
    <div class="c-lafourchettebooking-step c-lafourchettebooking-step--date" v-if="step === 1">
      <input class="c-lafourchettebooking-datepicker-input" type="date" ref="datePickerInput">
      <div class="c-lafourchettebooking-datepicker" ref="datePicker"></div>
      <div class="c-lafourchettebooking-step-notice" v-if="isMenuOffer(choices.saleType)">* Offre disponible</div>
      <footer class="c-lafourchettebooking-step-footer">
        <button class="c-lafourchettebooking-step-footer-button button button-golden" type="button" :disabled="choices.date === undefined" v-on:click="next">CONFIRMER</button>
      </footer>
    </div>
    <div class="c-lafourchettebooking-step c-lafourchettebooking-step--hour" v-if="step === 2">
      <div class="c-lafourchettebooking-buttonsgroup" v-if="hours.BREAKFAST">
        <div class="c-lafourchettebooking-buttonsgroup-title">PETIT-DÉJEUNER</div>
        <div class="c-lafourchettebooking-buttonsgroup-controls">
          <div class="c-lafourchettebooking-buttonsgroup-control" v-for="hour in hours.BREAKFAST">
            <button class="c-lafourchettebooking-buttonsgroup-control-button" type="button" :class="{'is-active': (choices.hour !== undefined && choices.hour.datetime === hour.datetime)}" v-on:click="onHourSelect(hour, $event)">{{ hour.datetime | formatHour }}</button>
            <div class="c-lafourchettebooking-buttonsgroup-control-notice" v-if="isMenuOfferHour(hour, choices.saleType)">{{ menuOfferLabel }}<sup>*</sup></div>
          </div>
        </div>
      </div>
      <div class="c-lafourchettebooking-buttonsgroup" v-if="hours.LUNCH">
        <div class="c-lafourchettebooking-buttonsgroup-title">DÉJEUNER</div>
        <div class="c-lafourchettebooking-buttonsgroup-controls">
          <div class="c-lafourchettebooking-buttonsgroup-control" v-for="hour in hours.LUNCH">
            <button class="c-lafourchettebooking-buttonsgroup-control-button" type="button" :class="{'is-active': (choices.hour !== undefined && choices.hour.datetime === hour.datetime)}" v-on:click="onHourSelect(hour, $event)">{{ hour.datetime | formatHour }}</button>
            <div class="c-lafourchettebooking-buttonsgroup-control-notice" v-if="isMenuOfferHour(hour, choices.saleType)">{{ menuOfferLabel }}<sup>*</sup></div>
          </div>
        </div>
      </div>
      <div class="c-lafourchettebooking-buttonsgroup" v-if="hours.DINER">
        <div class="c-lafourchettebooking-buttonsgroup-title">DINER</div>
        <div class="c-lafourchettebooking-buttonsgroup-controls">
          <div class="c-lafourchettebooking-buttonsgroup-control" v-for="hour in hours.DINER">
            <button class="c-lafourchettebooking-buttonsgroup-control-button" type="button" :class="{'is-active': (choices.hour !== undefined && choices.hour.datetime === hour.datetime)}" v-on:click="onHourSelect(hour, $event)">{{ hour.datetime | formatHour }}</button>
            <div class="c-lafourchettebooking-buttonsgroup-control-notice" v-if="isMenuOfferHour(hour, choices.saleType)">{{ menuOfferLabel }}<sup>*</sup></div>
          </div>
        </div>
      </div>
      <div class="c-lafourchettebooking-step-notice" v-if="choices.saleType && choices.saleType.exclusions">
        <sup>*</sup>{{ choices.saleType.exclusions }}
      </div>
      <footer class="c-lafourchettebooking-step-footer">
        <button class="c-lafourchettebooking-step-footer-button button button-golden" type="button" :disabled="choices.hour === undefined" v-on:click="next">CONFIRMER</button>
      </footer>
    </div>
    <div class="c-lafourchettebooking-step" v-if="step === 3">
      <div class="c-lafourchettebooking-buttonsgroup" v-if="numberOfPeople.normal !== undefined">
        <div class="c-lafourchettebooking-buttonsgroup-title">NOMBRE DE PERSONNES</div>
        <div class="c-lafourchettebooking-buttonsgroup-controls">
          <div class="c-lafourchettebooking-buttonsgroup-control" v-for="p in numberOfPeople.normal">
            <button class="c-lafourchettebooking-buttonsgroup-control-button" type="button" :class="{'is-active': (choices.people !== undefined && choices.people.nb_people === p.nb_people)}" v-on:click="onPeopleSelect(false, p, $event)">{{ p.nb_people }}</button>
          </div>
        </div>
      </div>
      <select class="form-select" v-if="numberOfPeople.group !== undefined" v-model="peopleSelectModel" v-on:change="onPeopleSelect(true, peopleSelectModel, $event)">
        <option value="" selected="selected" disabled="disabled">COMMANDE POUR UN GROUPE</option>
        <option :value="p" v-for="p in numberOfPeople.group">{{ p.nb_people }}</option>
      </select>
      <div class="c-lafourchettebooking-step-message" v-if="numberOfPeople.count === 0">
        Veuillez nous excuser mais le créneau horaire sélectionné ne dispose plus de places disponibles.
        <br>
        <br>
        Merci de sélectionner un autre créneau.
      </div>
      <footer class="c-lafourchettebooking-step-footer">
        <button class="c-lafourchettebooking-step-footer-button button button-golden" type="button" :disabled="choices.people === undefined" v-on:click="next">CONFIRMER</button>
      </footer>
    </div>
    <div class="c-lafourchettebooking-step c-lafourchettebooking-step--contact" v-if="step === 4">
      <div class="c-lafourchettebooking-form">
        <div class="c-lafourchettebooking-form-row c-lafourchettebooking-form-row--title">
          <label class="c-lafourchettebooking-form-radio">
            <input class="c-lafourchettebooking-form-radio-input js-title-radio" type="radio" name="title" value="1" required="required" data-parsley-errors-messages-disabled="true" v-model="choices.title">
            <span class="c-lafourchettebooking-form-radio-label">Mme</span>
          </label>
          <label class="c-lafourchettebooking-form-radio">
            <input class="c-lafourchettebooking-form-radio-input js-title-radio" type="radio" name="title" value="0" required="required" data-parsley-errors-messages-disabled="true" v-model="choices.title">
            <span class="c-lafourchettebooking-form-radio-label">M.</span>
          </label>
        </div>
        <div class="c-lafourchettebooking-form-row">
          <div class="c-lafourchettebooking-form-textfield">
            <input class="c-lafourchettebooking-form-textfield-input js-text-field" type="text" name="firstName" required="required" placeholder="Prénom *" data-parsley-required-message="Vous devez renseigner votre prénom" v-model="choices.firstName">
          </div>
          <div class="c-lafourchettebooking-form-textfield">
            <input class="c-lafourchettebooking-form-textfield-input js-text-field" type="text" name="lastName" required="required" placeholder="Nom *" data-parsley-required-message="Vous devez renseigner votre nom" v-model="choices.lastName">
          </div>
        </div>
        <div class="c-lafourchettebooking-form-row">
          <div class="c-lafourchettebooking-form-textfield">
            <input class="c-lafourchettebooking-form-textfield-input js-text-field" type="email" name="email" required="required" placeholder="Email *" data-parsley-required-message="Vous devez renseigner votre adresse email" data-parsley-type-message="Cet email semble invalide" v-model="choices.email">
          </div>
        </div>
        <div class="c-lafourchettebooking-form-row">
          <div class="c-lafourchettebooking-form-phone">
            <select class="c-lafourchettebooking-form-phone-prefix form-select" name="phone_prefix" v-model="choices.phonePrefix">
              <option value="33" selected="selected">FRANCE +33</option>
              <option value="41">SUISSE +41</option>
              <option value="44">UK +44</option>
              <option value="423">LIECHTENSTEIN +423</option>
            </select>
            <div class="c-lafourchettebooking-form-phone-field c-lafourchettebooking-form-textfield">
              <input
                class="c-lafourchettebooking-form-textfield-input js-text-field js-phone-field"
                type="tel"
                name="phone"
                pattern="^[0-9]+$"
                maxlength="64"
                required="required"
                placeholder="Numéro de téléphone *"
                data-input-validation-pattern="^[0-9]+$"
                data-parsley-required-message="Vous devez renseigner votre numéro de téléphone"
                data-parsley-pattern-message="Ce numéro de téléphone semble invalide"
                v-on:input.capture="onPhoneInputFieldInput"
                v-model="choices.phone">
            </div>
          </div>
        </div>
        <div class="c-lafourchettebooking-form-row">
          <label class="c-lafourchettebooking-form-optin">
            <input class="c-lafourchettebooking-form-optin-checkbox" type="checkbox" name="optin" v-model="choices.optin">
            <span class="c-lafourchettebooking-form-optin-text">Je souhaite recevoir des informations de la part de ce restaurant</span>
          </label>
        </div>
      </div>
      <div class="c-lafourchettebooking-step-errormessage" v-if="apiErrorMessage">Erreur technique : {{ apiErrorMessage }}</div>
      <footer class="c-lafourchettebooking-step-footer">
        <button class="c-lafourchettebooking-step-footer-button button button-golden" type="submit">RÉSERVER</button>
      </footer>
    </div>
    <div class="c-lafourchettebooking-step" v-if="step === 5">
      <div class="c-lafourchettebooking-confirm-title desktop-only">NOUS AVONS BIEN PRIS EN COMPTE VOTRE RÉSERVATION</div>
      <div class="c-lafourchettebooking-confirm-description desktop-only">Un email de confirmation vous a été envoyé.</div>
      <div class="c-lafourchettebooking-confirm">
        <picture class="c-lafourchettebooking-confirm-picture" data-alt="" data-default-src="img/layout/lafourchette/lafourchette-restaurants-item-mobile.jpg">
          <source media="(min-width: 1025px)" srcset="img/layout/lafourchette-confirmation.jpg">
          <source media="(min-width: 481px)" srcset="img/layout/lafourchette-confirmation.jpg">
          <source media="(max-width: 480px)"  srcset="img/layout/lafourchette/lafourchette-restaurants-item-mobile.jpg">
          <img src="" alt="">
        </picture>
        <div class="c-lafourchettebooking-confirm-content">
          <div class="c-lafourchettebooking-confirm-title mobile-only">NOUS AVONS BIEN PRIS EN COMPTE VOTRE RÉSERVATION</div>
          <div class="c-lafourchettebooking-confirm-description mobile-only">Un email de confirmation vous a été envoyé.</div>
          <div class="c-lafourchettebooking-confirm-details">
            <div class="c-lafourchettebooking-confirm-details-title">Restaurant & dates :</div>
            <div class="c-lafourchettebooking-confirm-details-description">Le {{ choices.hour.datetime | formatFullDate }} à {{ choices.hour.datetime | formatHour }}</div>
          </div>
          <div class="c-lafourchettebooking-confirm-details">
            <div class="c-lafourchettebooking-confirm-details-title">N° de réservation :</div>
            <div class="c-lafourchettebooking-confirm-details-description">{{ reservationData.id_reservation }}</div>
          </div>
          <div class="c-lafourchettebooking-confirm-details">
            <div class="c-lafourchettebooking-confirm-details-title">Informations personnelles :</div>
            <div class="c-lafourchettebooking-confirm-details-description">
              <span v-if="choices.title === '0'">M.</span>
              <span v-if="choices.title === '1'">Mme</span>
              {{ choices.firstName }} {{ choices.lastName }}
              <br>
              {{ choices.phone }}
              <br>
              {{ choices.email }}
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</form>
