class MEA3 {

    constructor(el) {
        this.el = $(el);
        this.moveTitles();
        this.setEvents();
        this.mea3_title;
        this.mea3_subtitle;
        this.isMobile = false;
    }

    moveTitles() {
        var device;
        device = this._getCurrentDevice();

        var mea3_title = this.el.find('.mea3-banner').attr('data-title');
        var mea3_subtitle = this.el.find('.mea3-banner').attr('data-subtitle');
        var $header_title = this.el.find('.mea3-header-title');
        var $banner_title = this.el.find('.mea3-banner-title');
        var $header_subtitle = this.el.find('.mea3-header-subtitle');
        var $banner_subtitle = this.el.find('.mea3-banner-subtitle');

        if (device === 'mobile' && $(window).width() < 480) {
            $header_title.text(mea3_title);
            $header_subtitle.text(mea3_subtitle);
            $banner_title.empty();
            $banner_subtitle.empty();
        }
        else {
            $banner_title.text(mea3_title);
            $banner_subtitle.text(mea3_subtitle);
            $header_title.empty();
            $header_subtitle.empty();
        }
    }


    _getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    debounce(func, wait, immediate = false) {
        var timeout;

        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }

    setEvents() {
        $(window).on("resize.MEA3", this.debounce(this.onWindowResize.bind(this), 150));
    }

    onWindowResize() {
        this.moveTitles();
    }

}
export default MEA3;