class TABS {
    constructor(el) {
        this.$el = $(el);
        this.device = this._getCurrentDevice();
        if (this.device === "desktop") {
            this._setContainerHeightByTabIndex(0);
        }
        this._setEvents();
    }

    _deactivateAll() {
        this.$el.find(".tabs-list-item.is-active").removeClass("is-active");
    }

    _getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    _onTabClick(e) {
        var $tab,
            $tabHeader,
            device,
            scrollPosition,
            tabIndex;

        this._deactivateAll();
        device = this.device;
        $tabHeader = $(e.currentTarget);
        $tab = $tabHeader.parent();
        $tab.addClass("is-active");
        if (device === "tablet" || device === "mobile") {
            scrollPosition = $tabHeader.offset().top - $tabHeader.outerHeight();
            $("html, body").animate({scrollTop: scrollPosition}, 300);
        }
        else {
            tabIndex = this.$el.find(".tabs-list-item").index($tab);
            this._setContainerHeightByTabIndex(tabIndex);
        }
    }

    _setContainerHeightByTabIndex(tabIndex) {
        var $tab,
            $tabContent,
            $tabHeader,
            height;

        $tab = this.$el.find(`.tabs-list-item:nth-child(${tabIndex + 1})`);
        $tabContent = $tab.children(".tabs-list-item-content");
        $tabHeader = $tab.children(".tabs-list-item-header");
        height = $tabContent.outerHeight() + $tabHeader.outerHeight();
        this.$el.css("height", height + "px");
    }

    _setEvents() {
        this.$el.find(".tabs-list-item-header").on("click", this._onTabClick.bind(this));
    }
}
export default TABS;