class MEA1LOCAL {
    constructor($el) {
        var device;
        device = this.getCurrentDevice();
        this.$el = $el;
        this.$carousel = $(".mea1-jackpot-car");
        this.isFlickity = false;
        if (device !== "desktop" && $(window).width() <= 1024) this.initCarousel();
        this.setEvents();
        this.scrollListener();
        this.countUp();
    }

    countUp() {
        $('.countup').each(function () {
            var delay = $(this).attr('data-delay');
            var nbrlen = $(this).attr('data-nbrlen');
            $(this).prop('Counter', 0).delay(delay).animate({
                Counter: $(this).attr('data-number')
            }, {
                duration: 1000,
                //easing: 'swing',
                step: function (now) {
                    var nbr = Math.ceil(now);
                    while((""+nbr).length < nbrlen) nbr = "0" + nbr;
                    $(this).html(nbr.toString());
                },
                complete: function () {
                    $(this).parent().removeClass("is-blurred");
                }
            });
        });
    }

    debounce(func, wait, immediate = false) {
        var timeout;
        return function () {
            var context = this, args = arguments;
            var later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }

    destroyCarousel() {
        //$(".mea6-item").css('left', '0');
        if (this.isFlickity) {
            //$(".mea6-item").css('left', '0');
            this.$carousel.flickity('destroy');
            this.isFlickity = false;
            setTimeout(function () {
                //$(".mea6-item").css('left', '0');
            }, 1200);
        }
    }

    getCurrentDevice() {
        return window.getComputedStyle(document.querySelector("body"), "::before").getPropertyValue("content").replace(/"|'/g, '');
    }

    initCarousel() {
        this.$carousel.flickity({
            wrapAround: true,
            autoPlay: true,
            pauseAutoPlayOnHover: false,
            pageDots: false,
            prevNextButtons: false
        });
        this.isFlickity = true;

        // resume autoplay
        var flkty = this.$carousel.data('flickity');
        this.$carousel.on('settle', function () {
            if (!flkty.player.isPlaying) flkty.player.play();
        })
    }

    setEvents() {
        $(window).on("resize.MEA1LOCAL", this.debounce(this.onWindowResize.bind(this), 150));
    }

    onWindowResize() {
        var device = this.getCurrentDevice();
        (device === "desktop" || $(window).width() > 1024) ? this.destroyCarousel() : this.initCarousel();
    }

    scrollListener() {
        $(window).scroll(function () {
            var s = $(window).scrollTop();
            $('.mea1-jackpot').css('background-position', ' 0 ' + -s / 8 + 'px');
        });
    }
}
export default MEA1LOCAL;